unit Balldefs;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls,
     Buttons, IniFiles,SysUtils,ExtCtrls;

type
  TSetupBalls = class(TForm)
    Ok: TBitBtn;
    Cancel: TBitBtn;
    GroupBox2: TGroupBox;
    SetPwd: TBitBtn;
    PwdTypes: TComboBox;
    GroupBox1: TGroupBox;
    Image1: TImage;
    Label3: TLabel;
    Label1: TLabel;
    MaxBalls: TScrollBar;
    MaxBallVal: TLabel;
    Label2: TLabel;
    BSize: TScrollBar;
    BSizeVal: TLabel;                                      { Bitmap of the Message }
    procedure FormCreate(Sender: TObject);
    procedure CancelClick(Sender: TObject);
    procedure OkClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure SetPwdClick(Sender: TObject);
    procedure PwdTypesChange(Sender: TObject);
    procedure MaxBallsChange(Sender: TObject);
    procedure BSizeChange(Sender: TObject);
  private
    Loading : Boolean;
    { Private declarations }
  public

    { Public declarations }
  end;

var
  SetupBalls : TSetupBalls;
  Ini   : TIniFile;

implementation

Uses Globals, NewPass, CodeBall, SelectSs ;

{$R *.DFM}


procedure TSetupBalls.FormCreate(Sender: TObject);
begin
  Loading := True;                                         { We are Loading }
end;


procedure TSetupBalls.CancelClick(Sender: TObject);
begin
  Close;                                                   { Bye Bye }
end;

procedure TSetupBalls.OkClick(Sender: TObject);
Var
  Fnt : Integer;                                           { Temp for font style }
begin
  Ini := TIniFile.Create('CONTROL.INI');                   { Create the Ini file }
  Ini.WriteInteger(AppTitle,'PwdType',PwdTypes.ItemIndex); { Write the Password Type }
  Ini.WriteInteger(AppTitle,'MaxBalls',MaxBalls.Position); { Write the Max Ball b4 clear }
  Ini.WriteInteger(AppTitle,'BallSize',BSize.Position);    { Write the Ball size }
  Close;
end;

procedure TSetupBalls.FormActivate(Sender: TObject);
begin
  If Loading then begin                                    { App is loading }
    Loading := False;                                      { Reset Flag }
    ReadBallDefaults;                                      { Read our Defaults }
    PwdTypes.ItemIndex := PwdType;                         { Set Password Type }
    MaxBalls.Position := BallMax;                          { Set Val }
    MaxBallVal.Caption := IntToStr(BallMax);               { Set the Balls b4 clear }
    BSize.Position := BallSize;                            { Set Size }
    BSizeVal.Caption := IntToStr(BallSize);                { Set Size }
    BSize.Tag := BallSize;                                 { Tag for later }
  end;
end;

procedure TSetupBalls.SetPwdClick(Sender: TObject);        { Set Pwd Type }
begin
  ChPwd := TChPwd.Create(Application);                     { Create the Dialog }
  if Pwd = '' then begin                                   { If NO Password }
    ChPwd.OldPwd.Enabled := False;                         { No Old Password }
    ChPwd.NewPwd.Enabled := True;                          { Enable New Password }
    ChPwd.Rpwd.Enabled := True;                            { Enable Retype password }
    end
  else begin
    ChPwd.OldPwd.Enabled := True;                          { Have PWD so enable OLD password }
    ChPwd.NewPwd.Enabled := False;                         { Disable NEW till old entered }
    ChPwd.Rpwd.Enabled := False;                           { Disable Retypr till Old Entered }
    end;
  ChPwd.ShowModal;                                         { Do the dialog }
  ChPwd.Free;                                              { Free the dialog }
end;

procedure TSetupBalls.PwdTypesChange(Sender: TObject);     { Changing Pwd Types }
begin
  If PwdTypes.ItemIndex = 1 then                           { If a WINDOWS password }
    SetPwd.Enabled := True                                 { Enable setting }
  else
    SetPwd.Enabled := False;                               { others can't be set so disable }

end;


procedure TSetupBalls.MaxBallsChange(Sender: TObject);
begin
  MaxBallVal.Caption := IntToStr(MaxBalls.Position);       { Set new Value }
end;

procedure TSetupBalls.BSizeChange(Sender: TObject);
begin
  BSizeVal.Caption := IntToStr(BSize.Position);            { Set New Value }
end;

begin
end.
