unit Codespot;

interface

Uses
  WinProcs,
  WinTypes,
  Graphics,
  IniFiles,
  Classes;

Var
  zx, zy      : Integer;                                   { Screen Width and Height }
  cx, cy      : Integer;                                   { Spot Pos }
  vx, vy, d   : integer;                                   { Accel amd Width }
  Desktop     : hBitmap;                                   { Desktop bitmap }

Procedure InitSpot;                                        { Inti routine }
Procedure ReadSpotDefaults;                                { Read the spot defaults }
Procedure DrawSpot;                                        { Draw It }
Procedure FreeSpot;                                        { Free resources }

implementation

Uses
  SSave,
  Globals;

Procedure InitSpot;
var
  WinDC, MemDC: hDC;                                       { Local DC's }

begin
  ReadSpotDefaults;                                        { Read Defaults }
  zx := ScreenWd;                                          { get Width }
  zy := ScreenHt;                                          { Get Height }
  randomize;                                               { Ramdom init }
  cx := random (zx div 2) + 1;                             { get starting x }
  cy := random (zy div 2) + 1;                             { get starting y }
  vx := -1 + 2 * random (2);                               { get speed: }
  vy := -1 + 2 * random (2);                               { vx, vy = 1 or -1 }
  d  := SpotSize;                                          { diameter }

  WinDC := GetDC (GetDeskTopWindow);                       { copy actual video RAM.. }
  MemDC := CreateCompatibleDC (WinDC);                     { Get Compatible DC }
  Desktop := CreateCompatibleBitmap (WinDC, zx, zy);       { Create the Bitmap }
  SelectObject (MemDC, Desktop);                           { Select it }
  BitBlt (MemDC, 0, 0, zx, zy, WinDC, 0, 0, SRCCOPY);      { Now copy the desktop }
  DeleteDC (MemDC);                                        { Free it }
  ReleaseDC (GetDeskTopWindow, WinDC);                     { Release the Desktop DC }
End;

Procedure DrawSpot;                                        { Draw the spot light }
var
  WinDC, MemDC: hDC;                                       { Local DC's }
  CircleRgn, BackGndRgn: hRgn;                             { Local Regions }

begin
  WinDC := GetDC (Scrn.Handle);                            { Get Screen DC }
  MemDC := CreateCompatibleDC (WinDC);                     { Get compat }
  SelectObject (MemDC, Desktop);                           { get a DC with desktop bitmap }

  if ((cx <= 0) or (cx+d >= zx)) then vx := -vx;           { bounce light at X edges }
  if ((cy <= 0) or (cy+d >= zy)) then vy := -vy;           { bounce light at Y edges }
  cx := cx+vx;                                             { calculate new X position }
  cy := cy+vy;                                             { calculate new Y position }

  CircleRgn := CreateEllipticRgn (cx, cy, cx+d, cy+d);     { Build the "spotlight region"  }
  BackGndRgn := CreateRectRgn (cx-2, cy-2,
                               cx+d+2, cy+d+2);            { Get Region aroubnd Spot }
  CombineRgn (BackGndRgn, BackGndRgn, CircleRgn,
                   RGN_DIFF);                              { Get Combination }
  FillRgn (WinDC, BackGndRgn,
                          GetStockObject (black_brush));   { Fill it black }

  SelectObject (WinDC, CircleRgn);                         { clipping region }
  BitBlt (WinDC, 0, 0, zx, zy, MemDC, 0, 0, SRCCOPY);      { copy bitmap -> screen }

  DeleteDC (MemDC);                                        { Release }
  ReleaseDC (Scrn.Handle, WinDC);                          { Release }
  DeleteObject (CircleRgn);                                { Drop Object }
  DeleteObject (BackGndRgn);                               { Drop Object }
  Delay(SpotSpeed);                                        { Delay if required }
end;

Procedure FreeSpot;                                        { Free resources }
Begin
  DeleteObject (Desktop);                                  { Drop the desktop bitmap }
End;

Procedure ReadSpotDefaults;                                { Read defaults }
Var
  Ini : TiniFile;                                          { The Ini file }
Begin
  Ini := TIniFile.Create('CONTROL.INI');                   { Open the Ini File }
  Apptitle := 'Screen Saver.Delphi Spot';                  { Set title }
  PwdType := Ini.ReadInteger(AppTitle,'PwdType',0);        { Get the Password Type }
  SpotSpeed := Ini.ReadInteger(AppTitle,'Speed',0);        { Get Delay in MS }
  SpotSize := Ini.ReadInteger(AppTitle,'Size',100);        { Get the Size }
  Pwd := Ini.ReadString('ScreenSaver','Password','');      { Read the Password, if any }
End;

end.
