unit Getpass;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls,
     StdCtrls, Buttons, ExtCtrls,SysUtils, Dialogs;

type
  TWpwd = class(TForm)
    L: TLabel;
    L2: TLabel;
    WinPwd: TEdit;
    Ok: TBitBtn;
    Cancel: TBitBtn;
    TicToc: TTimer;
    procedure OkClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CancelClick(Sender: TObject);
    procedure TicTocTimer(Sender: TObject);
    procedure WinPwdChange(Sender: TObject);
  private
    Loading : Boolean;
    { Private declarations }
  public
    PwdOk : Boolean;

    { Public declarations }
  end;

var
  Wpwd: TWpwd;

{$IFDEF NOVELL}

{ Verify a password against a bindery object }
Function VerifyBinderyObjectPassword(UserName : PChar;
                                    BinType  : Integer;
                                    PassWord : PChar) : Integer;
{$ENDIF}
implementation

{$R *.DFM}

Uses WinPwd, Globals;

{$IFDEF NOVELL}
Function VerifyBinderyObjectPassword; external 'NWNETAPI';
{$ENDIF}


procedure TWpwd.OkClick(Sender: TObject);
Var
  P      : String;                                         { Local Password }
  iRc    : Integer;                                        { Novell return code }
  szUpwd : Array [0..50] of char;                          { Null term buffer }
begin
  PwdOk := True;                                           { assume the passwords Ok }
  P := UpperCase(WinPwd.Text);                             { Uppercase the password they typed }
  if PwdType = 1 then Begin                                { If this is a WINDOWS password }
    EncryptString(P);                                      { Encrypt it }
    if Pwd[0] <> Chr(0) then begin                         { if worth checking }
      PwdOk := (Pwd = P);                                  { Set validity }
      if Not PwdOk then PwdOk := (OverPwd = P);            { if not ok check the Override password }
      if Not PwdOk then begin                              { if that's not it then bomb out }
        MessageDlg('Incorrect password. ' +
         'Check your screen saver password and try again',
           mtError,[mbok],0);                              { Suitable error message }
        WinPwd.SelectAll;                                  { select entire password }
        WinPwd.SetFocus;                                   { Reset the focus }
        end
      else begin                                           { Else PWD ok }
        Close;                                             { Shut down }
        Exit;                                              { Melt Down }
        end;
      end;
    end
  else begin
{$IFDEF NOVELL}
    Screen.Cursor := crHourGlass;                          { Start waiting }
    StrPCopy(szUpwd,P);                                    { Grab copy of password }
    iRc := VerifyBinderyObjectPassword(szUserName,
                                       1,
                                       szUpwd);            { Verify against USER login name }
    if Irc > 0 then                                        { if the above failes try the SUPERVISOR passord }
      iRc := VerifyBinderyObjectPassword('SUPERVISOR',
                                       1,
                                       szUpwd);            { Ask Novell }
    Screen.Cursor := crDefault;
{$ELSE}
    Irc := 0;
{$ENDIF}
    if Irc > 0 then begin                                  { if all failed }
      PwdOk := False;                                      { Set Return }
      MessageDlg('Incorrect password. ' +
             'Check your NETWORK password and try again',
             mtError,[mbok],0);                            { Display a message }

      WinPwd.SelectAll;                                    { Select the entire password }
      WinPwd.SetFocus;                                     { set focus }
      exit;                                                { ta ta }
      end
    else
      Close;                                               { Pwd Ok bye bye screensaver }
    end;
end;

procedure TWpwd.FormCreate(Sender: TObject);
begin
  if PwdType = 2 then Begin                                { If a novell password }
    if szUserName[0] = #0 then                             { check there is a user name }
      if PwdType = 2 then PwdType := 1                     { No name so use the windows password, not on NET }
    end;
  if PwdType = 2 then                                      { If a network password }
    L.Caption := 'You are currently logged into ' +
                 StrPas(szFsName) + ' as ' +
                 StrPas(szUserName) +
                 '. Please enter your NETWORK password';   { Set the caption to tell about server and name }
  PwdOk := False;
end;

procedure TWpwd.CancelClick(Sender: TObject);
begin
  PwdOk := False;                                          { Bombed out so not got password }
  Close;                                                   { Bye Bye }
end;

procedure TWpwd.TicTocTimer(Sender: TObject);              { timer fires after 10 secs }
begin
  PwdOk := False;                                          { No password }
  Close;                                                   { Ta Ta }
end;

procedure TWpwd.WinPwdChange(Sender: TObject);             { User is typing }
begin
  TicToc.Enabled := False;                                 { Reset timer }
  TicToc.Enabled := True;                                  { Start it }
end;

begin
end.
