unit Login;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, SysUtils, IniFiles;

type
  TLoginDLG = class(TForm)
    Label1: TLabel;
    Password: TEdit;
    CancelBtn: TBitBtn;
    Label2: TLabel;
    UserName: TEdit;
    Label3: TLabel;
    HostName: TEdit;
    OKBtn: TBitBtn;
    AddBtn: TButton;
    DeleteBtn: TButton;
    Label4: TLabel;
    Profile: TComboBox;
    ModifyBtn: TButton;
    Label5: TLabel;
    Account: TEdit;
    Label6: TLabel;
    Directory: TEdit;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ProfileChange(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure DeleteBtnClick(Sender: TObject);
    procedure ModifyBtnClick(Sender: TObject);
  private
    procedure RefreshComboBox;
  public
  end;

var
  LoginDLG: TLoginDLG;
implementation

{$R *.DFM}

procedure TLoginDLG.FormShow(Sender: TObject);
begin
  HostName.SetFocus;
end;

procedure TLoginDLG.FormCreate(Sender: TObject);
begin
  RefreshComboBox;
end;

procedure TLoginDLG.ProfileChange(Sender: TObject);
var
  ftpini: TIniFile;
  CurSel: string;
begin
  ftpini := TIniFile.Create('FTPPROF.INI');
  CurSel := Profile.Items[Profile.ItemIndex];
  HostName.Text := ftpini.ReadString(CurSel,'HostName','');
  UserName.Text := ftpini.ReadString(CurSel,'UserName','');
  Password.Text := ftpini.ReadString(CurSel,'Password','');
  Account.Text := ftpini.ReadString(CurSel,'Account','');
  Directory.Text := ftpini.ReadString(CurSel,'Directory','');
end;

procedure TLoginDLG.AddBtnClick(Sender: TObject);
var
  Next, Section: string;
  ftpini: TIniFile;
begin
  ftpini := TIniFile.Create('FTPPROF.INI');
  Next := ftpini.ReadString('index','next','');
  if Next = '' then
  begin
    ftpini.WriteString('index','next','0');
    Next := '0';
  end;
  Section := 'Profile'+Next;
  ftpini.WriteString('index',Section,Profile.Text);
  ftpini.WriteString(Profile.Text,'HostName',HostName.Text);
  ftpini.WriteString(Profile.Text,'UserName',UserName.Text);
  ftpini.WriteString(Profile.Text,'Password',Password.Text);
  ftpini.WriteString(Profile.Text,'Account',Account.Text);
  ftpini.WriteString(Profile.Text,'Directory',Directory.Text);
  Next := IntToStr(StrToInt(Next)+1);
  ftpini.WriteString('index','next',Next);
  Profile.Items.Add(Profile.Text);
end;

procedure TLoginDLG.DeleteBtnClick(Sender: TObject);
var
  ftpini: TIniFile;
  i, iNext: integer;
  item: string;
  Next: string;
begin
  ftpini := TIniFile.Create('FTPPROF.INI');
  ftpini.EraseSection(Profile.Text);
  Next := ftpini.ReadString('index','next','');
  if Next = '' then
    exit;
  iNext := StrToInt(Next);
  for i:=0 to iNext do
  begin
    item := ftpini.ReadString('index','Profile'+IntToStr(i),'');
    if item <> '' then
      if item = Profile.Text then
        break;
  end;
  if item <> '' then
    ftpini.WriteString('index','Profile'+IntToStr(i),'');
  RefreshComboBox;
end;

procedure TLoginDLG.ModifyBtnClick(Sender: TObject);
var
  ftpini: TIniFile;
begin
  ftpini := TIniFile.Create('FTPPROF.INI');
  ftpini.WriteString(Profile.Text,'HostName',HostName.Text);
  ftpini.WriteString(Profile.Text,'UserName',UserName.Text);
  ftpini.WriteString(Profile.Text,'Password',Password.Text);
  ftpini.WriteString(Profile.Text,'Account',Account.Text);
  ftpini.WriteString(Profile.Text,'Directory',Directory.Text);
end;

procedure TLoginDLG.RefreshComboBox;
var
  i, iNext: integer;
  item, Next: string;
  ftpini: TIniFile;
begin
  Profile.Clear;
  ftpini := TIniFile.Create('FTPPROF.INI');
  Next := ftpini.ReadString('index','next','');
  if Next = '' then
  begin
    ftpini.WriteString('index','next','0');
    Next := '0';
  end;
  iNext := StrToInt(Next);
  for i:=0 to iNext do
  begin
    item := ftpini.ReadString('index','Profile'+IntToStr(i),'');
    if item <> '' then
      Profile.Items.Add(item);
  end;
  Profile.ItemIndex := 0;
  ProfileChange(self);
end;

end.

