(******************************************************************************

	DEMO x3270 for Borland Delphi
                Version 2.0
           (all rights reserved)

	Software by:

			Mauro Tronto
			Via Jesi, 43
			60127 ANCONA (ITALY)

			Home: (39)-71-890604
			CompuServe ID: 100103,2660
                        Internet: 100103.2660@compuserve.com

                Date: 11/07/95 21.21.21

******************************************************************************)
program xDemo;

uses x3270 in 'x3270.pas'; { Uses of x3270 unit file - T3270 class } ;

(*
 *  This is an application framework that interacts with host session(s)
 *  under 3270 emulation software. Look up carefully!
 *)
 var h: T3270;

(*
 *  When you start running an application that interacts with host session
 *  you must reset all 3270 system parameters to standard value.
 *)
 HResetSystem;

(*
 *  For the first time, you must instantiate an x3270 object that relate to
 *  unique host session shortname, such as "E".
 *  See the example below:
 *)
 h := T3270.Create( 'E' );

(*
 *  If you don't know anyone of your shortname sessions, don't worry!
 *  x3270 automatically check your environment and connect to the first
 *  host session available. See the example below:
 *)
 h := T3270.Create( '' );

(*
 *   You can now verify the integrity object by testing an instance
 *   variable named > InitOK <.
 *)
 if not h.InitOK then
   h.ShowResult;

(*
 *   But..what is the method ShowResult ... ?
 *
 *   After calling any methods, x3270 set an export instance variable named
 *   > Status < that contains an internal object that describe the status
 *   of object itself.
 *
 *   x3270 has an INTERNAL DICTIONARY that contains ALL standard IBM RETURN
 *   CODE AND RELATED EXPLANATIONS.
 *
 *   So, after calling any methods that interact with low-level subsystem,
 *   you can verify return code in the Status.Number property and read a
 *   Status.Description property for detail informations.
 *
 *   Furthermore, there is a method ShowResult that use the instance
 *   variable "status" and show it in a dialog box.
 *)
 h.Status.Number;
 h.Status.Description;
 MessageDlg( h.Status.Description, mtInformation, [mbOK], 0 );

(*
 *   Now, you are shure that everythink works fine!
 *   So, you can see for example some host properties that are encapsulated
 *   in your T3270 object. See the example below:
 *)
 h.Shortname              { Shortname of host session }
 h.Longname               { Longname of host session  }
 h.Rows                   { Rows number of 3270 display }
 h.Columns                { Columns number of 3270 display }
 h.SizeOfPS               { Size (bytes) of presentation space }

(*
 *   You can check the correct host position where your application
 *   must start by method SearchString that return the host position
 *   where an occurrence of relate string start (otherwise return 0).
 *   See the example below:
 *)
 if h.SearchString( 'ENTER APPLICATION REQUEST' ) = 0 then
   MessageDlg( 'Must be at the VTAM Screen for logging into TSO' ... );

(*
 *   You can also specify the position where the searching must start!
 *   See the example below:
 *)
 if not h.SearchAt( 'ENTER APPLICATION REQUEST', 50 ) then
   MessageDlg( 'Must be at the VTAM Screen for logging into TSO' ... );

(*
 *   Question: Can i send a string onto host ?
 *             Can i send AID keystrokes, such as PA1, PF3 and so on ?
 *
 *   Yes! You can use methods SendKey and WriteAt().
 *
 *   For AID keystrokes you must use Sendkey while WriteAt() is more
 *   efficient for sending strings onto host.
 *
 *   About AID, all keys are availables by x3270 constants. So you can
 *   relate to KEY_ENTER, KEY_PF3, KEY_PA1 without coding any host sequence.
 *
 *   See the examples below:
 *)
 if h.SendKey( KEY_ENTER ) then			{ AID keystroke }
   MessaDlg( 'AID sequence has been sent!' ... );

 if h.WriteAt( 'LOGOUT', 50 ) then		{ Very efficient method }
   MessaDlg( 'LOGOUT sequence has been sent!' ... );

(*
 *   Question: Can i copy all or part of host screen in an application buffer ?
 *
 *   You can use methods CopyScreen and CopyScreenAttr.
 *   Either methods return a char pointer (pChar) to a buffer that contains
 *   host image. You MUST release memory after using it with FreeMem function.
 *
 *   See the examples below:
 *)
 buffer := h.CopyScreen;		{ Copy all host screen }
 buffer := h.CopyScreenAttr;		{ Copy all host screen with attributes }
  ...
 FreeMem( buffer, Strlen(buffer) + 1 ); { Release memory in global heap }

(*
 *   Question: Can i work with host fields ?
 *   There are many methods that allow you to working with host fields.
 *   See the examples below:
 *)
 nPos := h.FieldLocate( 'NU' );

 h.FieldGetAt( nPos );
 h.FieldPutAt( 'ciao', nPos );
 h.FieldLengthAt( nPos );
 h.FieldAttributeAt( nPos );
 h.FieldNumericAt( nPos );
 h.FieldCharacterAt( nPos );
 h.FieldProtectedAt( nPos );
 h.FieldUnProtectedAt( nPos );
 h.FieldUpdatedAt( nPos );
 h.FieldHiColorAt( nPos );
 h.FieldLowColorAt( nPos );
 h.FieldSkip;

(*
 *   How you can see, you have TOTAL CONTROL over host fields inside your
 *   VO applications.
 *
 *   Perhaps, you can relate to current host CURSOR POSITION instead of
 *   specified position, such as <nPos>. So, if you are working with host
 *   fields, you can use "cursor methods" and relate to fields by actual
 *   host cursor position.
 *
 *   See the examples below:
 *)
 h.CurrentPosition;         { Read host cursor position }
 h.CursorAt( 45 );          { Set/Move host cursor position }

(* Refer now to host position 45!
 *)
 h.FieldGet;
 h.FieldPut( 'ciao' );
 h.FieldLength;
 h.FieldAttribute;
 h.FieldNumeric;
 h.FieldCharacter;
 h.FieldProtected;
 h.FieldUnProtected;
 h.FieldUpdated;
 h.FieldHiColor;
 h.FieldLowColor;

(*
 *   Question: Can i work with row/pos instead of host position ?
 *             My emulator software show me in the right end corner the
 *             actual host cursor position referred as row/col.
 *             This is very useful!
 *
 *   ALL x3270 methods are based on host position, but there are some
 *   methods that allow you to convert host cursor position to row/col
 *   and vice versa.
 *
 *   See the examples below:
 *)
 h.Row;
 h.Col;
 h.ConvertRowCol( 10,45 );

(* So, you can write ...
 *)
 h.WriteAt( 'LOGOUT', h.ConvertRowCol( 10,45 ) );

(*
 *   You can control keyboard under Delphi applications.
 *   So, the users cannot modify the status of host sessions while
 *   running the application. See the examples below:
 *)
 h.LockKeyboard;
 h.UnlockKeyboard;

(*
 *   You can verify the insert status of host session.
 *   See the examples below:
 *)
 h.InsertMode;

(*
 *   You can verify the Caps Lock status of host session.
 *   See the examples below:
 *)
 h.CapsLock;

(*
 *   You can verify many other informations by operator information area.
 *   See the examples below:
 *)
 h.OperInfoArea;

(*
 *   When application started, whe have calling function ResetSystem().
 *   There are many others functions that allow you to fetch informations
 *   about the configuration environment.
 *
 *   See the examples below:
 *)
 HQuerySessions;
 HQuerySystem;

(*
 *   After calling the functions above, you can verify the result by
 *   reading SysNumber and SysDesc environment variables.
 *   This properties allow you to obtain informations as well as the status
 *   property of T3270 object.
 *
 *   See the examples below:
 *)
 if not HResetSystem then
   MessaDlg( SysDesc, mtInformation, [mbOK], 0 );

(*
 *  If you have configured your Workstation emulation program for supporting
 *  more than one host sessions, you can instatiate more than one T3270
 *  object with a unique shortname, such as "E" or "F".
 *  Than, you can work with us SIMULTANEOUSLY!
 *  See the example below:
 *)
 host_e := T3270.Create( 'E' );
 host_f := T3270.Create( 'F' );

 host_e:SendKey( KEY_ENTER );
 host_f:SendKey( KEY_CLEAR );

(*
 *  Well, at this point we can shutdown this read me file!
 *  Thank you very much for your attentions!
 *  Create fun!
 *)
 h.Disconnect; h.Free;
