unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, FileCtrl,
  FMxUtil2, ExtCtrls, Menus;

type
  TMainForm = class(TForm)
    CopyFiles: TButton;
    SourceDirectory: TDirectoryListBox;
    DestinationDirectory: TDirectoryListBox;
    Label1: TLabel;
    Label2: TLabel;
    SourceDrive: TDriveComboBox;
    DestinationDrive: TDriveComboBox;
    SourceFiles: TFileListBox;
    DestinationFiles: TFileListBox;
    Panel1: TPanel;
    NoBackups: TCheckBox;
    NoPictures: TCheckBox;
    NoBinaries: TCheckBox;
    Label3: TLabel;
    SourcePath: TLabel;
    DestinationPath: TLabel;
    FIleCount: TLabel;
    FilesLength: TLabel;
    GaugeCounter: TLabel;
    ButtonHelp: TButton;
    ButtonMkDir: TButton;
    ButtonExit: TButton;
    PopupMenu1: TPopupMenu;
    Hints: TMenuItem;
    Free: TLabel;
    Button1: TButton;
    procedure ButtonExitClick(Sender: TObject);
    procedure SourceDriveChange(Sender: TObject);
    procedure DestinationDriveChange(Sender: TObject);
    procedure CopyFilesClick(Sender: TObject);
    procedure SourceDirectoryChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure NoBinariesClick(Sender: TObject);
    procedure NoBackupsClick(Sender: TObject);
    procedure NoPicturesClick(Sender: TObject);
    procedure ButtonHelpClick(Sender: TObject);
    procedure ButtonMkDirClick(Sender: TObject);
    procedure HintsClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure DestinationDirectoryChange(Sender: TObject);
  private
    { Private-Deklarationen }
    IniFilename : String;
    AccessDenied: Boolean;
    procedure FilterFileList;
    procedure ShowFreeBytes;
    procedure CheckForEqualPath;
  public
    { Public-Deklarationen }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses DialMDir, About, IniFiles;


procedure tMainForm.ShowFreeBytes;
var
  FreeBytes:Longint;
begin
FreeBytes:=DiskFree(Ord(DestinationDrive.Drive)-Ord('a')+1);
if FreeBytes>=0 then
  Free.Caption:=IntToStr(FreeBytes div 1024)+' KB free'
else
  Free.Caption:='0';
end;

procedure tMainForm.CheckForEqualPath;
  begin
  if (SourceDrive.Drive=DestinationDrive.Drive) and
     (SourceDirectory.Directory=DestinationDirectory.Directory) then
      begin
      AccessDenied:=True;
      DestinationDirectory.Color:=clRed;
      DestinationFiles.Color:=clRed;
      end
    else
      begin
      AccessDenied:=False;
      DestinationDirectory.Color:=clWindow;
      DestinationFiles.Color:=clWindow;
      end;
  end;


procedure tMainForm.FilterFileList;
  var i:integer;
      FileExt:string;
      DeleteFlag:Boolean;
      Sum:LongInt;
  begin
  SourceFiles.Update;
  With SourceFiles.Items do
    for i:=Count-1 downto 0 do
      begin
      FileExt:=ExtractFileExt(Strings[i]);
      DeleteFlag:=False;
      if NoBinaries.State=cbChecked then
        if (FileExt='.exe') or (FileExt='.dcu')
        or (FileExt='.dsk') or (FileExt='.dsm') then DeleteFlag:=True;
      if NoBackups.State=cbChecked then
        if (FileExt='.~df') or (FileExt='.~dp')
        or (FileExt='.~pa') then DeleteFlag:=True;
      if NoPictures.State=cbChecked then
        if (FileExt='.bmp') or (FileExt='.cur')
        or (FileExt='.ico') then DeleteFlag:=True;
      if DeleteFlag then Delete(i);
      end{for i};
  FileCount.Caption:='Files   : '+IntToStr(SourceFiles.Items.Count);
  Sum:=0;
  with SourceFiles do
    for i:=0 to Items.Count-1 do
      inc(Sum, GetFileSize(SourceDirectory.Directory+'\'+Items[i]) );
  FilesLength.Caption:='Length: '+IntToStr(Sum div 1024) + ' KB';
  end;


procedure TMainForm.ButtonExitClick(Sender: TObject);
begin
Close;
end;

procedure TMainForm.SourceDriveChange(Sender: TObject);
begin
SourceDirectory.Drive := SourceDrive.Drive;
CheckForEqualPath;
end;

procedure TMainForm.DestinationDriveChange(Sender: TObject);
var
  FreeBytes:Longint;
begin
ShowFreeBytes;
CheckForEqualPath;
end;

procedure TMainForm.CopyFilesClick(Sender: TObject);
var
  i:integer;
  DestinationPath: string;
  Continueing: Boolean;
begin
if AccessDenied then
  MessageDlg('Destination=source not allowed', mtError, [mbOK], 0)
else
  begin {copy selected files from source to destination}
  try
    MainForm.Cursor:=crHourGlass;
    GaugeCounter.Visible:=True;
    Application.ProcessMessages;
    DestinationPath:=DestinationDirectory.Directory;
    if DestinationPath[length(DestinationPath)]='\' then
      System.Delete(DestinationPath, length(DestinationPath), 1);
    Continueing:=True;
    i:=0;
    with SourceFiles do
      repeat
        GaugeCounter.Caption:=IntToStr(Items.Count-i);
        Application.ProcessMessages;
        ItemIndex:=i;
        try
          CopyFile(SourceDirectory.Directory+'\'+Items[i], DestinationPath);
        except
          on EFopenError do
            if mrNO=MessageDlg('This file is possibly opened by another' + #$0d +
                               'application and cant be copied.' + #$0d +
                               'Continue with following files ?',
                               mtError, [mbYes, mbNo], 0)
            then Continueing:=false;
        end{try except};
        DestinationFiles.Update;
        Application.ProcessMessages;
        inc(i);
      until (i>=Items.Count) or not Continueing;
  finally
    DestinationFiles.Update;
    GaugeCounter.Caption:='';
    GaugeCounter.Visible:=False;
    ShowFreeBytes;
    MainForm.Cursor:=crDefault;
  end{try finally};
  end{copy selected files};
end;

procedure TMainForm.SourceDirectoryChange(Sender: TObject);
begin
FilterFileList;
CheckForEqualPath;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  IniFile: TIniFile;
  Path, S : String;
  x,y,w,h:integer;
begin
{read ini file}
s:=Application.ExeName;
IniFilename:=ExtractFilePath(s) + ChangeFileExt(ExtractFileName(s), '.INI');

{section HINTS}
IniFile := TIniFile.Create(IniFilename);
ShowHint:=IniFile.ReadBool('HINT','show',True);
Hints.Checked:=ShowHint;
{section POSITION}
x:=IniFile.ReadInteger('POSITION','left',-1);
y:=IniFile.ReadInteger('POSITION','top',-1);
w:=IniFile.ReadInteger('POSITION','width',-1);
h:=IniFile.ReadInteger('POSITION','height',-1);
if (x<>-1) and (y<>-1) and (w<>-1) and (h<>-1) then
  begin
  Left:=x; Top:=y; Width:=w; Height:=h;
  Position:=poDesigned;
  end
else
  Position:=poScreenCenter;
{section PATH}
Path:=IniFile.ReadString ('PATH', 'source',      'c:\');
SourceDrive.Drive:=Path[1];
SourceDirectory.Directory:=Path;
Path:=IniFile.ReadString ('PATH', 'destination', 'c:\');
DestinationDrive.Drive:=Path[1];
DestinationDirectory.Directory:=Path;

IniFile.Free;

{process command line}
if ParamCount>0 then
  begin
  Path:=ParamStr(1);
  if Length(Path)>0 then
    begin
    SourceDrive.Drive:=Path[1];
    SourceDirectory.Directory:=Path;
    DestinationDrive.Drive:=Path[1];
    DestinationDirectory.Directory:=Path;
    end;
  end;

FilterFileList;
CheckForEqualPath;
end;

procedure TMainForm.NoBinariesClick(Sender: TObject);
begin
FilterFileList;
end;

procedure TMainForm.NoBackupsClick(Sender: TObject);
begin
FilterFileList;
end;

procedure TMainForm.NoPicturesClick(Sender: TObject);
begin
FilterFileList;
end;

procedure TMainForm.ButtonHelpClick(Sender: TObject);
const
  HelpViewer       = 'WRITE';
  HelpFileContents = 'HELP.WRI';
var
  Command,
  Path   : String[254];
  CmdStr : array [0..255] of Char;
  i      : integer;
begin
Path:=Application.ExeName;
Path:=ExtractFilePath(Path)+HelpFileContents;
if not FileExists(Path) then
  MessageDlg('Missing help file '+Path+'. See file README.TXT!',
    mtError, [mbOK], 0)
else
  begin
  Command:=HelpViewer+' '+Path;
  StrPCopy(CmdStr, Command);
  if WinExec(CmdStr, SW_SHOWNORMAL) < 32 then
    MessageDlg('Could not execute '+HelpViewer+'. See file README.TXT!',
      mtError, [mbOK], 0);
  end;
end;

procedure TMainForm.ButtonMkDirClick(Sender: TObject);
begin
with FormMkDir do
  begin
  with CurrentPath do
    begin
    Caption:=DestinationDirectory.Directory;
    if Caption[Length(Caption)]<>'\' then
      Caption:=Caption+'\';
    end;
  NewDir.Text:='';
  if (ShowModal=idOK) and (NewDir.Text<>'') then
    begin
    MkDir(CurrentPath.Caption + NewDir.Text);
    DestinationDirectory.Directory:=CurrentPath.Caption + NewDir.Text;
    end;
  end{with FormMkDir};
end;

procedure TMainForm.HintsClick(Sender: TObject);
begin
ShowHint:=not Hints.Checked;
Hints.Checked:=not Hints.Checked;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
var
  IniFile: TIniFile;
  S: String;
begin
IniFile := TIniFile.Create(IniFilename);
IniFile.WriteBool('HINT','show',ShowHint);

IniFile.WriteInteger('POSITION','left',  Left);
IniFile.WriteInteger('POSITION','top',   Top);
IniFile.WriteInteger('POSITION','width', Width);
IniFile.WriteInteger('POSITION','height',Height);

S:=SourceDirectory.Directory;
if S[1] in ['A','a','B','b'] then S:='c:\';
IniFile.WriteString ('PATH', 'source', S);
S:=DestinationDirectory.Directory;
if S[1] in ['A','a','B','b'] then S:='c:\';
IniFile.WriteString ('PATH', 'destination', S);

IniFile.Free;
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
AboutBox.ShowModal;
end;

procedure TMainForm.DestinationDirectoryChange(Sender: TObject);
begin
CheckForEqualPath;
end;

end.
