unit Fcheck;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
   StdCtrls, ExtCtrls,SysUtils;

type
  TCheckF = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Name: TEdit;
    Path: TEdit;
    Dire: TComboBox;
    Bevel2: TBevel;
    Copi: TCheckBox;
    Comp: TCheckBox;
    Label3: TLabel;
    Size: TEdit;
    Bevel3: TBevel;
    SizC: TEdit;
    Label4: TLabel;
    procedure CancelBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure Initialisation(Sender: TObject);
    procedure Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  CheckF: TCheckF;

implementation

uses Decla,Disque;

{$R *.DFM}

(* cancel button *)
procedure TCheckF.CancelBtnClick(Sender: TObject);
begin
 ModalResult := 2;
end;

(* Ok button *)
procedure TCheckF.OKBtnClick(Sender: TObject);
var Tmp : string;
    Err : integer;
begin
 with Transfert do
 begin
  Nom := Name.Text;
  case Dire.ItemIndex of
   0 : Pat := '%1';
   1 : Pat := '%W';
   2 : Pat := '%S';
   3 : Pat := Path.Text;
  else
   Pat := Path.Text;
  end;
  if Copi.State = cbChecked then Cop := 1
                            else Cop := 0;
  if Comp.State = cbChecked then Cmp := 1
                            else Cmp := 0;
  Tmp := Size.Text; Val (Tmp,Siz,Err);
  Tmp := SizC.Text; Val (Tmp,SzC,Err);
 end;
 ModalResult := 1;
end;

(* prepare dialog *)
procedure TCheckF.Initialisation(Sender: TObject);
begin
 Dire.Clear;
 Dire.Items.Add (tit_App);
 Dire.Items.Add (tit_Win);
 Dire.Items.Add (tit_Sys);
 Dire.Items.Add (tit_Oth);
 With Transfert do
 begin
  Name.Text := Nom;
  if Pat [1] = '%' then
  begin
   Case Pat [2] of
    '1' : begin
           Dire.ItemIndex := 0;
           Path.Text := ProjectDire;
          end;
    'W' : begin
           Dire.ItemIndex := 1;
           Path.Text := copy (WinDir,3,length (Windir) - 2);
          end;
    'S' : begin
           Dire.ItemIndex := 2;
           Path.Text := copy (SysDir,3,length (SysDir) - 2);
          end;
   else
    begin
     Dire.ItemIndex := 3;
     Path.Text := Pat;
    end;
   end;
  end
  else
  begin
   Dire.ItemIndex := 3;
   Path.Text := Pat;
  end;
  if Cop = 1 then Copi.State := cbChecked
             else Copi.State := cbUnChecked;
  if Cmp = 1 then Comp.State := cbChecked
             else Comp.State := cbUnChecked;
  Size.Text := IntToStr (Siz);
  SizC.Text := IntToStr (SzC);
 end;
end;

(* Change directory destination *)
procedure TCheckF.Change(Sender: TObject);
begin
 Case Dire.ItemIndex of
  0 : Path.Text := ProjectDire;
  1 : Path.Text := copy (WinDir,3,length (Windir) - 2);
  2 : Path.Text := copy (SysDir,3,length (SysDir) - 2);
  3 : Path.Text := '';
 end;
end;

end.
