/*   (C source follows this text)

Date: 22 Sep 91 09:41:53 EDT
From: Bruce Colletti <71121.1452@CompuServe.COM>
Subject: 3D Viewer
To: Oscar Garcia <garciao@MOF.GOVT.NZ>
Message-Id: <910922134153_71121.1452_DHJ35-1@CompuServe.COM>

Hi again Oscar.  I liked your 3D Viewer 2.5 so much that I created the
following program to construct the input *.3d files.  My program is
being posted to BBS' I find that have your Viewer.  Per your written
instructions, I am not modifying your original distribution file to
include mine.  However, the following program may be included in your
distribution package if you so wish.  The complete program is being
sent in two different Emails (CompuServe has a limit to the size of
messages).

Again, thanx for distributing 3D Viewer.  Not only is it fun to use,
but can be used in applications and in teaching geometry to students.


Bruce Colletti (71121.1452@compuserve.com); 22 SEP 91 0941 EST
        ---------------------- cut here ----------------------
public domain, three dimensional surface builder called 3-D Viewer
v2.5.  This lets you rotate 3D surfaces using a Microsoft compatible
mouse.  Two public BBS' where it can be found (3DV25.ZIP) are
ShadeTree (412-244-9416 2400N81, Pittsburgh Pennsylvania, USA) and the
Blue Ridge Express (804-790-1675 2400N81, Richmond Virginia, USA).  I
built the program below (3DHELP) for my own use:  it builds the *.3D
input file to 3-D Viewer for the equation which the user specifies in
the procedure f.

This is how 3DHELP works:  the XY domain is defined by a rectangle
whose lower left and upper right hand corners are (xlo,ylo) and (xhi,yhi)
respectively.  This "rubber sheet" is then distorted:  each (x,y)
point is "stretched" vertically by its z value.  Although this is a
useful way to specify the XY domain, it prevents 3DHELP from plotting
general surfaces:  the domain of a hemisphere is a disk and not a
rectangle.  Maybe you can change 3DHELP to make it plot more general
surfaces.

The XYZ axes are displayed in the colors red, white, and blue
respectively. Each axis extends from the min/max values assumed by the
points.

One output file (specify a *.3D extension!) has the points to plot.  A
second output file connects the XY points in a grid.  The way that
these files are formatted is described in Oscar's 3DV.DOC.  Once all
points have been determined, the second file is appended (to the
first) and then erased.  The resulting *.3D file can then be used by
Oscar's 3DV.EXE.

This program was created using TURBO C 2.01 w/patches ad entered into
the public domain.  No guarantee is made about 3DHELP's suitability
for use, which is at your own risk.  This is source code which you can
modify to your heart's content.  I haven't tried to make this code
portable, so it may need to be changed to compile correctly in your C
compiler.  Be aware that this program creates the file ###.### on the
current directory and then erases it later, and doesn't check if the
user-specified *.3d file already exists.

3DHELP.C may be freely distributed but without charge.

Bruce W. Colletti
Richmond VA
71121.1452@compuserve.com
21AUG91
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

 *******************************************************************
 This is the function to display in 3 dimensional space, i.e., plot
 the points {(x,y,z) : z = f(x,y)}

 The example function is 3sin(x}+y}sin(10y)).
 *******************************************************************
 ******************************************************************/

float f(float x, float y)
  {float z;
   z = 3*sin(x*x + sin(10*y)*y*y);
   return(z);
  }

 ****************************** end procedure f **********************
 ********************************************************************/

 ********************** read a real number **************************
 ********************************************************************/

  {char buffer[10];

   while (gets(buffer) && (sscanf(buffer,"%f",x)==0))
     printf("Numeric input only.  Correct value /");

   return;
  }

 ********************** read an integer    **************************
 *******************************************************************/

void readint(int *x)
  {char buffer[10];

   while (gets(buffer) && (sscanf(buffer,"%d",x)==0))
     printf("Numeric input only. Correct value /");

   return;
  }

 *************************** the main program **********************
 *******************************************************************/

main()
  {FILE *outfile1, *outfile2;
   float xlo, xhi, ylo, yhi, xdelta, ydelta, x, y, z;
   float zlo=9E30, zhi=-9E30;
   int xdivide, ydivide, i, j, point=1;
   char buffer[40];

   /***************************************************************
    ***************************************************************
    Give the range of x and y values to plot, and the stepsize between
    points.
    ***************************************************************
    ****************************************************************/

   printf("xlo /"); readreal(&xlo);
   printf("xhi /"); readreal(&xhi);
   printf("# of X subdivisions /"); readint(&xdivide);
   xdelta = (xhi-xlo) / xdivide;

   printf("\nylo /"); readreal(&ylo);
   printf("yhi /"); readreal(&yhi);
   printf("# of Y subdivisions /"); readint(&ydivide);
   ydelta = (yhi-ylo) / ydivide;

/*
Date: 22 Sep 91 09:42:18 EDT
From: Bruce Colletti <71121.1452@CompuServe.COM>
Subject: 3D Viewer Part 2
To: Oscar Garcia <garciao@MOF.GOVT.NZ>
Message-Id: <910922134217_71121.1452_DHJ35-2@CompuServe.COM>
*/

   /*****************************************************************
    *****************************************************************
    Two files are created for later joining.  The user-specified file
    outfile1 will have the (x,y,z) points to plot.  ###.### identifies
    which points to connect.  The format and reason for this
    approach are found in Oscar's 3DV.DOC.

    Starting from the lower left hand corner of the XY range (X
    horizontal, Y vertical), process horizontal grid rows in-turn.
    *****************************************************************
    *****************************************************************/

   printf("Output file (.3d extension!) /");
   gets(buffer);
   outfile1 = fopen(buffer,"wt");
   outfile2 = fopen("###.###","wt");
   fprintf(outfile1,"%d\n",(xdivide+1)*(ydivide+1)+6);
                   /* total # of points; +6 is to draw the axes */

   fprintf(outfile2,"%d\n",(xdivide+1)*(ydivide+1)+
                           (ydivide+1)*(xdivide+1)+6);
                  /* total # of connections+moves; +6 for axes */
   y = ylo;

   for(i=0; i<=ydivide; i++)
     {x = xlo;              /* start of horizontal grid row */
      z = f(x,y);
      if (z < zlo) zlo = z;
      if (z > zhi) zhi = z;

      fprintf(outfile1,"%11.6f %11.6f %11.6f\n",x,y,z);
                                  /* print (x,y,z) point */
      fprintf(outfile2,"%d 0\n",point++); /* move to point */

      for(j=0; j<xdivide; j++)
        {x += xdelta;              /* move to next point on row */
         z = f(x,y);
         if (z < zlo) zlo = z;
         if (z > zhi) zhi = z;
         fprintf(outfile1,"%11.6f %11.6f %11.6f\n",x,y,z);
                                   /* print (x,y,z) point */
         fprintf(outfile2,"%d 14\n",point++);
                                   /* connect to previous point */
        }

      y += ydelta;                 /* move to next row */
     }

   /************************************************************
    ************************************************************
    Establish points whose pairwise connections will be the x,y,z
    axes.
    ********************             fprintf(outfile1,"%11.6f 0 0\n",xlo);

   /* y axis */  fprintf(outfile1,"0 %11.6f 0\n",yhi);
                 fprintf(outfile1,"0 %11.6f 0\n",ylo);

   /* z axis */  fprintf(outfile1,"0 0 %11.6f\n",zhi);
                 fprintf(outfile1,"0 0 %11.6f\n",zlo);

   /* now draw the axes:  the red (x), white (y), and blue (z)! */
    fprintf(outfile2,"%d 0\n",point++);
    fprintf(outfil2,"%d 12\n",point++);

    fprintf(outfile2,"%d 0\n",point++);
    fprintf(outfile2,"%d 15\n",point++);

    fprintf(outfile2,"%d 0\n",point++);
    fprintf(outfile2,"%d  9\n",point);

   /**********************************************
    ***************************************************************
 points have been computed and each row has been
    internally conected.  Append the contents of outfile2 to outfile1
    ***************************************************************
    ****************************************************************/

    fclose(outfile2);
    outfile2 = fopen("###.###","rt");

    while (fgets(buffer,80,outfile2) != NULL)
tf(outfile1,"%s",buffer);

se ###.###");

   /*********************************
    *************************************************************
              Internally connect the grid's vertical columns.
    ************************************************************
    ************************************************************/

    for(i=1; i <= xdivide+1; i++)
      {point = i;
       fprintf(outfile1,"%d 0\n",point);

       for(j=0; j < ydivide; j++)
        {point += xdivide+1;
         fprintf(outfile1,"%d 14\n",point);
        }
      }

    fclose(outfile1);
    printf("All Done!");
   }
