/* Header file for ACK-3D example */

#define VIEW_X		84	    /* Size of the 3D viewport */
#define VIEW_X1		236
#define VIEW_Y		7
#define VIEW_Y1		89

#define CEILING_COLOR	23
#define FLOOR_COLOR	27


#define PLAYER_X	390	    /* Initial X coordinate */
#define PLAYER_Y	260	    /* Initial Y coordinate */
#define PLAYER_ANGLE	480	    /* Initial POV angle    */

#define DOORSPEED	4

typedef struct {
    int	    mdx;
    int	    mdy;
    int	    mButtons;
} MOUSE;

typedef struct {
	int	Number;
	int	Type;
	char	*Name;
} BMTABLE;

typedef struct
    {
    unsigned char start;
    unsigned char length;
    }ColorRange;


/* Prototypes */
int AppInitialize(void);
int AppSetupEngine(void);
int AppSetupOverlay(void);
int AppLoadBitmaps(void);
int AppSetupObjects(void);
int AppSetGraphics(void);
void AppSetupPalRanges(void);
void AppShow3D(void);
void CheckMouse(MOUSE *m);
int mouse_installed(void);
void mouse_hide_cursor(void);
void mouse_set_cursor(int row,int col);
void mouse_read_cursor(int *button,int *row,int *col);

