#ifndef _BUFFER_NODE_
#define _BUFFER_NODE_
#include "osbuffer.h"
#include "memutil.h"
#include <stddef.h>

typedef struct BUFFER_NODE * pbuffer_node;

typedef struct BUFFER_NODE {
   poff_screen_buff data;
   pbuffer_node next;
} buffer_node;

inline BOOL BN_Empty_Node(pbuffer_node the_node) {
   return (the_node==NULL ? TRUE : FALSE);
}

inline pbuffer_node BN_Get_Next_Node(pbuffer_node the_node) {
   return the_node->next;
}

inline void BN_Set_Next_Node(pbuffer_node the_node, pbuffer_node next_node) {
the_node->next=next_node;
}
                                     
inline poff_screen_buff BN_Get_Data(pbuffer_node the_node) {
   return the_node->data;
}

inline void BN_Set_Data(pbuffer_node the_node, poff_screen_buff the_data) {
   the_node->data=the_data;
}

inline pbuffer_node BN_Create_Node() {
   pbuffer_node new_buff_node=(pbuffer_node)NewPtr(sizeof(buffer_node));
   return new_buff_node;
}

inline void BN_Delete_Node(pbuffer_node del_node) {
  DelPtr(del_node);
}

inline void BN_Set_Node(pbuffer_node & base, pbuffer_node new_bn) {
   base=new_bn;
}

#endif
