#include "assert.h"
#include "ray.h"
#include "globals.h"
#include "rayspr.h"
#include "sprfunc.h"
#include "sfvars.h"
#include "maxmins.h"
#include "sprinter.h"
#include "fixed.h"
#include "collisio.h"
#include "sound.h"
#include "voxinter.h"
#include "ground.h"
#include "sprtypes.h"
#include "sprswtch.h"
#include "message.h"
#include "defobj.h"
#include "objcol.h"
#include "damage.h"

#define BULLET_SPEED 20
#define BULLET_DAMAGE 10

long bmin_x, bmin_y, bmax_x, bmax_y;
long sound_id;

void Bullet_Create(pobject cur_object, long offset);
void Bullet_Update(pobject cur_object, long update_num);
void Bullet_Update_Z(pobject cur_object, psector new_sec);
ULONG Bullet_Message(pobject send_obj, pobject receive_obj, ULONG message, pdata extra_data);

void Init_Bullets(func_index index) {
   sound_id=Load_Sound("shoot.wav");
   update_funcs[index]=Bullet_Update;
   update_z_funcs[index]=Bullet_Update_Z;
   load_extra_funcs[index]=Bullet_Create;
   message_funcs[index]=Bullet_Message;
   bmin_x=0x7FFFFFFF;
}

BOOL Is_Hittable(pobject the_obj) {
if (the_obj->stats.current_health>0) {
   return TRUE;
}  else {
   return FALSE;
}

}

void Bullet_Update(pobject cur_object, long update_num) {
   long orig_alt;
   pobject orig_obj;
   orig_alt=cur_object->z+Ground_Height(cur_object);
   Move_Object_Vec(cur_object, (pvector2)(cur_object->extra_data));
   cur_object->z=orig_alt-Ground_Height(cur_object);
   if (cur_object->z <= 0) {
      Switch_Object_Types(cur_object, Obj_Type_List+EXPLOSION_TYPE);
   }
}

void Bullet_Update_Z(pobject cur_object, psector new_sec) {
}

void Bullet_Create(pobject cur_object, long offset) {
   Play_Sound(sound_id);
   if (bmin_x==0x7FFFFFFF)
      Get_Map_Max_Mins(bmin_x, bmin_y, bmax_x, bmax_y);

   pvector2 delta_vec;
   delta_vec=(pvector2)NewPtr(sizeof(vector2));
   delta_vec->x=(rcos_table[cur_object->angle]*cur_object->type->stats.base_speed);
   delta_vec->y=(rsin_table[cur_object->angle]*cur_object->type->stats.base_speed);
   cur_object->extra_data=(pdata)delta_vec;
}

ULONG Bullet_Message(pobject send_obj, pobject receive_obj, ULONG message, pdata extra_data)
{
   switch (message) {
      case WALL_SLIDE_CONFIRM:
      if (*((BOOL *)extra_data)==TRUE) {
         Switch_Object_Types(receive_obj, Obj_Type_List+EXPLOSION_TYPE);
         return OPERATION_STOP;
      } else {
         return STOP_SLIDE;
      }
     case HIT_BY_OBJ:
     case HIT_OBJ:
         if (Is_Hittable(send_obj)&&(send_obj!=receive_obj->owner)) {
            Stop_Obj(receive_obj, (pobj_collision)extra_data);
            Switch_Object_Types(receive_obj, Obj_Type_List+EXPLOSION_TYPE);
            Give_Damage(send_obj, BULLET_DAMAGE);
            return OPERATION_STOP;
         }
         return NORMAL_MESSAGE;
      default:
         break;
   }
return Default_Message(send_obj, receive_obj, message, extra_data);
}


