#include "ray.h"
#include "globals.h"
#ifdef OS_DOS
#include "asm.h"
#include "gamerun.h"
#include "scrcntl.h"
#include "palette.h"
#include <conio.h>
#include <i86.h>
#include <dos.h>

#define VGA_WIDTH 320
#define VGA_HEIGHT 200
#define SVGA_WIDTH 640
#define SVGA_HEIGHT 480

union REGS tempregs; // required for int386 calls. Have no other use

void SetCursorXY(unsigned char column, unsigned char row)
{
   tempregs.h.ah=2;
   tempregs.h.bl=0;
   tempregs.h.dl=column;
   tempregs.h.dh=row;
   int386(0x10, &tempregs, &tempregs);
}

// VGA status stuff

#define VGA_INPUT_STATUS_1   0x3DA // vga status reg 1, bit 3 is the vsync
                                   // when 1 - retrace in progress
                                   // when 0 - no retrace

#define VGA_VSYNC_MASK       0x08  // masks off unwanted bits of status reg

void Wait_For_Vsync(void)
{
// this function waits for the start of a vertical retrace, if a vertical
// retrace is in progress then it waits until the next one

while(!inp(VGA_INPUT_STATUS_1) & VGA_VSYNC_MASK)
     {
     // do nothing, vga is in retrace
     } // end while

// now wait for vysnc and exit

while((inp(VGA_INPUT_STATUS_1) & VGA_VSYNC_MASK))
     {
     // do nothing, wait for start of retrace
     } // end while

// at this point a vertical retrace is occuring, so return back to caller

} // Wait_For_Vsync

void Dos_Copy_Buff() {
   Wait_For_Vsync();
   copyBuff();
}

void Dos_Init() {
   Init_Screen(VGA_WIDTH, VGA_HEIGHT);
   Global_Initialize();
   Activate_Graphics();
   Activate_Palette(TRUE);
}

void Dos_Run() {
Init_Main_Cycle();
while (!Main_Cycle_Done())
   Do_Main_Cycle();
}

void Dos_Close() {
   Global_Close();
}

void main() {
   Dos_Init();
   Dos_Run();
   Dos_Close();
}

#endif
