#include "ray.h"
#include "globals.h"
#include "rayfile.h"
#include "doom.h"
#include "fixed.h"
#include "blockbsp.h"
#include "blockmap.h"
#include <stdlib.h>

inline ptexture Get_Rand_Texture()
{
short tex_result=1;
#ifdef RAND_TEX
short intermediate=rand();
tex_result+=((intermediate*(Number_Of_Textures-1))/32767);
if (tex_result>=Number_Of_Textures)
  tex_result=Number_Of_Textures-1;
#endif
return (ptexture)(tex_result);
}

void F_Doom_Load(char * filename)
{
F_D_Setup(filename);
base_index=0;
F_D_Load_World();
F_Close();
}

void F_D_Setup(char * filename)
{
binary_mode=TRUE;
fp.open(filename, ios::binary | ios::in | ios::out);
F_Seek(0);
fp.read(header.header, 4);
F_Get_Long(header.dir_entries);
F_Get_Long(header.dir_location);
F_Seek(header.dir_location);
directory=(dir_entry *)NewPtr(header.dir_entries * sizeof(dir_entry));
short counter;
dir_entry * cur_dir;
for (counter=0; counter < header.dir_entries; counter++) {
   cur_dir=directory+counter;
   F_Get_Long(cur_dir->start);
   F_Get_Long(cur_dir->length);
   F_Get_String(cur_dir->name, 8);
} /* endfor */
}

void F_D_Load_World()
{
if (world_loaded)
   F_Clear_World();
world_loaded=TRUE;
F_D_Get_Sectors();
F_D_Get_Vectors();
F_D_Get_SDs();
F_D_Get_LDs();
F_D_Get_Segs();
F_D_Get_SSectors();
F_D_Get_BSP();
F_D_Get_Player_Loc();
}

short F_D_Find_And_Setup(char * string, void * * table)
{
   short temp_index;
   if ((temp_index=F_Find_Dir(string))==-1)
      return temp_index;
   (*table)=(void *)NewPtr(directory[temp_index].length);
   F_Seek(directory[temp_index].start);
   fp.read((char*)(*table), directory[temp_index].length);
   return temp_index;
}

void F_D_Get_Sectors()
{
dm_sector * temp_sectors;
short dir_index=F_D_Find_And_Setup("SECTORS\0", (void * *)&temp_sectors);
if (dir_index==-1)
   return;

Number_Of_Sectors=(directory[dir_index].length/sizeof(dm_sector));
Sector_List=(sector *)NewPtr(Number_Of_Sectors * sizeof(sector));

short counter;
sector * cur_sec;
dm_sector * cur_dm_sec;

for (counter=0; counter<Number_Of_Sectors; counter++) {
   cur_sec=Sector_List+counter;
   cur_dm_sec=temp_sectors+counter;
   cur_sec->floor_height=cur_dm_sec->floor_ht;
   cur_sec->ceil_height=cur_dm_sec->ceiling_ht;
   cur_sec->tag=(USHORT)cur_dm_sec->trigger;
   cur_sec->light=((UCHAR) cur_dm_sec->light >> 4) + 
        ((UCHAR) cur_dm_sec->light & 0xf0);
   cur_sec->floor_tex=0;
   cur_sec->ceil_tex=0;
   cur_sec->flags=0;
}

DelPtr(temp_sectors);
}

void F_D_Get_Vectors()
{
dm_vertex * temp_vectors;
short dir_index=F_D_Find_And_Setup("VERTEXES",(void * *)&temp_vectors);
if (dir_index==-1)
   return;

Number_Of_Vectors=(directory[dir_index].length / sizeof(dm_vertex));
Vector_List=(vector2 *)NewPtr(Number_Of_Vectors * sizeof(vector2));

short counter;
vector2 * cur_vec;
dm_vertex * cur_dm_vec;
for (counter=0; counter < Number_Of_Vectors; counter++) {
   cur_vec=Vector_List+counter;
   cur_dm_vec=temp_vectors+counter;
   cur_vec->x=(long)cur_dm_vec->x;
   cur_vec->y=(long)cur_dm_vec->y;
}

DelPtr(temp_vectors);
}

void F_D_Get_SDs()
{
srand(rand());

dm_side * temp_sidedefs;
short dir_index=F_D_Find_And_Setup("SIDEDEFS",(void * *)&temp_sidedefs);
if (dir_index==-1)
   return;

Number_Of_Sidedefs=(directory[dir_index].length / sizeof(dm_side));
Sd_List=(sidedef *)NewPtr(Number_Of_Sidedefs * sizeof(sidedef));

short counter;
sidedef * cur_sd;
dm_side * cur_dm_sd;
for (counter=0; counter < Number_Of_Sidedefs; counter++) {
   cur_sd=Sd_List+counter;
   cur_dm_sd=temp_sidedefs+counter;
   cur_sd->attributes=0;
   cur_sd->x_offset=cur_dm_sd->tm_xoffset;
   cur_sd->y_offset=cur_dm_sd->tm_yoffset;
   cur_sd->sec=Sector_List+cur_dm_sd->sector;

   if (Cmp_Str_N(cur_dm_sd->main_tx, "-", 1))
      cur_sd->texture_normal=TEXTURE_NULL;
   else cur_sd->texture_normal=Get_Rand_Texture();

   if (Cmp_Str_N(cur_dm_sd->upper_tx, "-", 1))
      cur_sd->texture_high=TEXTURE_NULL;
   else cur_sd->texture_high=Get_Rand_Texture();

   if (Cmp_Str_N(cur_dm_sd->lower_tx, "-", 1))
      cur_sd->texture_low=TEXTURE_NULL;
   else cur_sd->texture_low=Get_Rand_Texture();

} /* endfor */

DelPtr(temp_sidedefs);
}

void F_D_Get_LDs()
{
dm_line * temp_linedefs;
short dir_index=F_D_Find_And_Setup("LINEDEFS", (void * *)&temp_linedefs);
if (dir_index==-1)
   return;

Number_Of_Linedefs=(directory[dir_index].length / sizeof(dm_line));
Ld_List=(linedef *)NewPtr(Number_Of_Linedefs * sizeof(linedef));

short counter;
linedef * cur_ld;
dm_line * cur_dm_ld;
for (counter=0; counter < Number_Of_Linedefs; counter++) {
   cur_ld=Ld_List+counter;
   cur_dm_ld=temp_linedefs+counter;
   cur_ld->v[0]=cur_dm_ld->from;
   cur_ld->v[1]=cur_dm_ld->to;
   cur_ld->s[0]=Sd_List+cur_dm_ld->side[0];

   // Check to see if there is a second sidedef at all
   if (cur_dm_ld->side[1]!=-1)
      cur_ld->s[1]=Sd_List+cur_dm_ld->side[1];
   else cur_ld->s[1]=NULL;

   cur_ld->attributes=(USHORT)cur_dm_ld->flags;
   cur_ld->tag_type=(USHORT)cur_dm_ld->special;
   cur_ld->tag=(USHORT)cur_dm_ld->tag;

} /* endfor */
DelPtr(temp_linedefs);

Generate_Block_Map();

}

void F_D_Get_Segs()
{
dm_seg * temp_segs;
short dir_index=F_D_Find_And_Setup("SEGS\0\0\0\0", (void * *)&temp_segs);
if (dir_index==-1)
   return;

Number_Of_Segs=(directory[dir_index].length / sizeof(dm_seg));
Seg_List=(seg *)NewPtr(Number_Of_Segs * sizeof(seg));

short counter;
seg * cur_seg; dm_seg * cur_dm_seg;
for (counter=0; counter < Number_Of_Segs; counter++) {
   cur_seg=Seg_List+counter;
   cur_dm_seg=temp_segs+counter;
   cur_seg->v[0]=cur_dm_seg->from;
   cur_seg->v[1]=cur_dm_seg->to;
   cur_seg->angle=((long)cur_dm_seg->angle * ANGLE_360) / DM_ANGLE_360;
   cur_seg->ld=Ld_List+cur_dm_seg->line;
   cur_seg->left_sidedef=(BOOL)cur_dm_seg->line_side;
   cur_seg->linedef_offset=(LONG)cur_dm_seg->line_offset;
} /* endfor */

DelPtr(temp_segs);
}

void F_D_Get_SSectors()
{
dm_ssector * temp_ssectors;
short dir_index=F_D_Find_And_Setup("SSECTORS", (void * *)&temp_ssectors);
if (dir_index==-1)
   return;

Number_Of_SSectors=(directory[dir_index].length / sizeof(dm_ssector));
SS_List=(ssector *)NewPtr(Number_Of_SSectors * sizeof(ssector));

short counter;
ssector * cur_ss;
dm_ssector * cur_dm_ss;
for (counter=0; counter < Number_Of_SSectors; counter++) {
   cur_ss=SS_List+counter;
   cur_dm_ss=temp_ssectors+counter;
   cur_ss->seg_start=cur_dm_ss->first_seg;
   cur_ss->seg_end=cur_ss->seg_start+cur_dm_ss->num_segs-1;
   Doom_Sort_SSector(cur_ss);
   cur_ss->num_objects=0;
   cur_ss->objects=NULL;
   cur_ss->flags=0;
} /* endfor */

DelPtr(temp_ssectors);
}

void F_D_Get_BSP()
{
dm_node * temp_nodes;
short dir_index=F_D_Find_And_Setup("NODES\0\0\0", (void * *)&temp_nodes);
if (dir_index==-1)
   return;

Number_Of_Nodes=(directory[dir_index].length / sizeof(dm_node));
bsp_tree=(bsp_node *)NewPtr(Number_Of_Nodes * sizeof(bsp_node));

bsp_start_node=Number_Of_Nodes-1;

short counter;
bsp_node * cur_node;
dm_node * cur_dm_node;
prectl cur_rect;
for (counter=0; counter < Number_Of_Nodes; counter++) {
   cur_node=bsp_tree+counter;
   cur_dm_node=temp_nodes+counter;
   cur_node->x1=cur_dm_node->x;
   cur_node->y1=cur_dm_node->y;
   cur_node->x2=cur_node->x1 + cur_dm_node->dx;
   cur_node->y2=cur_node->y1 + cur_dm_node->dy;
   cur_rect=&(cur_node->left_bound);
   cur_rect->top=cur_dm_node->ly2;
   cur_rect->left=cur_dm_node->lx1;
   cur_rect->bottom=cur_dm_node->ly1;
   cur_rect->right=cur_dm_node->lx2;
   cur_rect=&(cur_node->right_bound);
   cur_rect->top=cur_dm_node->ry2;
   cur_rect->left=cur_dm_node->rx1;
   cur_rect->bottom=cur_dm_node->ry1;
   cur_rect->right=cur_dm_node->rx2;
   cur_node->left_child=cur_dm_node->left;
   cur_node->right_child=cur_dm_node->right;
} /* endfor */

DelPtr(temp_nodes);

Generate_BSP_Block();
}

void F_D_Get_Player_Loc()
{
dm_thing * temp_things;
short dir_index=F_D_Find_And_Setup("THINGS\0\0", (void * *)&temp_things);
if (dir_index==-1)
   return;

short num_things=(directory[dir_index].length / sizeof(dm_thing));

short counter;
dm_thing * cur_dm_thing;
for (counter=0; counter < num_things; counter++) {
   cur_dm_thing=temp_things+counter;
   if (cur_dm_thing->thing_type==PLAYER_START) {
/*      the_player->x=cur_dm_thing->x;
      the_player->y=cur_dm_thing->y;
      the_player->angle=0; */
   }
} /* endfor */

DelPtr(temp_things);
}

void Doom_Sort_SSector(ssector * cur_ss)
{
pseg cur_low, cur_test, seg_base;
seg_base=Seg_List+cur_ss->seg_start;
USHORT num_segs=cur_ss->seg_end - cur_ss->seg_start+1;
for (short i=0; i<(num_segs-1); i++) {
   cur_low=seg_base+i;
   for (short j=i+1; j<num_segs; j++) {
      cur_test=seg_base+j;
      if (cur_test->angle > cur_low->angle)
         Swap_Segs(cur_test, cur_low);
   } /* endfor */
} /* endfor */
}

void Swap_Segs(seg * base_seg, seg * swap_seg)
{
seg temp_seg;
memcpy(&temp_seg, base_seg, sizeof(seg));
memcpy(base_seg, swap_seg, sizeof(seg));
memcpy(swap_seg, &temp_seg, sizeof(seg));
}
