#include "ray.h"
#include "resnames.h"
#include "rayfile.h"
#include "globals.h"
#include "scrmes.h"

BOOL Scan_Check_Res(PCHAR res_check)
{
CHAR resource_name[RESOURCE_LENGTH+1];
base_index=0;
strncpy(resource_name, res_check, RESOURCE_LENGTH+1);
if ((base_index=F_Find_Dir(resource_name))!=-1)
   return TRUE;
else return FALSE;
}

BOOL Spec_Check_Res(PCHAR find_res, PCHAR test_res)
{
   if ((Cmp_Str_N(find_res, test_res, RESOURCE_LENGTH)) &&
      ((base_index=F_Find_Dir(find_res))!=-1)) {
         return TRUE;
   } else {
         return FALSE;
   } /* endif */
}

BOOL Cmp_Str_N(char * s1, char * s2, short n)
{
   BOOL still_equal=TRUE;
   short counter;
   for (counter=0; counter<n; counter++) {
      if (s1[counter]!=s2[counter]) {
         still_equal=FALSE;
      }
   } /* endfor */
return still_equal;
}

void F_Init() {
   world_loaded=FALSE;
   wall_tex_loaded=FALSE;
   floor_tex_loaded=FALSE;
   sound_loaded=FALSE;
}

void F_Shutdown() {
   if (world_loaded)
      F_Clear_World();
   if (wall_tex_loaded)
      F_Clear_WT();
   if (floor_tex_loaded)
      F_Clear_FT();
   if (sound_loaded)
      F_Clear_Sound();
}

 void F_Setup(char * filename)
{
fp.open(filename, ios::text | ios::in | ios::out);
F_Seek(0);
fp.read(header.header, 8);
if (header.header[0]=='B') {
   binary_mode=TRUE;
   fp.close();
   fp.open(filename, ios::binary | ios::in | ios::out);
   F_Seek(0);
   fp.read(header.header, 8);
} else {
   binary_mode=FALSE;
   fp.ignore(100, '\n');
}
F_Get_Long(header.dir_entries);
F_Get_Long(header.dir_location);
F_Seek(header.dir_location);
directory=(dir_entry *)NewPtr(header.dir_entries * sizeof(dir_entry));
short counter;
dir_entry * cur_dir;
for (counter=0; counter<header.dir_entries; counter++) 
{
  cur_dir=directory+counter;
  F_Get_String(cur_dir->name, 8);
  F_Get_Long(cur_dir->start);
  F_Get_Long(cur_dir->length);
}
}

 void F_Close()
{
fp.close();
}

 void F_Seek(long offset)
{
if (binary_mode)
  fp.seekg(offset, ios::beg);
else {
  fp.seekg(0, ios::beg);
  short counter;
  for (counter=0; counter< offset; counter++) {
    fp.ignore(-1, '\n');
    }
  }
}

 void F_Scan_Load(char * filename)
{

F_Setup(filename);

if (Scan_Check_Res((PCHAR)WORLD_RES)) {
  Screen_Message("Loading world!");
  F_Load_World();
}
if (Scan_Check_Res((PCHAR)WTEX_RES)) {
  Screen_Message("Loading wall textures!");
  F_Get_Wall_Textures();
}

if (Scan_Check_Res((PCHAR)FTEX_RES)) {
   Screen_Message("Loading floor textures!");
   F_Get_Floor_Textures();
}

if (Scan_Check_Res((PCHAR)SOUND_RES)) {
   Screen_Message("Loading music!");
   F_Get_Sound();
}

if (Scan_Check_Res((PCHAR)OBJECT_TYPE_RES)) {
   Screen_Message("Loading object types!");
   F_Get_Object_Types();
}

if (Scan_Check_Res((PCHAR)OBJECT_RES)) {
   Screen_Message("Loading objects!");
   F_Get_Objects();
}

F_Close();
}

 void F_Spec_Load(short num_elements, char * filename, ... )
{
va_list vars;
short index; char * cur_v;
va_start(vars, filename);

F_Setup(filename);

for (index=0; index< num_elements; index++) {
  cur_v=va_arg(vars, char *);
  base_index=0;
  if (Spec_Check_Res((PCHAR)WTEX_RES, cur_v)) {
    Screen_Message("Loading wall textures!");
    F_Get_Wall_Textures();
  } else if (Spec_Check_Res((PCHAR)FTEX_RES, cur_v)) {
     Screen_Message("Loading floor textures!");
     F_Get_Floor_Textures();
  } else if (Spec_Check_Res((PCHAR)SOUND_RES, cur_v)) {
     Screen_Message("Loading music!");
     F_Get_Sound();
  } else if (Spec_Check_Res((PCHAR)OBJECT_TYPE_RES, cur_v)) {
     Screen_Message("Loading object types!");
     F_Get_Object_Types();
  } else if (Spec_Check_Res((PCHAR)OBJECT_RES, cur_v)) {
     Screen_Message("Loading objects!");
     F_Get_Objects();
  } else if (Scan_Check_Res(cur_v)) {
    Screen_Message("Loading world!");
    F_Load_World();
  }

}  

F_Close();

va_end(vars);
}

 SHORT F_Find_Dir(char * name)
{

BOOL found=FALSE;
short counter;
for (counter=base_index; counter< header.dir_entries; counter++) {
   if (Cmp_Str_N(name, directory[counter].name, 8)) {
      found=TRUE;
      break;
   }
} /* endfor */

if (found==TRUE) {
   return counter;
} else {
   return -1;
} /* endif */

}

 short F_Find_And_Setup(char * string, void * * table, short memsize)
{
   short temp_index;  
   if ((temp_index=F_Find_Dir(string))==-1)
     return temp_index;
   (*table)=(void *)NewPtr(directory[temp_index].length * memsize);
   F_Seek(directory[temp_index].start);
   return temp_index;
}

