#include "ray.h"
#include "globals.h"
#include "rayfile.h"
#include "blockbsp.h"
#include "SortSeg.h"
#include "genbsp.h"
#include "blockmap.h"
#include "fixed.h"
#include "scrmes.h"

inline sector * Get_Sec_From_SSec(ssector * cur_ss)
{
   seg * cur_seg=Seg_List+cur_ss->seg_start;
   return (cur_seg->ld->s[(short)cur_seg->left_sidedef]->sec);
}

void F_Clear_World()
{
   DelPtr(Vector_List);
   DelPtr(Sd_List);
   DelPtr(Ld_List);
   DelPtr(Seg_List);
   DelPtr(SS_List);
   for (short sec_index=0; sec_index<Number_Of_Sectors; sec_index++) {
      if (Sector_List[sec_index].extra_data!=NULL) {
         DelPtr(Sector_List[sec_index].extra_data);
      }
   }
   DelPtr(Sector_List);
   DelPtr(bsp_tree);
   Clear_Block_Map();
   Clear_BSP_Block();
}

 void F_Load_World()
{
   if (world_loaded)
      F_Clear_World();
   Screen_Message("Loading sectors!");
   F_Get_Sectors();               
   Screen_Message("Loading vectors!");
   F_Get_Vectors();
   Screen_Message("Loading sidedefs!");
   F_Get_SDs();
   Screen_Message("Loading linedefs!");
   F_Get_LDs();
   Screen_Message("Loading segs!");
   F_Get_Segs();
   Screen_Message("Loading sub sectors!");
   F_Get_SSectors();
   Screen_Message("Loading the bsp!");
   F_Get_BSP();
   world_loaded=TRUE;
}

 void F_Get_Vectors()
{
  short dir_index=F_Find_And_Setup("VECTORS ", (void **)&Vector_List, sizeof(vector2));
   if (dir_index==-1)
      return;
   Number_Of_Vectors=directory[dir_index].length;
   vector2 * cur_vec;
   short counter;
   for (counter=0; counter< Number_Of_Vectors; counter++) {
      cur_vec=Vector_List+counter;    
      F_Get_Long(cur_vec->x);
      F_Get_Long(cur_vec->y);
   }
   
}

 void F_Get_SDs()
{
   short dir_index=F_Find_And_Setup("SIDEDEFS", (void **)&Sd_List, sizeof(sidedef));
    if (dir_index==-1)
      return;
   Number_Of_Sidedefs=directory[dir_index].length;
   short counter;
   short temp_short;
   sidedef * cur_sd;
   for (counter=0; counter < Number_Of_Sidedefs; counter++) {
     cur_sd=Sd_List+counter;
     F_Get_UShort(cur_sd->attributes);
     F_Get_Short(cur_sd->x_offset);
     F_Get_Short(cur_sd->y_offset);
     F_Get_Short(cur_sd->texture_normal);
     F_Get_Short(cur_sd->texture_low);
     F_Get_Short(cur_sd->texture_high);
     F_Get_Short(temp_short);

     if (temp_short==-1) {
        cur_sd->sec=NULL;
     } else {
        cur_sd->sec=(Sector_List+temp_short);
     } /* endif */

     }

}

 void F_Get_LDs()
{
   short dir_index=F_Find_And_Setup("LINEDEFS", (void **)&Ld_List, sizeof(linedef));
   if (dir_index==-1)
      return;
   Number_Of_Linedefs=directory[dir_index].length;
   short counter;
   short temp_short;
   long x1,y1,x2,y2;
   linedef * cur_ld;
   for (counter=0; counter < Number_Of_Linedefs; counter++) {
     cur_ld=Ld_List+counter;
     F_Get_Short(temp_short);
     cur_ld->v[0]=temp_short;
     F_Get_Short(temp_short);
     cur_ld->v[1]=temp_short;
     F_Get_Short(temp_short);
     if (temp_short >=0)
        cur_ld->s[0]=(Sd_List+temp_short);
     else cur_ld->s[0]=NULL;
     F_Get_Short(temp_short);
     if (temp_short >=0)
        cur_ld->s[1]=(Sd_List+temp_short);
     else cur_ld->s[1]=NULL;
     F_Get_UShort(cur_ld->tag);
     F_Get_UShort(cur_ld->tag_type);
     F_Get_UShort(cur_ld->attributes);
     x1=Vector_List[cur_ld->v[0]].x;
     y1=Vector_List[cur_ld->v[0]].y;
     x2=Vector_List[cur_ld->v[1]].x;
     y2=Vector_List[cur_ld->v[1]].y;
     cur_ld->distance=longsqrtHP((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2));
   }
   Generate_Block_Map();
}

 void F_Get_Segs()
{
   short dir_index=F_Find_And_Setup("SEGS    ", (void **)&Seg_List, sizeof(seg));
   if (dir_index==-1)
      return;
   Number_Of_Segs=directory[dir_index].length;       
   short counter;
   short temp_short;
   Byte temp_byte;
   seg * cur_seg;
   for (counter=0; counter< Number_Of_Segs; counter++) {
     cur_seg=Seg_List+counter;
     F_Get_Short(temp_short);  
     cur_seg->v[0]=temp_short;
     F_Get_Short(temp_short);
     cur_seg->v[1]=temp_short;
     F_Get_Long(cur_seg->angle);
     F_Get_Short(temp_short);
     cur_seg->ld=Ld_List+temp_short;
     F_Get_Byte(temp_byte);
     cur_seg->left_sidedef=(BOOL)temp_byte;
     F_Get_Long(cur_seg->linedef_offset);
     }
}

 void F_Get_SSectors()
{
   short dir_index=F_Find_And_Setup("SSECTORS", (void **)&SS_List, sizeof(ssector));
   if (dir_index==-1)
      return;
   Number_Of_SSectors=directory[dir_index].length;   
   short counter;
   ssector * cur_ssec;
   for (counter=0; counter< Number_Of_SSectors; counter++) {
     cur_ssec=SS_List+counter;
     F_Get_Short(cur_ssec->seg_start);
     F_Get_Short(cur_ssec->seg_end);
     cur_ssec->num_objects=0;
     cur_ssec->objects=NULL;
     cur_ssec->flags=Get_Sec_From_SSec(cur_ssec)->flags;
     }
}

 void F_Get_Sectors()
{
   long cur_pos, extra_data_offset;

   short dir_index=F_Find_And_Setup("SECTORS ", (void **)&Sector_List, sizeof(sector));
   if (dir_index==-1)
      return;
   Number_Of_Sectors=directory[dir_index].length;     
   short counter;
   sector * cur_sec;
   for (counter=0; counter < Number_Of_Sectors; counter++) {
     cur_sec=Sector_List+counter;
     F_Get_UShort(cur_sec->tag);
     F_Get_Short(cur_sec->floor_height);
     F_Get_Short(cur_sec->ceil_height);
     F_Get_Short(cur_sec->floor_tex);
     F_Get_Short(cur_sec->ceil_tex);
     F_Get_Byte(cur_sec->light);
     F_Get_UShort(cur_sec->flags);
     if (cur_sec->flags & VOXEL_SECTOR) {
        F_Get_Long(extra_data_offset);
        cur_pos=F_Abs_Pos();
        Load_Vox_Map((PUCHAR &)cur_sec->extra_data, extra_data_offset);
        F_Seek_Abs(cur_pos);
        } else cur_sec->extra_data=NULL;
     }
}

 void F_Get_BSP()
{
   short dir_index=F_Find_And_Setup("NODES   ", (void **)&bsp_tree, sizeof(bsp_node));
   if (dir_index==-1) {
      Generate_BSP();
      Generate_BSP_Block();
      return;
   }
   Number_Of_Nodes=directory[dir_index].length;
   bsp_start_node=0;
   short counter;
   bsp_node * cur_node;
   prectl cur_rect;
   for (counter=0; counter < Number_Of_Nodes; counter++) {
     cur_node=bsp_tree+counter;
     F_Get_Long(cur_node->x1);
     F_Get_Long(cur_node->y1);
     F_Get_Long(cur_node->x2);
     F_Get_Long(cur_node->y2);
     cur_rect=&(cur_node->left_bound);
     F_Get_Long(cur_rect->top);
     F_Get_Long(cur_rect->left);
     F_Get_Long(cur_rect->bottom);
     F_Get_Long(cur_rect->right);
     cur_rect=&(cur_node->right_bound);
     F_Get_Long(cur_rect->top);
     F_Get_Long(cur_rect->left);
     F_Get_Long(cur_rect->bottom);
     F_Get_Long(cur_rect->right);
     F_Get_UShort(cur_node->left_child);
     F_Get_UShort(cur_node->right_child);
   }
   Generate_BSP_Block();
}


