#include <mem.h>
#include <string.h>
#include <stdarg.h>
#include <fstream.h>
#include "utils.h"
#ifdef OS_DOS
#include "mouse.h"
#include <dos.h>
#endif
#include "ray.h"
#include "scrcntl.h"
#include "palette.h"
#include "screen.h"
#include "globals.h"
#include "resnames.h"
#include "waves.h"
#include "voxinter.h"
#include "scrcap.h"
#include "shading.h"
#include "skipping.h"
#include "sound.h"
#include "sprinter.h"
#include "playint.h"
#include "keyinfo.h"
#include "raywidth.h"
#include "loadwor.h"
#include "keyboard.h"
#include "raybuff.h"
#include "timer.h"
#include "gentree.h"
#include "dosfuncs.h"
#include "winfuncs.h"
#include "scrconf.h"
#include "quit.h"
#include "rgobject.h"
#include "ground.h"
#include "closers.h"
#include "visuals.h"
#include "scrmes.h"
#include <stdio.h>

#define _PROGRAMMER_VERSION_

#define UPDATE_SPEED 36.5

#define MAX_ARG_LENGTH 20
#define NORM_ARG 1
#define FILE_ARG 2
#define WTEX_ARG 3
#define FTEX_ARG 4

#define PLAYER_START_X (1925<<SHIFT)
#define PLAYER_START_Y (550<<SHIFT)
#define PLAYER_START_ANGLE ANGLE_180
#define PLAYER_START_Z 8

#ifdef OS_DOS
#define VGA_WIDTH 320
#define VGA_HEIGHT 200
#define SVGA_WIDTH 640
#define SVGA_HEIGHT 480
#endif

#define HURT_TIME 10
#define STANDARD_PAL 0
#define HURT_PAL 1

extern "C" int _argc;
extern "C" char ** _argv;

typedef BOOL dimension_control_type;
#define VERT_CONTROL TRUE
#define HORIZ_CONTROL FALSE

const char DEF_WORLD [F_NAME_LENGTH]="nraymap.dat";
const char FILE_CMD [MAX_ARG_LENGTH]="-file";
const char WTEX_CMD [MAX_ARG_LENGTH]="-wtex";
const char FTEX_CMD [MAX_ARG_LENGTH]="-ftex";
const char NO_SHADE_CMD [MAX_ARG_LENGTH]="-noshade";
const char WAVE_CMD [MAX_ARG_LENGTH]="-wave";
const char DEF_CAPTURE_F_NAME[F_NAME_LENGTH]="scrcap.pcx";
const char END_PICT_NAME[F_NAME_LENGTH]="end.pcx";
const char SKIP_CMD [MAX_ARG_LENGTH]="-fastvox";

BOOL do_waves;

BOOL is_super_vga;
 
ULONG frame_num=0;

void Analyze_Args();

void World_Update(long cur_update_num);

void Setup_Combined_Input();        

void Start_Palette();

extern int raw_key;                  // the global raw keyboard data aquired from the ISR
 
extern int key_table[MAX_TRACKED_INPUTS-1]; // the key state table for the motion keys

void Clear_Input();

#ifdef OS_DOS
void GetMouseInput(); // Routine to set the mouse statement flags
#endif

int mouse_table[MAX_TRACKED_INPUTS-1] = {0,0,0,0,0,0}; // same state table thing but for the mouse

short combined_table[MAX_TRACKED_INPUTS]= {0,0,0,0,0,0,0}; // combination of mouse+keyboard

#ifdef OS_DOS
BOOL hasmouse=FALSE; // Boolean for whether the comp. has a mouse
#endif

dimension_control_type dim_control;

BOOL done;

void startup();
void shutdown();

void Global_Initialize() {
	Screen_Message("Initializing Hardware!");
	startup(); // Setup hardware stuff, etc.
	Screen_Message("Initializign Renderer!");
	initRay(); // Setup raycaster
	Screen_Message("Loading data!");
	Analyze_Args();           
}

extern "C" Shutdown() {
#ifdef OS_DOS
Dos_Close();
#endif

#ifdef OS_WINDOWS
Win_Close();
#endif
}

extern "C" void Error(char * error) {
Shutdown();
printf(error);
printf("\n");
exit(1);
}

void Global_Close() {
	closeRay(); // Shut down the raycaster
	shutdown(); // Clear up memory and reset hardware
}
							
void Analyze_Args()
{
LONG arg_type;
LONG cur_arg_num;
PCHAR cur_argument;

arg_type=NORM_ARG;
cur_arg_num=1;
do_waves=FALSE;

Set_Player_Input_Buffer(combined_table);
F_Scan_Load((PCHAR)DEF_WORLD);
Set_Shading(SHADING_ON);
Set_Skipping(SKIPPING_OFF);
// go through arguments looking for user specifications

while (cur_arg_num<_argc) {

	cur_argument=_argv[cur_arg_num];

	// what type of argument is this 
	switch (arg_type) {
	
	// normal:
	case NORM_ARG:

		// is the user specifying a world file name?
		if (!strnicmp(cur_argument, FILE_CMD, MAX_ARG_LENGTH))
			arg_type=FILE_ARG;

		if (!strnicmp(cur_argument, WTEX_CMD, MAX_ARG_LENGTH))
			arg_type=WTEX_ARG;

		if (!strnicmp(cur_argument, FTEX_CMD, MAX_ARG_LENGTH))
			arg_type=FTEX_ARG;
		
		if (!strnicmp(cur_argument, WAVE_CMD, MAX_ARG_LENGTH))
			do_waves=TRUE;

		if (!strnicmp(cur_argument, NO_SHADE_CMD, MAX_ARG_LENGTH))
			Set_Shading(SHADING_OFF);

		if (!strnicmp(cur_argument, SKIP_CMD, MAX_ARG_LENGTH))
			Set_Skipping(SKIPPING_ON);

		break;

	// file name:
	case FILE_ARG:

		Load_World(cur_argument);
		arg_type=NORM_ARG;
		break;

	//wall texture file name
	case WTEX_ARG:

		F_Spec_Load(1, cur_argument, (PCHAR)WTEX_RES);
		arg_type=NORM_ARG;
		break;

	//floor texture file name
	case FTEX_ARG:

		F_Spec_Load(1, cur_argument, (PCHAR)FTEX_RES);
		arg_type=NORM_ARG;
		break;

	default:
		break;

	}

	cur_arg_num++;
}  

the_player=Create_Object(PLAYER_START_X, PLAYER_START_Y, PLAYER_START_Z,
	PLAYER_START_ANGLE, PLAYER_TYPE, NULL, 3);
Gen_Tree();
Setup_Anim_Tex();
}     
	
UCHAR paldata[5][768];
void Start_Palette() {
	Init_Palette();
	fstream fp;
	fp.open("standard.pal",ios::binary | ios::in | ios::out);
	fp.seekg(0L,ios::beg);
	fp.read(paldata[0],768);
	fp.close();
	fp.open("red.pal", ios::binary | ios::in | ios::out);
	fp.seekg(0L,ios::beg);
	fp.read(paldata[1],768);
	fp.close();
	Load_Palette(paldata[0], 0, 256);
}

void Show_Palette(short pal_handle) {
	Load_Palette(paldata[pal_handle], 0, 256);
	Activate_Palette(TRUE);
}

void startup()      
{
	Init_Timer();
	Start_Palette();

#ifdef OS_DOS
	if (initmouse()) { // Setup mouse
		hasmouse=TRUE;
		hidemouse();
	} else hasmouse=FALSE;
#endif

Init_Sound(); 
Init_Keyboard();
}

void shutdown()
{
	Close_Keyboard();
	Close_Timer();
	Close_Sound();
	End_Graphics();
	Close_Palette();
}

angle_type cur_vert_angle, last_vert_angle;
long beg_update_num;

void Do_Intro() {

Play_Sound(Load_Sound("yo.wav"));

long abs_z;
RCastGobject picts(4);
long start_update_num;

picts.assigninfile("3.pcx");
picts.load(0);
picts.assigninfile("2.pcx");
picts.load(1);
picts.assigninfile("1.pcx");
picts.load(2);
picts.assigninfile("go.pcx");
picts.load(3);

for (short cur_pict=0; cur_pict<4; cur_pict++) {

		  cur_vert_angle=Get_Player_Vert_Angle(the_player);
		  if (cur_vert_angle!=last_vert_angle) {
			  Set_View_Angle(cur_vert_angle);
			  last_vert_angle=cur_vert_angle;
		  }
		  if (the_player->cur_sec->flags & VOXEL_SECTOR) {
		abs_z=the_player->z+Get_Voxel_Alt((PUCHAR)the_player->cur_sec->extra_data,
							 the_player->x, the_player->y)+the_player->type->eye_height;
	} else {
			  abs_z=the_player->z+the_player->cur_sec->floor_height+the_player->type->eye_height;
		  }
		  Render_Screen(the_player->x, the_player->y, abs_z, the_player->angle);
		  picts.transparent_show(buff, Get_Phys_Screen_Width(), 0,0, cur_pict);
#ifdef OS_WINDOWS
		  Win_Copy_Buff();
#endif
#ifdef OS_DOS
		  Dos_Copy_Buff();
#endif
		  // wait a bit
		  start_update_num=Get_Update_Num();
		  while ((start_update_num+36)>Get_Update_Num()); /* endwhile */
	}
Start_Music();
}

void Post_Quit(ULONG game_result) {
	long abs_z;
	RCastGobject end_scrn;
		  Stop_Music();
	if (game_result==WINNING_GAME) {
		  Play_Sound(Load_Sound("king.wav"));
		  end_scrn.assigninfile((PCHAR)END_PICT_NAME);
		  end_scrn.load();
		  cur_vert_angle=Get_Player_Vert_Angle(the_player);
		  if (cur_vert_angle!=last_vert_angle) {
			  Set_View_Angle(cur_vert_angle);
			  last_vert_angle=cur_vert_angle;
		  }
		  if (the_player->cur_sec->flags & VOXEL_SECTOR) {
		abs_z=the_player->z+Get_Voxel_Alt((PUCHAR)the_player->cur_sec->extra_data,
							 the_player->x, the_player->y)+the_player->type->eye_height;
	} else {
			  abs_z=the_player->z+the_player->cur_sec->floor_height+the_player->type->eye_height;
		  }
		  Render_Screen(the_player->x, the_player->y, abs_z, the_player->angle);
		  end_scrn.transparent_show(buff, Get_Phys_Screen_Width(), 0,0);
#ifdef OS_WINDOWS
		  Win_Copy_Buff();
#endif
#ifdef OS_DOS
		  Dos_Copy_Buff();
#endif
		  raw_key=0;
		  long start_update_num;
		  start_update_num=Get_Update_Num();
		  while ( ((start_update_num+200)>Get_Update_Num()) && (!raw_key) );
	 }
	if (game_result==DIED_GAME) {
		setgmode(0x3);
		cout << "Just because you're paranoid, doesn't mean they're not out to get you.\n";
		delay(5000);
	}
done=TRUE;
}

void Do_Shot(PCHAR graphic_filename, PCHAR sound_filename, long time, BOOL back) {
	Suspend_Time();
	RCastGobject scrn;
	scrn.assigninfile(graphic_filename);
	scrn.load();

	if (back) {
	cur_vert_angle=Get_Player_Vert_Angle(the_player);
	if (cur_vert_angle!=last_vert_angle) {
		Set_View_Angle(cur_vert_angle);
		last_vert_angle=cur_vert_angle;
	}
	Render_Screen(the_player->x, the_player->y, the_player->z+the_player->type->eye_height+
		Ground_Height(the_player), the_player->angle);
	} else clearBuff();

	scrn.transparent_show(buff, Get_Phys_Screen_Width(), 0, 0);
#ifdef OS_WINDOWS
	Win_Copy_Buff();
#endif
#ifdef OS_DOS
	Dos_Copy_Buff();
#endif
	Play_Sound(Load_Sound(sound_filename));
	Reset_Timer();
	while (Get_Update_Num()<time);
	Resume_Time();
}

void Init_Main_Cycle() {
	Reset_Timer();
	Do_Intro();
	Reset_Timer();
#ifdef OS_DOS
	if (hasmouse)
	  GetMouseInput();
#endif
	Clear_Input();
	beg_update_num=0;
	cur_vert_angle=last_vert_angle=0;
	dim_control=VERT_CONTROL;
	raw_key=0;
#ifdef OS_DOS
	done=FALSE;
#endif
}

BOOL Main_Cycle_Done() {
	return done;
}

void Do_Main_Cycle()
{
long abs_z;
long cur_update, end_update_num;

		  cur_vert_angle=Get_Player_Vert_Angle(the_player);
		  if (cur_vert_angle!=last_vert_angle) {
			  Set_View_Angle(cur_vert_angle);
			  last_vert_angle=cur_vert_angle;
		  }
		  if (the_player->cur_sec->flags & VOXEL_SECTOR) {
		abs_z=the_player->z+Get_Voxel_Alt((PUCHAR)the_player->cur_sec->extra_data,
							 the_player->x, the_player->y)+the_player->type->eye_height;
	} else {
			  abs_z=the_player->z+the_player->cur_sec->floor_height+the_player->type->eye_height;
		  }
		  Render_Screen(the_player->x, the_player->y, abs_z, the_player->angle);
#ifdef OS_WINDOWS
		  Win_Copy_Buff();
#endif
#ifdef OS_DOS
		  Dos_Copy_Buff();
#endif
		  frame_num++; 

		  end_update_num=Get_Update_Num();
		  for (cur_update=beg_update_num; cur_update<end_update_num; cur_update++) {
			  World_Update(cur_update);
		  }
		  beg_update_num=end_update_num;

		  // Check other keys that are unrelated to world updates

		  switch (raw_key) {
		  case ESC_KEY:
 #ifdef OS_DOS
			  done=TRUE;
#endif
#ifdef OS_WINDOWS
			  PostQuitMessage(0);
#endif
			  // end if user is exiting
			  break;
#ifdef _PROGRAMMER_VERSION_
		  case PLUS_KEY:
			  // user pressed "+" key, so increase window size
			  if (GetRenderMode()!=MODE_2D) {
				  #ifdef OS_DOS
				  if (dim_control==VERT_CONTROL)
					  setWindowDimensions(WINDOW_HEIGHT+10);
				  else if (dim_control==HORIZ_CONTROL)
					  Set_Window_Width(WINDOW_WIDTH+10);
				  #endif
			  } else Map_Scale_Increase();
			  break;
		  case MINUS_KEY:
			  // user pressed "-" key, so decrease window size
			  if (GetRenderMode()!=MODE_2D) {
				  #ifdef OS_DOS
				  if (dim_control==VERT_CONTROL)
					  setWindowDimensions(WINDOW_HEIGHT-10);
				  else if (dim_control==HORIZ_CONTROL)
					  Set_Window_Width(WINDOW_WIDTH-10);
				  #endif
			  } else Map_Scale_Decrease();
			  break;
		  case RIGHT_BRACKET:
			  // user pressed "]" key, so increase window FOV
			 if (dim_control==VERT_CONTROL)
				 setWindowFOV(VERTICAL_VIEW_RANGE+ANGLE_5);
			 else if (dim_control==HORIZ_CONTROL)
				 Set_Horiz_FOV(HORIZ_VIEW_RANGE+ANGLE_5);
			 break;
		  case LEFT_BRACKET:
			 // user pressed "[" key, so decrease window FOV
			 if (dim_control==VERT_CONTROL)
				 setWindowFOV(VERTICAL_VIEW_RANGE-ANGLE_5);
			 else if (dim_control==HORIZ_CONTROL)
				 Set_Horiz_FOV(HORIZ_VIEW_RANGE-ANGLE_5);
			 break;
		 case PGUP_KEY:
			 // user wants to make vox terrain seem farther away
			 V_Dist_Scale_Inc();
			 break;
		 case PGDN_KEY:
			 // user wants to make vox terrain seem closer
			 V_Dist_Scale_Dec();
			 break;
#endif
#ifdef OS_DOS
		 case F1_KEY:
			 // user is changing screen resolution
			 if (is_super_vga)
				 Change_Screen(VGA_WIDTH, VGA_HEIGHT);
			 else Change_Screen(SVGA_WIDTH, SVGA_HEIGHT);
			 is_super_vga=(!is_super_vga);
			 Update_Palette();
			 break;
#endif
#ifdef _PROGRAMMER_VERSION_
		 case F2_KEY:
			 // user wants to adjust the other dimension of screen
			 if (dim_control==VERT_CONTROL)
				 dim_control=HORIZ_CONTROL;
			 else if (dim_control==HORIZ_CONTROL)
				 dim_control=VERT_CONTROL;
			 raw_key=0;
			 break;
#endif
		 case S_KEY:
			 // user wants to capture screen
			 Screen_Capture((PCHAR)DEF_CAPTURE_F_NAME);
			 break;
		  case TAB_KEY:
			  SwitchRenderMode();
			  raw_key=0;
			  break;
		  default:
			 break;
		  } /* endswitch */
}

long time_at_hurt;
BOOL is_hurt;

void Init_Visuals() {
time_at_hurt=0;
is_hurt=FALSE;
}

void Visuals_Message(ULONG message, pdata extra_data) {
switch (message) {
  case HURT_MESSAGE:
	  Show_Palette(HURT_PAL);
	  time_at_hurt=Get_Update_Num();
	  is_hurt=TRUE;
	  break;
  case VIS_DIE_MSG:
	  Do_Shot("dscreen.pcx", "aaah.wav", 90, TRUE);
	  the_player->x=PLAYER_START_X;
	  the_player->y=PLAYER_START_Y;
	  the_player->z=PLAYER_START_Z;
	  the_player->stats.current_health=the_player->type->stats.total_health;
	  the_player->angle=PLAYER_START_ANGLE;
  default:
	  break;
}
}

void Visuals_Update(long cur_update_num) {
if (is_hurt) {
  if (cur_update_num>time_at_hurt+HURT_TIME) {
	 is_hurt=FALSE;
	 time_at_hurt=0;
	 Show_Palette(STANDARD_PAL);
  }
}
}

void World_Update(long cur_update_num) {

#ifdef OS_DOS
	if (hasmouse)
		GetMouseInput();
#endif

	if (do_waves) {
		Do_Waves();
	} /* endif */

	Animate_Textures(cur_update_num);
	Setup_Combined_Input();
	Update_Objects(cur_update_num);
	Visuals_Update(cur_update_num);
}

void GetMouseInput()
{
	#ifdef OS_DOS
	short x,y; // x,y positions of the mouse relative to last check
	mbrel(x,y); // Get them's positions;
	if (x<0) { // mouse to left
		mouse_table[INDEX_LEFT]=-x;
	} else {
		if (x>0) { // mouse to right
			mouse_table[INDEX_RIGHT]=x;
		} else {  // no mouse movement on x
			mouse_table[INDEX_LEFT]=0; mouse_table[INDEX_RIGHT]=0;
		} /* endif */
	} /* endif */
	// Note: on the y axis, direction is reversed i.e. a mouse movement up generates a y<0
 
	// mouse has different function in fly mode
	if (!Is_Flying(the_player)) {
		if (y<0) { // mouse is higher than last position
			if (y<-the_player->type->stats.base_speed)
				y=-the_player->type->stats.base_speed;

			mouse_table[INDEX_UP]=-y;
		} else {
			if (y>0) { // mouse is lower than last position
				if (y>the_player->type->stats.base_speed)
					y=the_player->type->stats.base_speed;
				mouse_table[INDEX_DOWN]=y;
			} else { // no mouse movement on y
				mouse_table[INDEX_DOWN]=0; mouse_table[INDEX_UP]=0;
			} /* endif */
		} /* endif */
		if (mbpos(x,y)) { // Check for button press
			mouse_table[INDEX_GUN]=1;
		} else {
			mouse_table[INDEX_GUN]=0;
		}
	} else {
		if (y<0) {
			mouse_table[LOOK_UP]=-y;
		} else {
			if (y>0) {
				mouse_table[LOOK_DOWN]=y;
			} else {
				mouse_table[LOOK_UP]=0; mouse_table[LOOK_DOWN]=0;
			} /* endif */
		} /* endif */
		long mb_press=mbpos(x,y);
		if (mb_press & ML_BUTTON) {
			mouse_table[INDEX_UP]=the_player->type->stats.base_speed;
		} else {
			if (mb_press & MR_BUTTON) {
				mouse_table[INDEX_DOWN]=the_player->type->stats.base_speed;
			} else {
				mouse_table[INDEX_UP]=0; mouse_table[INDEX_DOWN]=0;
			} /* endif */
		} /* endif */
	} /* endif */
#endif
}

void Setup_Combined_Input()
{
	for (short i=0; i<(MAX_TRACKED_INPUTS-1); i++) {
		if (key_table[i]>mouse_table[i]) {
			combined_table[i]=(short)key_table[i];
		} else {
			combined_table[i]=(short)mouse_table[i];
		} /* endif */
	} /* endfor */
	combined_table[MAX_TRACKED_INPUTS-1]=raw_key;
}

void Clear_Input() {
	for (short i=0; i<(MAX_TRACKED_INPUTS-1); i++) {
		key_table[i]=0;
		mouse_table[i]=0;
		combined_table[i]=0;
	}
	raw_key=0;
	combined_table[MAX_TRACKED_INPUTS-1]=0;
}

void Screen_Message(PCHAR message) {
  printf(message);
  printf("\n");
}
