#include <string.h>
#include "ray.h"
#include "globals.h"
#include "loadwor.h"
#include "resnames.h"

#define F_EXT_LENGTH 4

const char F_EXT_MARKER='.';
const char WAD_EXT [F_EXT_LENGTH]="WAD";

void File_Extension(PCHAR file_name, PCHAR file_ext)
{
BOOL found_ext;
SHORT cur_char;


strncpy(file_ext,"\0",F_EXT_LENGTH);
found_ext=FALSE;
cur_char=0;

// look for a '.' to mark the beginning of a file's extension
while ( (file_name[cur_char]!='\0') && (cur_char<F_NAME_LENGTH) ) {
   if (file_name[cur_char]==F_EXT_MARKER) {
     found_ext=TRUE;
     break;
     }
   cur_char++;
   }
// if we find an extension, copy it
if (found_ext)
  strncpy(file_ext, file_name+cur_char+1, F_EXT_LENGTH);

}

void Load_World(PCHAR filename) {
   CHAR file_ext[F_EXT_LENGTH];
      // is the user specifying a doom level or a normal level?
      File_Extension(filename, file_ext);
      if (!strnicmp(file_ext, WAD_EXT, F_EXT_LENGTH))
      {
         //yes, so load textures from standard file, and then world from wad
         F_Doom_Load(filename);
      } else {
          //no, so load everything from a 4 horseman file
         F_Scan_Load(filename);
      }
}
