#ifndef _MEMUTIL_
#define _MEMUTIL_
#include "types.h"
#include "error.h"
#include <stdlib.h>
#include <mem.h>

#define MEM_ID_1 0x12
#define MEM_ID_2 0x34

inline UCHAR * NewPtr(unsigned long x)
{
	if (x==0)
	  return NULL;
	UCHAR * temp=(UCHAR *)new UCHAR [x+2];
	if ((temp==NULL))
			  Error("Memory Allocation Failed!");
	temp[0]=MEM_ID_1;
	temp[1]=MEM_ID_2;
	memset(temp+2, 0xCC, x);
	return (temp+2);
};

inline void DelPtr(PVOID orig_ptr) {
  if (orig_ptr==NULL)
	 Error("Attempt to delete NULL ptr");
  PUCHAR ptr_temp=(PUCHAR)orig_ptr-2;
  if (ptr_temp[0]!=MEM_ID_1) {
	 Error("Bad Pointer Deletion");
  }
  if (ptr_temp[1]!=MEM_ID_2) {
	 Error("Bad Pointer Deletion");
  }
  delete ptr_temp;
}

inline UCHAR * PtrRealloc(PVOID orig_ptr, unsigned long x) {
		 UCHAR * temp=(UCHAR *)realloc(orig_ptr, x);
		 if ((temp==NULL)&&(x!=0))
			 Error("Memory Reallocation Failed!");
		 return (temp);
}

#endif
