#ifndef _OBJECT_COLLIDE_
#define _OBJECT_COLLIDE_

#include "ray.h"
#include "globals.h"
#include "fixed.h"

#define REBOUND_PERCENT 2048

typedef struct OBJ_COLLISION * pobj_collision;
typedef struct OBJ_COLLISION {
   pobject move_obj, col_obj;
   MYFIXED delta_x, delta_y;
   MYFIXED dest_x, dest_y;
   MYFIXED dist_from_move, dis_percent;
   MYFIXED move_len, move_len_sq;
   BOOL found_collision;
   } obj_collision;

void Check_Obj_Collision(pobj_collision the_collision); 
void Slide_Obj(pobject move_obj, 
   pobj_collision the_collision);
void Stop_Obj(pobject move_obj, pobj_collision the_collision);

#endif
