#include "palobj.h"
#include <stddef.h>

LONG palobj::loadpalette(UCHAR imagenum)
{
if (!inpcxfile.is_open()) {
   return -1;
}
if ((palette[imagenum]=new UCHAR [768])==NULL)
  return -1;
LONG seek=inpcxfile.tellg();
inpcxfile.seekg(-768L,ios::end);
inpcxfile.read(palette[imagenum],768);
for (LONG i=0;i<256;i++)
  for (LONG j=0;j<3;j++)
    palette[imagenum][i*3+j]=palette[imagenum][i*3+j]>>2;
inpcxfile.seekg(seek,ios::beg);
return 0;
}

LONG palobj::writepalette(UCHAR imagenum)
{
PUCHAR ch=new UCHAR [1];
ch[0]=12;
outpcxfile.write(ch,1);
PUCHAR temppalette=new UCHAR [768];
for (LONG i=0; i<256; i++) {
   for (LONG j=0; j<3; j++) {
      temppalette[i*3+j]=palette[imagenum][i*3+j]<<2;
   } /* endfor */
} /* endfor */
outpcxfile.write(temppalette,768);
delete temppalette;
delete ch;
return 0;
}

LONG palobj::drawpalette(palette_load_func hw_pal_load_func, UCHAR imagenum)
{
PUCHAR palptr=palette[imagenum];
(*hw_pal_load_func)(palptr);
return 0;
}

LONG palobj::Write(UCHAR imagenum)
{
LONG seek=outpcxfile.tellp();
if (gobject::Write(imagenum)) {
   return -1;
}
if (writepalette(imagenum)) {
   return -1;}
outpcxfile.seekp(seek, ios::beg);
return 0;
}

LONG palobj::load(UCHAR imagenum)
{
if (gobject::load(imagenum))
  return -1;
if (loadpalette(imagenum))
  return -1;
return 0;
}

