#include "fixed.h"
#include "ray.h"
#include "asm.h"
#include "rayrend.h"
#include "globals.h"
#include "scrconf.h"

MYFIXED Scale_Coeff_2d=ONE;

#define MIN_SCALE_2D (ONE / 100)
#define MAX_SCALE_2D (ONE * 10)
#define SCALE_INC_2D (ONE + ONE/20)

void Map_Scale_Decrease()
{
   if (Scale_Coeff_2d > MIN_SCALE_2D) {
      Scale_Coeff_2d=fixeddiv(Scale_Coeff_2d, SCALE_INC_2D);
   } /* endif */
}

void Map_Scale_Increase()
{
   if (Scale_Coeff_2d < MAX_SCALE_2D) {
      Scale_Coeff_2d=fixedmult(Scale_Coeff_2d, SCALE_INC_2D);
   } /* endif */
}

#define POINTS_IN_ARROW 4
#define ARROW_COLOR (255)
#define RED_COLOR (64+15)

const long arrow_struct[POINTS_IN_ARROW][2]= {
   { 12, 0 } ,
   { 3, 9 } ,
   { 3, -9} ,
   { -12, 0} };

long x1_2d, x2_2d, y1_2d, y2_2d;

BOOL Clip_Line_2d();
void Draw_Arrow_2d(long view_angle);
void Line_Draw_2d(Byte color);

void Render_2d(long x, long y, long view_angle)
{

#ifdef NO_2D_YET
return;
#endif
   clearBuff();
   short index1;
   pvector2 v1, v2;

   // Draw dem lines

   for (index1=0; index1<Number_Of_Linedefs; index1++) {
     v1=Vector_List+Ld_List[index1].v[0];
     v2=Vector_List+Ld_List[index1].v[1];


     // Get translated coordinates

     x1_2d= (fixedmult(((v1->x<<SHIFT) - x), Scale_Coeff_2d) >> SHIFT) + WINDOW_MIDDLEW;
     x2_2d= (fixedmult(((v2->x<<SHIFT) - x), Scale_Coeff_2d) >> SHIFT) + WINDOW_MIDDLEW;
     y1_2d= (fixedmult((y - (v1->y<<SHIFT)), Scale_Coeff_2d) >> SHIFT) + WINDOW_MIDDLE;
     y2_2d= (fixedmult((y - (v2->y<<SHIFT)), Scale_Coeff_2d) >> SHIFT) + WINDOW_MIDDLE ;
     if (!Clip_Line_2d())
        Line_Draw_2d(RED_COLOR);
   } /* endfor */

   Draw_Arrow_2d(view_angle); // Draw the arrow of player's direction

}

BOOL Clip_Line_2d()

// Clips line and returns whether it is at all visible

{

   long tempx, tempy;
   long temp_div;

   // Clipping x

   // Make first vertex the left one

   if (x1_2d>x2_2d) {
     tempx=x1_2d;
     x1_2d=x2_2d;
     x2_2d=tempx;
     tempy=y1_2d;
     y1_2d=y2_2d;
     y2_2d=tempy;
   }

   // If the right vertex is to the left of the window, or the left vertex is to the right of the window,
   // the line is not visible

   if ((x2_2d<0) || (x1_2d>=WINDOW_WIDTH)) {
      return TRUE;
   }

   // Ok, line is visible on x

   // Clip against left side of window

   if (x1_2d<0) {
      tempx=x1_2d;
      x1_2d=0;
      temp_div=(y1_2d - y2_2d) * (-tempx) / (tempx - x2_2d);
      y1_2d+=temp_div;
   }

   // Clip against right side of window

   if (x2_2d>=WINDOW_WIDTH) {
      tempx=x2_2d;
      x2_2d=WINDOW_WIDTH-1;
      temp_div=y1_2d+((y1_2d - y2_2d) * (WINDOW_WIDTH -1 - x1_2d)/(x1_2d - tempx));
      y2_2d=temp_div;
   }

   // Clipping y

   // Make first vertex the top vertex

   if (y1_2d>y2_2d) {
     tempx=x1_2d;
     x1_2d=x2_2d;
     x2_2d=tempx;
     tempy=y1_2d;
     y1_2d=y2_2d;
     y2_2d=tempy;
   }

   // If bottom vertex is above window, or top vertex below window, the line is not visible

   if ((y2_2d<0) || (y1_2d>=WINDOW_HEIGHT)) {
      return TRUE;
   }

   // Ok, line is visible on y

   // Clip against top of window

   if (y1_2d<0) {
      tempy=y1_2d;
      y1_2d=0;
      temp_div=(x1_2d - x2_2d) * (-tempy) / (tempy - y2_2d);
      x1_2d+=temp_div;
   }

   // Clip against bottom of window

   if (y2_2d>=WINDOW_HEIGHT) {
      tempy=y2_2d;
      y2_2d=WINDOW_HEIGHT;
      temp_div=x1_2d+((x1_2d - x2_2d)  * (WINDOW_HEIGHT -1 - y1_2d) / (y1_2d - tempy));
      x2_2d=temp_div;
   }

   // The line is visible and clipped

   return FALSE;

}

void Line_Draw_2d(Byte color) {

// Code taken from Flights o' Fantasy that uses Bresenham's algorithym

long x_unit, y_unit;

long offset=y1_2d * Get_Phys_Screen_Width() + x1_2d;

long ydiff=y2_2d-y1_2d;

if (ydiff<0) {

   ydiff=-ydiff;
   y_unit=-Get_Phys_Screen_Width();

}
else y_unit=Get_Phys_Screen_Width();

long xdiff=x2_2d-x1_2d;

if (xdiff<0) {

   xdiff=-xdiff;
   x_unit=-1;

}
else x_unit=1;

long error_term=0;
if (xdiff>ydiff) {

   long length=xdiff+1;
 
   for (long position=0; position < length; position++) {

      buff[offset]=color;
 
      offset+=x_unit;

      error_term+=ydiff;
 
      if (error_term>xdiff) {
         error_term-=xdiff;
         offset+=y_unit;
      }

   } /* endfor */

} else {

   long length=ydiff+1;

   for (long position=0; position < length; position++) {

      buff[offset]=color;

      offset+=y_unit;

      error_term+=xdiff;

      if (error_term>0) {
         error_term-=ydiff;
         offset+=x_unit;
      }

   } /* endfor */

} /* endif */

}

void Draw_Arrow_2d(long view_angle)
{
   short counter;
   long temp_arrow[POINTS_IN_ARROW][2];

   // Translate points in arrow
 
   for (counter=0; counter< POINTS_IN_ARROW; counter++) {
      temp_arrow[counter][0]=(arrow_struct[counter][0] * rcos_table[view_angle])+
                (arrow_struct[counter][1] * rsin_table[view_angle]);
      temp_arrow[counter][0]=fixedmult(temp_arrow[counter][0],Scale_Coeff_2d);
      temp_arrow[counter][0]>>=SHIFT;
      temp_arrow[counter][0]+=WINDOW_MIDDLEW;
      temp_arrow[counter][1]=(arrow_struct[counter][1] * rcos_table[view_angle])-
                (arrow_struct[counter][0] * rsin_table[view_angle]);
      temp_arrow[counter][1]=fixedmult(temp_arrow[counter][1],Scale_Coeff_2d);
      temp_arrow[counter][1]>>=SHIFT;
      temp_arrow[counter][1]+=WINDOW_MIDDLE;
   } /* endfor */

   // Draw the arrow lines

   x1_2d=WINDOW_MIDDLEW; y1_2d=WINDOW_MIDDLE; 
   x2_2d=temp_arrow[0][0]; y2_2d=temp_arrow[0][1];

   Line_Draw_2d(ARROW_COLOR);

   x1_2d=WINDOW_MIDDLEW; y1_2d=WINDOW_MIDDLE; 
   x2_2d=temp_arrow[3][0]; y2_2d=temp_arrow[3][1];

   Line_Draw_2d(ARROW_COLOR);

   x1_2d=temp_arrow[0][0]; y1_2d=temp_arrow[0][1];
   x2_2d=temp_arrow[1][0]; y2_2d=temp_arrow[1][1];

   Line_Draw_2d(ARROW_COLOR);

   x1_2d=temp_arrow[0][0]; y1_2d=temp_arrow[0][1];
   x2_2d=temp_arrow[2][0]; y2_2d=temp_arrow[2][1];

   Line_Draw_2d(ARROW_COLOR);

}
