#include "ray.h"
#include "rayrt.h"
#include <stddef.h>

#define VB_NULL -1

extern "C" vb_node_index vb_next_free_node, vb_start_node;

extern "C" vb_node * bounds;

inline vb_node * VB_GetFirstNode()
{
   return (bounds + vb_start_node);
}

inline void VB_InitList()
{
   vb_next_free_node=0; vb_start_node=0;
   bounds[0].left=0;
   bounds[0].right=WINDOW_WIDTH;
   bounds[0].next_node=VB_NULL; bounds[0].back_node=VB_NULL;
}

inline vb_node_index VB_AllocateNode()
{
   vb_next_free_node++;
   return vb_next_free_node;
}

inline vb_node * VB_GetNextNode(vb_node * base)
{
   if (base->next_node==VB_NULL) {
      return NULL;
   } else {
      return (bounds + (base->next_node));
   } /* endif */

}

inline vb_node * VB_DeleteNode(vb_node * delete_node)
{

   if (delete_node->back_node == VB_NULL) {
      vb_start_node=delete_node->next_node;
      if (vb_start_node == VB_NULL) 
         return NULL;
      else return (bounds+vb_start_node);
   } else {
      if (delete_node->next_node == VB_NULL) {
         bounds[delete_node->back_node].next_node=VB_NULL;
         return NULL;
      } else {
      bounds[delete_node->back_node].next_node=delete_node->next_node;
      bounds[delete_node->next_node].back_node=delete_node->back_node;
      return bounds+delete_node->next_node;
      }
   } /* endif */

}

inline void VB_AttachNode(vb_node * base_node, vb_node_index next_node)
{
   short base_node_index=(short)(base_node-bounds);
   if (next_node!=NULL)
      bounds[next_node].back_node=base_node_index;
   base_node->next_node=next_node;
}

// Cut a section out of visible boundaries. Precondition: start>=end

inline void VB_CoverSection(vb_node * & base_node, SHORT start, SHORT end)
{
   if ((start > base_node->right) || (end <= base_node->left)) 
     return;
   if (start <= base_node->left) {
      if (end >= base_node->right) {
         base_node=VB_DeleteNode(base_node);
      } else {
         base_node->left=end;
      } /* endif */
      return;
   } /* endif */
   if (end >= base_node->right) {
      base_node->right=start; 
      return;
   } /* endif */
   vb_node_index next_node=VB_AllocateNode();
   VB_AttachNode((bounds + next_node), base_node->next_node);
   VB_AttachNode(base_node, next_node);
   bounds[next_node].left=end;
   bounds[next_node].right=base_node->right;
   base_node->right=start;
   base_node=bounds+next_node;
}

inline BOOL VB_EmptyList()
{
   return ((vb_start_node == VB_NULL) ? TRUE : FALSE);
}
