extern "C" long PHYS_SCREEN_HEIGHT;
extern "C" long PHYS_SCREEN_WIDTH;
extern "C" short LOGICAL_SCREEN_HEIGHT; // stores without screen orientation
extern "C" short LOGICAL_SCREEN_WIDTH; // same for width
extern "C" short SCREEN_ORIENTATION; // stores the memory orientation of the bitmap

void Init_Phys_Screen(short width, short height) {
   LOGICAL_SCREEN_WIDTH=width;
   LOGICAL_SCREEN_HEIGHT=height;
   SCREEN_ORIENTATION=1;
   PHYS_SCREEN_WIDTH=(long)(width*SCREEN_ORIENTATION);
   PHYS_SCREEN_HEIGHT=(long)(height*SCREEN_ORIENTATION);
}

void Set_Phys_Screen(short width, short height) {
   LOGICAL_SCREEN_WIDTH=width;
   LOGICAL_SCREEN_HEIGHT=height;
   PHYS_SCREEN_WIDTH=(long)(width*SCREEN_ORIENTATION);
   PHYS_SCREEN_HEIGHT=(long)(height*SCREEN_ORIENTATION);
}

void Set_Phys_Orientation(short new_orientation) {
   SCREEN_ORIENTATION=new_orientation;
   PHYS_SCREEN_WIDTH=(long)(LOGICAL_SCREEN_WIDTH*SCREEN_ORIENTATION);
   PHYS_SCREEN_HEIGHT=(long)(LOGICAL_SCREEN_HEIGHT*SCREEN_ORIENTATION);
}

short Get_Phys_Orientation() {
   return SCREEN_ORIENTATION;
}

short Get_Phys_Screen_Width() {
   return LOGICAL_SCREEN_WIDTH;
}

short Get_Phys_Screen_Height() {
   return LOGICAL_SCREEN_HEIGHT;
}
