#include "ray.h"
#include "globals.h"
#include "rayspr.h"
#include "bspmove.h"
#include "message.h"
#include "blockmap.h"
#include "timer.h"
#include <stddef.h>

pobject Create_Object(long x, long y, long z, angle_type angle,
   short type, pobject owner, ULONG team)
{

      if (type >= Number_Of_OTs) {
         return NULL;
      }

      pobject_node global_node, ss_node;
      pobject cur_object;

      // Create a global node for the object

      global_node=(pobject_node)NewPtr(sizeof(object_node));
      global_node->front=NULL;
      global_node->back=NULL;
      global_node->data=(pobject)NewPtr(sizeof(object));
 
      // Push it into the global node list

      OL_Push_Node(global_node, g_object_list);

      // Initialize given data

      cur_object=global_node->data;
      cur_object->x=x;
      cur_object->y=y;
      cur_object->z=z;
      cur_object->angle=angle;
      cur_object->cur_frame=0;
      cur_object->type=Obj_Type_List+type;

      // Set sector and ssector
      cur_object->cur_ss=Get_Object_SSector(cur_object, bsp_start_node);
      cur_object->cur_sec=Get_Sec_From_SSec(cur_object->cur_ss);
 
      // Save global node pointer in object

      cur_object->global_node=global_node;

      // Setup the sub sector node in object

      cur_object->ss_node=(pobject_node)NewPtr(sizeof(object_node));
      ss_node=cur_object->ss_node;
      ss_node->front=NULL;
      ss_node->back=NULL;
      ss_node->data=cur_object;

      // Push ssector node onto that ssector's list

      OL_Push_Node(ss_node, cur_object->cur_ss->objects);
      cur_object->cur_ss->num_objects++;

      // Setup object for blockmap
      cur_object->block_x=Block_X(cur_object->x);
      cur_object->block_y=Block_Y(cur_object->y);
      cur_object->block_node=(pobject_node)NewPtr(sizeof(object_node));
      cur_object->block_node->front=NULL;
      cur_object->block_node->back=NULL;
      cur_object->block_node->data=cur_object;
      OL_Push_Node(cur_object->block_node, 
         *Get_Block_Obj_List(cur_object->block_x, cur_object->block_y));

      // Clear message queues
      cur_object->send_objects=NULL;
      cur_object->receive_objects=NULL;
 
      // set owner
      cur_object->owner=owner;

      // set team
      cur_object->team=team;

      // initalize stats
      cur_object->stats.current_speed=cur_object->type->stats.base_speed;
      cur_object->stats.current_health=cur_object->type->stats.total_health;

      // Set default extra data, for now

      cur_object->extra_data=NULL;
      (*cur_object->type->Load_Extra)(cur_object, BAD_LOAD_OFFSET);

      if (updating) {
         cur_object->type->Update(cur_object, Get_Update_Num());
      }
      return cur_object;
 
}

void Kill_Object(pobject del_obj)
{

   Send_Auto_Message(del_obj, KILLED_MESSAGE, NULL);

   pobject_node cur_node, next_node;
   cur_node=del_obj->send_objects;
   while (!OL_Empty_Node(cur_node)) {
      next_node=OL_Next_Node(cur_node);
      Release_Object_Messages(del_obj, cur_node->data);
      cur_node=next_node;
   }
   cur_node=del_obj->receive_objects;
   while (!OL_Empty_Node(cur_node)) {
      next_node=OL_Next_Node(cur_node);
      Release_Object_Messages(cur_node->data, del_obj);
      cur_node=next_node;
   }

   // Clear nodes

   OL_Delete_Node(del_obj->ss_node, del_obj->cur_ss->objects);
   del_obj->cur_ss->num_objects--;
   OL_Delete_Node(del_obj->global_node, g_object_list);
   OL_Delete_Node(del_obj->block_node, 
      *Get_Block_Obj_List(del_obj->block_x, del_obj->block_y));
   DelPtr( del_obj->global_node);
   DelPtr( del_obj->ss_node);
   DelPtr( del_obj->block_node);

   // Delete any extra the object might have

   if (del_obj->extra_data!=NULL)
     DelPtr( del_obj->extra_data);

   // and delete the object

   DelPtr( del_obj);

}

void Clear_Objects() {
   pobject cur_obj;
   while (g_object_list!=NULL) {
      cur_obj=g_object_list->data;
      Kill_Object(cur_obj);
   }
}
