#include "ray.h"
#include "globals.h"
#include "rayspr.h"
#include "rayrend.h"
#include "forever.h"
#include "prevarr.h"
#include "rayvb.h"
#include "voxinter.h"
#include "sprdimen.h"

void Draw_Sprite(pobject cur_sprite);
inline  BOOL Bubble_Down(USHORT element_num);
void Depth_Sort_Objects(pobject_node list, USHORT  num_elements); 

pobject_node sorting_list;

void Translate_Object_Vectors(pobject_node trans_list)
{
   pobject_node cur_obj_node=trans_list;
   pobject cur_obj;
   while ( !(OL_Empty_Node(cur_obj_node)) ) {
      cur_obj=cur_obj_node->data;
      rotate_angle=render_view_angle;
      rotate_x=cur_obj->x - render_x;
      rotate_y=cur_obj->y - render_y;
      cur_obj->tx=FixedRotateY();
      cur_obj->ty=FixedRotateX();
      cur_obj_node=OL_Next_Node(cur_obj_node);
   } /* endwhile */
}

void Draw_SS_Sprites(pssector cur_ss)
{
USHORT obj_count;
pobject_node cur_node;

Translate_Object_Vectors(cur_ss->objects);

obj_count=cur_ss->num_objects;
Depth_Sort_Objects(cur_ss->objects, obj_count);

cur_node=cur_ss->objects;

while ( !(OL_Empty_Node(cur_node)) ) {
   (*cur_node->data->type->Render_Func)(cur_node->data);
   cur_node=OL_Next_Node(cur_node);
   }
   
}

void Draw_Sprite(pobject cur_sprite)
{

if ((cur_sprite->ty>>SHIFT)<=0)
  return;

pobject_type spr_type;
wall_run_info * cur_wall_run;
short mid_proj;
short abs_proj_left, abs_proj_right, cur_proj_left, cur_proj_right;
MYFIXED height_top, height_bottom; 
short sprite_start, sprite_end, spr_sc_height, spr_sc_width;
Ptr sprite_texture, sprite_light;
long temp_frame, temp_light;
MYFIXED sprite_inc_y, sprite_inc_x, spr_start_col;
pvb_node cur_bounds, next_bounds;
short screen_x, cur_start, cur_end;
MYFIXED sprite_clip;
MYFIXED spr_col_base;

spr_type=cur_sprite->type;
mid_proj=(fixedmd(-cur_sprite->tx, SCALE_FACTOR, cur_sprite->ty))+
        WINDOW_MIDDLEW;

if (cur_sprite->cur_sec->flags & VOXEL_SECTOR) {
   height_bottom=cur_sprite->z+Get_Voxel_Alt((PUCHAR)cur_sprite->cur_sec->extra_data,
         cur_sprite->x, cur_sprite->y);
} else {
   height_bottom=cur_sprite->cur_sec->floor_height+cur_sprite->z;
}/* endif */

height_top=height_bottom+(spr_type->height);

height_bottom=GetZScVal(height_bottom, cur_sprite->ty);

height_top=GetZScVal(height_top, cur_sprite->ty);

sprite_start=height_top>>SHIFT;

sprite_end=height_bottom>>SHIFT;

spr_sc_height=sprite_end-sprite_start;

if (spr_type->wshift > spr_type->hshift) {
   spr_sc_width=spr_sc_height << (spr_type->wh_ratio);
} else {
   spr_sc_width=spr_sc_height >> (spr_type->wh_ratio);
}

if ((spr_sc_width<=0)||(spr_sc_height<=0))
   return;

abs_proj_left=mid_proj-(spr_sc_width >> 1);
abs_proj_right=mid_proj+(spr_sc_width >> 1);

if (abs_proj_right<0)
  return;

if (abs_proj_left>=WINDOW_WIDTH)
   return;

// Get the light of sprite

temp_light=(SecLight(cur_sprite->cur_sec) -
   (cur_sprite->ty>>(SHIFT+SecLTSpeed(cur_sprite->cur_sec))) );
if (temp_light<0) {
   temp_light=0;
} /* endif */
if (temp_light>MAX_LIGHT) {
   temp_light=MAX_LIGHT;
} /* endif */

sprite_light=pal_table[temp_light];


// Get sprite texture

temp_frame=Get_Angle_Difference(cur_sprite->angle, render_view_angle);
temp_frame=Get_Angle_Sum(temp_frame, ANGLE_180);
temp_frame=Get_Angle_Sum(spr_type->half_angle, temp_frame);
temp_frame=(temp_frame*spr_type->angle_num)/ANGLE_360;
temp_frame&= (spr_type->angle_num -1);
 
sprite_texture=Get_Sprite_Texture(spr_type->frames[temp_frame], 
        cur_sprite->cur_frame);

sprite_inc_x=((Get_Sprite_Texture_Width(spr_type->frames[temp_frame]) << SHIFT) / spr_sc_width);

sprite_inc_y=((Get_Sprite_Texture_Height(spr_type->frames[temp_frame]) << SLIVER_SHIFT) / spr_sc_height);

if (spr_type->rev_frames[temp_frame]) {
   spr_start_col=((Get_Sprite_Texture_Width(spr_type->frames[temp_frame])) << SHIFT)-1;
   sprite_inc_x=-sprite_inc_x;
} else {
   spr_start_col=0;
}

short texture_and_height=Get_Sprite_Texture_Height(spr_type->frames[temp_frame])-1;
Byte texture_width_shift=Get_Sprite_Texture_Shift(spr_type->frames[temp_frame]);

//loop for necessary bounds
next_bounds=VB_GetFirstNode();

// loop w/ exit

FOREVER {

   if (next_bounds==NULL) {
      break;
   } /* endif */

   cur_bounds=next_bounds;
   next_bounds=VB_GetNextNode(next_bounds);

   // is whole sprite right of bounds. If so, go to next bound
 
   if (abs_proj_left>=cur_bounds->right) {
      continue;
   } /* endif */

   // is whole sprite left of bounds. If so, we're done

   if (abs_proj_right<=cur_bounds->left) {
      break;
   } /* endif */

   //get horiz bounds of current run

   cur_proj_left=abs_proj_left;
   if (cur_proj_left<cur_bounds->left) {
       //get starting texture x pos for bounds
      spr_col_base=spr_start_col+(cur_bounds->left-cur_proj_left)*sprite_inc_x;
      cur_proj_left=cur_bounds->left;
   } else {
      //get starting texture x pos for bounds
      spr_col_base=spr_start_col;
   } /* endif */

   cur_proj_right=abs_proj_right;
   if (cur_proj_right>cur_bounds->right) {
      cur_proj_right=cur_bounds->right;
   } /* endif */

   //loop for bounds length
   for (screen_x=cur_proj_left; screen_x<cur_proj_right; screen_x++) {
      //clip end y
      if (sprite_end > win_bottoms[screen_x]) {
         cur_end=win_bottoms[screen_x];
         if (cur_end<=sprite_start) {
            continue;
         } /* endif */
      } else {
         cur_end=sprite_end;
      } /* endif */

      //clip start y
      if (sprite_start < win_tops[screen_x]) {
         cur_start=win_tops[screen_x];
         if (cur_end<=cur_start) {
            continue;
         } /* endif */
         sprite_clip=sprite_inc_y * (cur_start-sprite_start);
      } else {
         cur_start=sprite_start;
         sprite_clip=0;
      } /* endif */

      if (wall_run_count>=MAX_WALL_RUNS) {
         break;
      }

      cur_wall_run=wall_runs+wall_run_count;
      wall_run_count++;

      //set start y pos, scale and clip val in texture
      cur_wall_run->width_shift=texture_width_shift;
      cur_wall_run->bound_val=texture_and_height;
      cur_wall_run->top=cur_start;
      cur_wall_run->scale=cur_end-cur_start;
      cur_wall_run->clip=sprite_clip;

      //set texture y increment,texture, screen x pos, and light
      cur_wall_run->increment=sprite_inc_y;
      cur_wall_run->texture=sprite_texture;
      cur_wall_run->ray=screen_x;
      cur_wall_run->light=sprite_light;

      //set x pos in texture
      cur_wall_run->column=(spr_col_base>>SHIFT);
      spr_col_base+=sprite_inc_x;

   } /* end loop for current bounds*/

} /* end loop for whole sprite */
         
}

void Draw_Flat_Sprite(pobject cur_sprite) {
   short start_x, start_y, length_x, length_y;
   pspr_dimensions cur_dimensions;
   MYFIXED inc_x, inc_y;
   MYFIXED sum_x;
   Byte * sprite_texture;
   short texture_height_and, texture_width_shift;
   Byte * sprite_light;
   wall_run_info * cur_wall_run;

   cur_dimensions=(pspr_dimensions)cur_sprite->type->render_data;
 
   start_x=fixedmult(cur_dimensions->start_x, WINDOW_WIDTH);
   start_y=fixedmult(cur_dimensions->start_y, WINDOW_HEIGHT);
   length_x=fixedmult(cur_dimensions->length_x, WINDOW_WIDTH);
   length_y=fixedmult(cur_dimensions->length_y, WINDOW_HEIGHT);

   if ((length_x<=0)||(length_y<=0))
      return;

   inc_x=(Get_Sprite_Texture_Width(cur_sprite->type->frames[0]) << SHIFT) / length_x;
   inc_y=(Get_Sprite_Texture_Height(cur_sprite->type->frames[0]) << SLIVER_SHIFT) / length_y;

   sprite_light=pal_table[SecLight(cur_sprite->cur_sec)];
   texture_height_and=Get_Sprite_Texture_Height(cur_sprite->type->frames[0])-1;
   texture_width_shift=Get_Sprite_Texture_Shift(cur_sprite->type->frames[0]);
   sprite_texture=Get_Sprite_Texture(cur_sprite->type->frames[0], 
      cur_sprite->cur_frame);

   sum_x=0;
   for (short cur_x=0; cur_x<length_x; cur_x++) {
      cur_wall_run=wall_runs+wall_run_count;
      wall_run_count++;
 
      cur_wall_run->width_shift=texture_width_shift;
      cur_wall_run->bound_val=texture_height_and;
      cur_wall_run->texture=sprite_texture;
      cur_wall_run->clip=0;
      cur_wall_run->increment=inc_y;
      cur_wall_run->top=start_y;
      cur_wall_run->scale=length_y;
      cur_wall_run->light=sprite_light;
      cur_wall_run->ray=cur_x+start_x;
      cur_wall_run->column=sum_x>>SHIFT;

      sum_x+=inc_x;

   } /* endfor */

}

void Depth_Sort_Objects(pobject_node list, USHORT num_objects)
{

sorting_list=list;

USHORT cur_find;

//loop in descending order finding correct nodes for each spot
  
for (cur_find=num_objects; cur_find>1; cur_find--) {

   //if no swaps are made finding the correct node
   if (!Bubble_Down(cur_find)) {
                              
      //list is sorted so stop
      break;
      }
}
}

inline BOOL Bubble_Down(USHORT element_num)
{

pobject_node cur_node, next_node;
USHORT cur_element;
BOOL swap_made;

//get first positive y object

cur_node=sorting_list;
cur_element=1;

while ( (Sprite_Y(cur_node)<0) && (cur_element<element_num) ) {
   cur_node=OL_Next_Node(cur_node);
   cur_element++;
   }

//go through remaining objects

swap_made=FALSE;   

while (cur_element<element_num) {

   //is current y greater than next node's y?

   next_node=OL_Next_Node(cur_node);

   if ( Sprite_Y(cur_node) > Sprite_Y(next_node) ) {
   
      //swap them
      OL_Swap_SS_Nodes(cur_node, next_node);

      //note that a swap has been made
      swap_made=TRUE;


   }

   cur_node=OL_Next_Node(cur_node);
   cur_element++;

}

//tell caller whether any swaps were made
return swap_made;
}


