#include "os.h"
#include "timer.h"
#include "sound.h"

long update_num, update_save;

#ifdef OS_DOS
#include <i86.h>
#include <dos.h>
#include <conio.h>

#define TIMER_INT 0x8
#define UPDATE_INT 0x1c

// These, are some weird port numbers for setting up a clock double-
// I'm not even sure why the whole clock double works

#define CMD_REG 0x43 
#define CHAN_0 0x40
#define INT_CONTROL     0x20         // interrupt control register 

BOOL right_time_mode;
BOOL update_mode;  // Used for timer interrupt

void (_interrupt _far * Old_Update_Isr)(); // holds old update interrupt
void (_interrupt _far * Old_Timer_Isr)(); // holds old timer interrupt

void SetTimeSpeed(unsigned char speed)
{
   // This tells the hardware to double the clock speed
   // I'm not sure why this works- I got it from a magazine
   long tempval; unsigned char lowhalf, highhalf;
   tempval=65536/speed;
   lowhalf=(unsigned char)(tempval & 0x000000ff);
   highhalf= (unsigned char)((tempval & 0x0000ff00) >> 8);
   outp(CMD_REG, 0x36);
   outp(CHAN_0, lowhalf);
   outp(CHAN_0, highhalf);
}

void Suspend_Time() {
   update_save=update_num;
   update_num=0;
}

void Resume_Time() {
   update_num=update_save;
}

void _interrupt _far New_Update_Int() {
  Update_Sound();
  update_num++;
}

void _interrupt _far New_Timer_Int(void)
{
   // Ok, in this interrupt, the  old timer int is called only half the time, and since the clock is doubled,
   // this keeps the internal time right. The update interrupt is always called (either explicitly
   // or implicitly), causing the updates to be twice as fast.

   if (update_mode) {
      update_mode=FALSE;
      if (!right_time_mode) {
          right_time_mode=TRUE;
          outp(0x20, 0x20);
          _chain_intr(New_Update_Int);
       } else {
          right_time_mode=FALSE;
          _chain_intr(Old_Timer_Isr);
       } /* endif */
   } else {
       outp(0x20, 0x20);
       Update_Sound();
       update_mode=TRUE;
   }

}

#endif

void Init_Timer() {
update_num=0;

#ifdef OS_DOS

update_mode=FALSE;
right_time_mode=FALSE;

Old_Timer_Isr = _dos_getvect(TIMER_INT);

_dos_setvect(TIMER_INT, New_Timer_Int);

SetTimeSpeed(4);

Old_Update_Isr = _dos_getvect(UPDATE_INT);

_dos_setvect(UPDATE_INT, New_Update_Int);
#endif
}

void Reset_Timer() {
   update_num=0;
}

void Close_Timer() {
#ifdef OS_DOS
   _dos_setvect(TIMER_INT, Old_Timer_Isr);
   SetTimeSpeed(1);
   _dos_setvect(UPDATE_INT, Old_Update_Isr);
#endif
}
 

long Get_Update_Num() {
#ifdef OS_DOS
  return update_num;
#endif

#ifdef OS_WINDOWS
  return (update_num++);
#endif
}


