#include "ray.h"
#include "globals.h"
#include "rayspr.h"
#include "sprfunc.h"
#include "sfvars.h"
#include "turret.h"
#include "sprtypes.h"

#define FIRE_TIME 30
#define ANGLE_INC 120

void Turret_Create(pobject cur_object, long offset);
void Turret_Update(pobject cur_object, long update_num);
void Turret_Update_Z(pobject cur_object, psector new_sec);

void Init_Turrets(func_index index) {
   update_funcs[index]=Turret_Update;
   update_z_funcs[index]=Turret_Update_Z;
   load_extra_funcs[index]=Turret_Create;
}

void Turret_Create(pobject cur_object, long offset) {
   PSHORT cur_time=(PSHORT)NewPtr(sizeof(short));

   *(cur_time)=0;
   cur_object->extra_data=(pdata)cur_time;
   }

void Turret_Update_Z(pobject cur_object, psector new_sec) {
   }

void Turret_Update(pobject cur_object, long update_num) {
  PSHORT cur_time=(PSHORT)cur_object->extra_data;
                               
  if (++(*cur_time)==FIRE_TIME) {
     cur_object->angle=Get_Angle_Sum(cur_object->angle, ANGLE_INC); 
     Create_Object(cur_object->x, cur_object->y, cur_object->z+cur_object->type->eye_height,
        cur_object->angle, BULLET_TYPE, cur_object, cur_object->team);
     *(cur_time)=0;
        if (++cur_object->cur_frame==
            wall[cur_object->type->frames[0]].num_image)
           cur_object->cur_frame=0;
  }
}

