#include "ray.h"
#include "resnames.h"
#include "globals.h"
#include "voxel.h"
#include "rayfile.h"
#include "waves.h"
#include "prevarr.h"
#include "scrconf.h"
#include "gentree.h"
#include "sprvox.h"
#include "verttan.h"

#define VOX_PAL_FILE "vox.pal"
#define START_DIS VOXEL_SPEED_SCALE
#define START_HEIGHT 3

BOOL voxel_running=FALSE;
PUCHAR pal_save;
//long old_px, old_py, old_pv_angle; No longer needed as engines use one coordinate system

void Setup_G_Table();
void Setup_Y_Jumps();
void Setup_Alt_Scaler();
void Setup_H_Table();
void Setup_Change_Table();

inline void Del_Alt_Scaler() {
  for (short i=0; i<DIST_MAX; i++)
    DelPtr(alt_scaler[i]);
  DelPtr(alt_scaler);
}

void Close_Voxel()
{
   if (!voxel_running) {
      return;
   } /* endif */
   DelPtr(g_table);
   DelPtr(y_jumps);
   Del_Alt_Scaler();
   Close_Waves();  
   voxel_running=FALSE;
}

void Init_Voxel()
{
DIST_SCALER=START_DIS;
V_Set_Dist_Scale(START_HEIGHT);
Setup_Voxel_Tables();
Setup_Waves();
voxel_running=TRUE;
Init_Vox_Sprite_Table();
}

void Setup_Voxel_Tables()
{
   Setup_Y_Jumps();
   Setup_G_Table();
   Setup_Alt_Scaler();
   Setup_H_Table();
   Setup_Change_Table();
}


void Setup_Y_Jumps()
{
   y_jumps=(PULONG)NewPtr(Get_Phys_Screen_Height() * sizeof(ULONG));

if (Get_Phys_Orientation()>0) {
   ULONG cur_offset=0;
   for (USHORT cur_y=0; cur_y<Get_Phys_Screen_Height(); cur_y++) {
      y_jumps[cur_y]=cur_offset;
      cur_offset+=(ULONG)Get_Phys_Screen_Width();
   } /* endfor */
} else {
   ULONG cur_offset=(Get_Phys_Screen_Height()-1)*Get_Phys_Screen_Width();
   for (USHORT cur_y=0; cur_y<Get_Phys_Screen_Height(); cur_y++) {
      y_jumps[cur_y]=cur_offset;
      cur_offset-=(ULONG)Get_Phys_Screen_Width();
   }
}

}

void Setup_H_Table() {
   h_table=(PLONG)NewPtr(Get_Phys_Screen_Height() *2 * MAX_TABLED_HC_INTP*sizeof(long));

   short cur_height_diff, cur_r_length;
   short real_height_diff;

   for (cur_height_diff=0; cur_height_diff<(Get_Phys_Screen_Height()*2); cur_height_diff++) {

      real_height_diff=cur_height_diff-Get_Phys_Screen_Height();

         // set 0 manually as loop cause div by 0
         h_table[cur_height_diff*MAX_TABLED_HC_INTP]=0;
         for (cur_r_length=1; cur_r_length<MAX_TABLED_HC_INTP; cur_r_length++) {
            h_table[MAX_TABLED_HC_INTP*cur_height_diff+cur_r_length]=(long)
               (((long)real_height_diff << HEIGHT_CHANGE_SHIFT) /
               (long)cur_r_length);
         } /* endfor */
      } /* endif */

}

void Setup_Change_Table() {
   vox_change_table=(PVOID)NewPtr(Get_Phys_Screen_Width()*HCP_SIZE);
}

void Setup_G_Table()
{
   g_table=(PSHORT)NewPtr((Get_Phys_Screen_Width()+1)*COLOR_DIFF_COUNT*sizeof(short));

   short cur_col_diff, cur_r_length;
   short real_col_diff;

   for (cur_col_diff=0; cur_col_diff<COLOR_DIFF_COUNT; cur_col_diff++) {

      real_col_diff=cur_col_diff-G_TABLE_ADJUST;

      // is this a color diff there is posible interpolation for
      if ((real_col_diff<MAX_INT_LIGHT_DIFF)&&(real_col_diff>MIN_INT_LIGHT_DIFF)) {

         // set 0 manually as loop cause div by 0
         g_table[cur_col_diff]=0;
         for (cur_r_length=1; cur_r_length<(Get_Phys_Screen_Width()+1); cur_r_length++) {
            g_table[COLOR_DIFF_COUNT*cur_r_length+cur_col_diff]=(short)
               (((long)real_col_diff << LIGHT_FP_SHIFT) /
               (long)cur_r_length);
         } /* endfor */
      } else {
         for (cur_r_length=0; cur_r_length<(Get_Phys_Screen_Width()+1); cur_r_length++) {
            g_table[COLOR_DIFF_COUNT*cur_r_length+cur_col_diff]=0;
         } /* endfor */
      } /* endif */

   } /* endfor */

}

void Setup_Alt_Scaler()
{
   short cur_dis;
   short cur_alt;
   long temp_calc;

   // allocate altitudes
   alt_scaler=(PSHORT *)NewPtr(DIST_MAX * sizeof(PSHORT));
   for (cur_dis=0; cur_dis<DIST_MAX; cur_dis++) {
      alt_scaler[cur_dis]=(PSHORT)NewPtr(ALT_MAX * sizeof(SHORT));
   } /* endfor */

   // get screen heights by altitudes
   for (cur_dis=1; cur_dis<DIST_MAX; cur_dis++) {
      for (cur_alt=0; cur_alt<ALT_MAX; cur_alt++) {
         temp_calc=(LONG)(ALT_MAX-(cur_alt+1));
         temp_calc*=HEIGHT_SCALER;
         temp_calc*=(y_trans/(cur_dis*DIST_SCALER));
         temp_calc>>=SHIFT;
         alt_scaler[cur_dis][cur_alt]=(SHORT)temp_calc;
      } /* endfor */
   } /* endfor */

}

void V_Recalc_Alts()
{
if (voxel_running) {
   Del_Alt_Scaler();
   Setup_Alt_Scaler();
}
}

void V_Recalc_Screen() {
   if (voxel_running) {
      DelPtr(y_jumps);
      DelPtr(g_table);
      DelPtr(h_table);
      DelPtr(vox_change_table);
      Setup_Y_Jumps();
      Setup_G_Table();
      Setup_H_Table();
      Setup_Change_Table();
   }
}

void V_Recalc_Length() {
   if (voxel_running) {
      v_horiz_length=WINDOW_WIDTH;
   }
}


