/*  main.c
 *
 *  Driver code for SAN 386 project.
 *
 *  Written and copyright (c) 1994 by Steve Madsen.  All rights reserved.
 */

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <stdarg.h>
#include <xlib_all.h>
#include "project.h"
#include "math.h"
#include "gfx.h"
#include "object.h"
#include "stars.h"

#define DELAY 35   /* delay in scrolling during closing text */

extern unsigned _stklen = 16384;
extern WORLD *world;
extern int lineno;
char *bold, *serif;
FILE *out;

/*  loadfonts()
 *
 *  Loads user fonts.
 */

void loadfont(char **font, char *filename)
{
  FILE *f;

  *font = malloc(4100);
  if ((f = fopen(filename, "rb")) == NULL) {
    x_text_mode();
    printf("error loading user font %s\n", filename);
    exit(1);
  }
  if (!fread(*font, 4100, 1, f) && ferror(f)) {
    fclose(f);
    x_text_mode();
    printf("error reading font file %s\n", filename);
    exit(1);
  }
  fclose(f);
}

/*  opening()
 *
 *  Opening credits over a starfield.
 */

char *opening_text[] = {
"SAN 386", (char *) 3,
"Spring 1994", (char *) 3,
"Final Project", (char *) 3,
"", (char *) 2,
"This demonstration was written by", (char *) 3,
"Steve Madsen", (char *) 3,
"See the closing sequence for thanks!", (char *) 3,
"(hit ESC anytime to quit)", (char *) 3,
"Enjoy the show!", (char *) 3,
NULL
};

void opening(void)
{
  int sindex = 0, index, width, height;
  COLOR stars = { 0, 0, 0 }, text = { 0, 0, 0 };
  time_t epoch;

  LoadBackground(NULL, 0);
  SeedStars(50);
  SetPaletteColor(1, &text);
  SetPaletteColor(STAR_COLOR, &stars);
  while (stars.red < 50) {
    AnimateStars();
    PageFlip();
    stars.red++;
    stars.green++;
    stars.blue++;
    SetPaletteColor(STAR_COLOR, &stars);
  }
  height = (screenheight - (byte)(bold + 2)) >> 1;
  while (opening_text[sindex] != NULL) {

    /* write the text to all three pages */

    width = 0;
    for (index = 0; index < strlen(opening_text[sindex]); index++)
      width += x_get_char_width(opening_text[sindex][index]);
    width = (320 - width) >> 1;

    /* fade color in while animating stars */

    while (text.blue < 63) {
      AnimateStars();
      x_printf(width, height, HiddenPageOffs, 1, "%s", opening_text[sindex]);
      PageFlip();
      text.blue++;
      SetPaletteColor(1, &text);
    }

    /* wait a few seconds while animating */

    epoch = time(NULL);
    while (difftime(time(NULL), epoch) < (long)(opening_text[sindex + 1])) {
      AnimateStars();
      x_printf(width, height, HiddenPageOffs, 1, "%s", opening_text[sindex]);
      PageFlip();
    }

    /* fade color to black */

    while (text.blue > 0) {
      AnimateStars();
      x_printf(width, height, HiddenPageOffs, 1, "%s", opening_text[sindex]);
      PageFlip();
      text.blue--;
      SetPaletteColor(1, &text);
    }

    /* next string */

    sindex += 2;
  }
  while (stars.red > 0) {
    AnimateStars();
    PageFlip();
    stars.red--;
    stars.green--;
    stars.blue--;
    SetPaletteColor(STAR_COLOR, &stars);
  }
  x_rect_fill(0, 0, 320, screenheight, VisiblePageOffs, 0);
  SetPalette(&defpal);
}

/*  objects()
 *
 *  Demo various objects.
 */

char *obj_defs[] = {
"Solid Cubes", "solid.def", (char *) 5,
"", "solid2.def", (char *) 5,
"Shaded Cubes", "shaded.def", (char *) 5,
"", "shaded2.def", (char *) 5,
"Textured Cube", "texture.def", (char *) 10,
"Complex Objects", "torus.def", (char *) 10,
"", "torus2.def", (char *) 10,
NULL,
"", "chess.def", (char *) 10,
"", "ship.def", (char *) 10,
NULL
};

void objects(int starting)
{
  int oindex, index, width, height, first = TRUE;
  COLOR text = { 0, 0, 0 };
  POINT oldeye;
  time_t epoch;

  height = (screenheight - (byte)(bold + 2)) >> 1;
  oindex = starting * 3;
  while (obj_defs[oindex] != NULL) {

    if (strlen(obj_defs[oindex]) != 0) {

      /* display text to introduce next demo */

      width = 0;
      for (index = 0; index < strlen(obj_defs[oindex]); index++)
        width += x_get_char_width(obj_defs[oindex][index]);
      width = (320 - width) >> 1;

      SetPalette(&defpal);
      LoadBackground(NULL, 0);

      while (text.blue < 63) {
        x_rect_fill(110, 90, 210, 110, HiddenPageOffs, backcolor);
        x_printf(width, height, HiddenPageOffs, 1, "%s", obj_defs[oindex]);
        PageFlip();
        text.blue++;
        SetPaletteColor(1, &text);
      }

      /* wait a few seconds */

      epoch = time(NULL);
      while (difftime(time(NULL), epoch) < 3) ;

      /* fade color to black */

      while (text.blue > 0) {
        x_rect_fill(110, 90, 210, 110, HiddenPageOffs, backcolor);
        x_printf(width, height, HiddenPageOffs, 1, "%s", obj_defs[oindex]);
        PageFlip();
        text.blue--;
        SetPaletteColor(1, &text);
      }
    }
    x_rect_fill(110, 90, 210, 110, Page0_Offs, 0);
    x_rect_fill(110, 90, 210, 110, Page1_Offs, 0);
    x_rect_fill(110, 90, 210, 110, Page2_Offs, 0);

    /* read in the .def file */

    SetPalette(&defpal);
    LoadBackground(NULL, 0);
    if ((yyin = fopen(obj_defs[oindex + 1], "r")) == NULL) {
      x_text_mode();
      printf("Cannot open definition file %s\n", obj_defs[oindex + 1]);
      exit(1);
    }
    world = NewWorld();
    if (first)
      first = FALSE;
    else {
      lineno = 1;
      yyrestart(yyin);
    }
    yyparse();
    fclose(yyin);
    if (background == BLACK)
      LoadBackground(NULL, 0);

    /* start with our eye way back, bring it forward */

    oldeye = eye;
    eye.z = INT_TO_FIXED(100);
    while (eye.z != oldeye.z) {
      UpdateWorld(world);
      DrawWorld(world);
      PageFlip();
      eye.z -= INT_TO_FIXED(1);
    }

    /* rotate it for desired time */

    epoch = time(NULL);
    while (difftime(time(NULL), epoch) < (long)(obj_defs[oindex + 2])) {
      UpdateWorld(world);
      DrawWorld(world);
      PageFlip();
    }

    /* pull eye way back */

    while (eye.z < INT_TO_FIXED(100)) {
      UpdateWorld(world);
      DrawWorld(world);
      PageFlip();
      eye.z += INT_TO_FIXED(1);
    }
    DestroyWorld(world);

    oindex += 3;
  }
}

/*  closing()
 *
 *  Closing credits.
 */

char *closing_text[] = {
"SAN 386",
"Spring 1994",
"Final Project",
"",
"Written by Steve Madsen",
"",
"Thanks go out to:",
"",
"Michael Abrash",
"the fixed point routines and",
"wonderful textured polygons",
"",
"Themie Gouthas",
"and everyone who has worked on Xlib",
"",
"Draeden / VLA",
"matrix rotation and how to do starfields",
"",
"Mark Morley",
"GIF decoder",
"",
"Future Crew",
"for some incredible demos...",
"",
"Mike Symon",
"for living with me these past few days",
"",
"and everyone on the Internet",
"who answered some surely brain damaged",
"questions...",
"",
"If you have any comments on this demo,",
"or you want to offer suggestions,",
"or chat for some reason,",
"write me!",
"",
"smadsen@cs.muohio.edu",
"",
"And yes, I realize this demo isn't that great.",
"I do plan on making some improvements during",
"this summer!",
NULL
};

void closing(void)
{
  int cindex = 0, index, width, height;
  COLOR black = { 0, 0, 0 };

  x_remove_vsync_handler();
  x_set_mode(X_MODE_320x200, 320);
  SetPalette(&defpal);
  height = (byte)(serif + 2) + 5;
  x_rect_fill(0, 0, 320, 200 + (height << 1), VisiblePageOffs, backcolor);
  x_set_start_addr(0, height);
  while (closing_text[cindex] != NULL) {

    /* print the string just below visible screen */

    width = 0;
    for (index = 0; index < strlen(closing_text[cindex]); index++)
      width += x_get_char_width(closing_text[cindex][index]);
    width = (320 - width) >> 1;
    x_printf(width, 200 + height + 1, VisiblePageOffs, 15, "%s", closing_text[cindex]);

    /* start moving the screen up line by line until ready for next string */

    for (index = 0; index < height; index++) {
      x_shift_rect(0, height, 320, 200 + (height << 1) + 1, 0, height - 1, VisiblePageOffs);
      delay(DELAY);
    }

    if (kbhit() && getch() == 27) {
      FadeOut(&black);
      GraphicsDone();
      exit(0);
    }
    cindex++;
  }
  for (index = 0; index < 200; index++) {
    x_shift_rect(0, height, 320, 200 + (height << 1), 0, height - 1, VisiblePageOffs);
    delay(DELAY);
  }
}

void remove_vsync(void)
{
  x_remove_vsync_handler();
}

#pragma exit remove_vsync

float strtofloat(char *str)
{
  int neg = 0;
  float result = 0.0, div = 10.0;
  char *c = str;

  if (*c == '-') {
    neg = 1;
    c++;
  }
  while (*c != '.' && *c != '\0') {
    switch (*c) {
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9': result = (result * 10) + (float)(*c++ - '0'); break;
    }
  }
  if (*c != '\0') {
    c++;
    while (*c != '\0') {
      switch (*c) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9': result = result + ((*c++ - '0') / div); div *= 10; break;
      }
    }
  }
  if (neg == 1)
    result = -result;
  return (result);
}

void report(char *fmt, ...)
{
  va_list arg;

  va_start(arg, fmt);
  vfprintf(out, fmt, arg);
  va_end(arg);
  fclose(out);
  out = fopen("output", "a");
}

void main(int argc, char *argv[])
{
  COLOR black = { 0, 0, 0 };

  if (x_processor() < I80386SX) {
    printf("Sorry, this program requires the use of an 80386 processor.\n");
    exit(1);
  }
  if (x_graphics_card() != VGAColor) {
    printf("Sorry, this program requires a VGA or compatible video card.\n");
    exit(1);
  }
  FadeOut(&black);
  GraphicsInit();
  FadeOut(&black);  /* graphics init resets the palette */
  x_text_init();
  loadfont(&bold, "modernb.fnt");
  loadfont(&serif, "varswisl.fnt");
  do {
    switch (atoi(argv[1])) {
      case 0:
        x_register_userfont(bold);
        x_set_font(FONT_USER);
        opening();
      case 1:
        x_register_userfont(bold);
        x_set_font(FONT_USER);
        objects(0);
        x_register_userfont(serif);
        x_set_font(FONT_USER);
        closing();
        break;
      case 2:
        x_register_userfont(bold);
        x_set_font(FONT_USER);
        objects(5);
      case 3:
        x_register_userfont(serif);
        x_set_font(FONT_USER);
        closing();
        break;
    }
  } while (argc > 1 && strcmp(argv[1], "loop") == 0);
  GraphicsDone();
}

