%{
/*  scanner.l
 *
 *  Written and copyright (c) 1994 by Steve Madsen.  All rights reserved.
 *
 *  flex 2.3 scanner for the SAN 386 world object system
 */

extern int lineno;
char linebuf[100];
int tokenpos = 0;
 
%}
 
digit           [0-9]
dot             [.]
alpha           [A-Za-z]
alphanum        [A-Za-z0-9_]
neg             [-]
dosallowed      [-A-Za-z0-9_:]|"\\"
name            {alpha}{alphanum}*
gif             [.][Gg][Ii][Ff]
pxm             [.][Pp][Xx][Mm]
giffile         {dosallowed}+{gif}
pxmfile         {dosallowed}+{pxm}
intnum          {neg}?{digit}+
floatnum        {neg}?{digit}+{dot}{digit}+
comment         [#].*
lbrace          [{]
rbrace          [}]
comma           [,]
%%
[\n].*                              { strcpy(linebuf, yytext+1);
                                      lineno++;
                                      yyless(1);
                                      tokenpos = 0; }
[ \t]+                              { tokenpos += yyleng; }
{comment}                           /* nothing */
[Oo][Bb][Jj][Ee][Cc][Tt]            { tokenpos += yyleng;
                                      return (T_OBJECT); }
[Ss][Uu][Rr][Ff][Aa][Cc][Ee]        { tokenpos += yyleng;
                                      return (T_SURFACE); }
[Vv][Ee][Rr][Tt][Ee][Xx]            { tokenpos += yyleng;
                                      return (T_VERTEX); }
[Cc][Ee][Nn][Tt][Ee][Rr]            { tokenpos += yyleng;
                                      return (T_CENTER); }
[Ee][Yy][Ee]                        { tokenpos += yyleng;
                                      return (T_EYE); }
[Ll][Ii][Gg][Hh][Tt]                { tokenpos += yyleng;
                                      return (T_LIGHT); }
[Bb][Aa][Cc][Kk][Gg][Rr][Oo][Uu][Nn][Dd]  { tokenpos += yyleng;
                                            return (T_BACKGROUND); }
[Nn][Oo][Nn][Ee]                    { tokenpos += yyleng;
                                      return (T_NONE); }
[Ff][Aa][Dd][Ee]                    { tokenpos += yyleng;
                                      return (T_FADE); }
[Ss][Tt][Aa][Rr][Ss]                { tokenpos += yyleng;
                                      return (T_STARS); }
[Ss][Tt][Yy][Ll][Ee]                { tokenpos += yyleng;
                                      return (T_STYLE); }
[Cc][Oo][Ll][Oo][Rr]                { tokenpos += yyleng;
                                      return (T_COLOR); }
[Rr][Ee][Dd]                        { tokenpos += yyleng;
                                      return (T_RED); }
[Gg][Rr][Ee][Ee][Nn]                { tokenpos += yyleng;
                                      return (T_GREEN); }
[Bb][Ll][Uu][Ee]                    { tokenpos += yyleng;
                                      return (T_BLUE); }
[Gg][Rr][EeAa][Yy]                  { tokenpos += yyleng;
                                      return (T_GREY); }
[Ww][Hh][Ii][Tt][Ee]                { tokenpos += yyleng;
                                      return (T_WHITE); }
[Ss][Hh][Aa][Dd][Ee][Dd]            { tokenpos += yyleng;
                                      return (T_SHADED); }
[Tt][Ee][Xx][Tt][Uu][Rr][Ee][Dd]    { tokenpos += yyleng;
                                      return (T_TEXTURED); }
[Ww][Ii][Rr][Ee]                    { tokenpos += yyleng;
                                      return (T_WIRE); }
[Rr][Oo][Tt][Aa][Tt][Ee]            { tokenpos += yyleng;
                                      return (T_ROTATE); }
{floatnum}                          { tokenpos += yyleng;
                                      return (T_FLOAT); }
{intnum}                            { tokenpos += yyleng;
                                      return (T_INT); }
{giffile}                           { tokenpos += yyleng;
                                      return (T_GIFFILE); }
{pxmfile}                           { tokenpos += yyleng;
                                      return (T_PXMFILE); }
{name}                              { tokenpos += yyleng;
                                      return (T_NAME); }
{lbrace}                            { tokenpos += yyleng;
                                      return (T_LBRACE); }
{rbrace}                            { tokenpos += yyleng;
                                      return (T_RBRACE); }
{comma}                             { tokenpos += yyleng;
                                      return (T_COMMA); }
 
[^,]               { Error("\"%s\" is illegal", yytext); }
%%
yyerror(char *msg)
{
  x_text_mode();
  if (strcmp(msg, "") != 0)
    printf("%s in line %d:\n%s\n%*s\n", msg, lineno, linebuf, tokenpos+1, "^");
}

