#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93";
#endif
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING (yyerrflag!=0)
#define YYPREFIX "yy"
#line 2 "parser.y"

#include <math.h>
#include <ctype.h>
#include <xlib.h>
#include "object.h"
#include "gfx.h"
 
int lineno = 1;
OBJECT *object;
SURFACE *surface;
WORLD *world;
extern char *yytext;
 
void Error(char *format, ...);
POINT *MakePoint(float, float, float, POINT *);
float strtofloat(char *);

#line 21 "parser.y"
typedef union {
  float fval;
  int ival;
  char sval[33];
} YYSTYPE;
#line 36 "y_tab.c"
#define T_OBJECT 257
#define T_VERTEX 258
#define T_CENTER 259
#define T_EYE 260
#define T_LIGHT 261
#define T_STYLE 262
#define T_COLOR 263
#define T_RED 264
#define T_GREEN 265
#define T_BLUE 266
#define T_GREY 267
#define T_WHITE 268
#define T_SHADED 269
#define T_TEXTURED 270
#define T_INT 271
#define T_FLOAT 272
#define T_NAME 273
#define T_LBRACE 274
#define T_RBRACE 275
#define T_SURFACE 276
#define T_ROTATE 277
#define T_GIFFILE 278
#define T_PXMFILE 279
#define T_COMMA 280
#define T_BACKGROUND 281
#define T_FADE 282
#define T_STARS 283
#define T_NONE 284
#define T_WIRE 285
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,    0,    7,    7,    8,    8,    8,    9,    9,   15,
   15,   15,    6,    6,    3,   11,   11,   17,   10,   16,
   16,   18,   18,   19,   19,   22,   20,   21,   21,   23,
   23,   26,   26,   27,   26,   26,    5,    5,    5,    5,
    5,    2,    2,    2,   24,   24,   25,   25,   12,   12,
   14,   14,    1,    1,    4,    4,   13,   13,
};
short yylen[] = {                                         2,
    5,    1,    8,    3,    8,    3,    0,    2,    0,    1,
    2,    2,    1,    0,    1,    2,    0,    0,    9,    1,
    0,    8,    3,    8,    3,    0,   10,    2,    0,    2,
    3,    2,    2,    0,    3,    3,    1,    1,    1,    1,
    1,    2,    1,    2,    8,    3,    2,    0,    1,    2,
    1,    2,    1,    1,    1,    1,    1,    1,
};
short yydefred[] = {                                      0,
    2,    0,    0,    0,    0,   49,    0,    0,    0,    4,
   50,   54,   53,    0,    0,    0,    0,    0,   58,   57,
    0,    6,    0,   15,    0,   10,    0,    8,   18,    0,
    0,    0,   56,   55,   12,   13,   11,    0,    0,    1,
    0,    0,   20,    0,   16,    0,    0,    0,    0,    0,
   51,    3,    0,    0,    0,   52,    5,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   26,    0,    0,    0,    0,    0,   28,   19,    0,    0,
    0,    0,    0,    0,    0,   22,    0,    0,    0,    0,
   34,    0,   30,    0,    0,   24,   31,   32,   37,   38,
   39,   40,   41,   33,    0,    0,    0,    0,    0,    0,
   43,   35,    0,   36,    0,    0,    0,   44,   42,    0,
    0,    0,    0,   47,   27,    0,    0,   45,
};
short yydgoto[] = {                                       3,
   14,  112,   27,   35,  104,   37,    4,    9,   18,   39,
   40,    7,   21,   52,   28,   44,   38,   55,   61,   72,
   73,   76,   85,  121,  122,   93,  105,
};
short yysindex[] = {                                   -200,
    0, -246,    0, -256,  -10,    0, -253, -197, -267,    0,
    0,    0,    0, -239,   -9, -253, -188, -226,    0,    0,
 -253,    0, -239,    0, -172,    0, -229,    0,    0, -226,
 -239, -253,    0,    0,    0,    0,    0, -237, -226,    0,
 -253, -239,    0, -193,    0, -245, -253,  -46, -174,   66,
    0,    0, -245, -192, -190,    0,    0,  -37, -253, -183,
 -175,    0, -239,  -25, -172, -237, -175, -253,    0, -239,
    0, -175, -245, -239, -172, -193,    0,    0, -253, -239,
 -160, -245, -172, -248, -155,    0, -245,   95, -172, -157,
    0, -150,    0, -181, -155,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -210, -172,  -11, -253, -155,  107,
    0,    0, -229,    0,    0, -239, -155,    0,    0, -253,
 -155, -245, -239,    0,    0, -253, -245,    0,
};
short yyrindex[] = {                                      0,
    0,    0,    0, -233,    0,    0,    0,    0, -139,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -138,    0,    0,  120,
    0,    0,    0,    0,    0,    0,    0, -176,  120,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -206,    0,    0,    0, -176, -243,    0, -209,    0,
    0, -243,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, -137,    0, -186,    0, -236,    0,    0,    0,
 -236,    0,    0,    0,    0,    0,    0,    0,
};
short yygindex[] = {                                      0,
  -14,    0,   17,  -49,    0,   10,    0,    0,    0,  106,
   86,   -2,  -19,  -44,    0,   60,    0,    0,    0,   67,
   55,    0,    0,  -60,    8,    0,    0,
};
#define YYTABLESIZE 129
short yytable[] = {                                      10,
   22,   23,   12,   32,    8,   16,   31,   88,   57,    5,
   50,   41,   29,   17,   89,   70,   19,   42,   13,   48,
   90,   91,   47,    7,   95,   80,   46,    6,   78,   51,
   29,   29,   53,   87,  109,   43,   92,   86,   48,   98,
   20,   49,   96,   68,   63,  110,   50,    7,  117,   50,
   75,   59,   36,   74,   79,    1,  114,   65,   15,    2,
   83,   50,   48,   58,   82,   50,   25,   24,  111,   46,
   23,   46,   64,   81,  107,   56,    6,  125,   11,   21,
    6,    6,  128,   33,   54,   50,   60,   62,   46,   24,
    6,  108,    6,  116,   25,   26,  120,   21,   34,   69,
   66,   84,   94,  126,   97,  123,   99,  100,  101,  102,
  103,  127,  106,  115,   11,   11,  118,    9,   14,   17,
   14,  113,  119,   30,   45,   71,   77,   67,  124,
};
short yycheck[] = {                                      10,
   10,   16,  256,   23,  261,    8,   21,  256,   53,  256,
  256,   31,  256,  281,  263,   65,  256,   32,  272,  256,
  269,  270,   42,  257,   85,   75,   41,  274,   73,  275,
  257,  275,   47,   83,   95,  273,  285,   82,  275,   89,
  280,   44,   87,   63,   59,  256,  256,  281,  109,  256,
   70,   54,  282,   68,   74,  256,  106,   60,  256,  260,
   80,  271,  256,  256,   79,  272,  276,  278,  279,  256,
  277,  258,  256,   76,  256,   10,  274,  122,  125,  256,
  274,  274,  127,  256,  259,  272,  277,  125,  275,  278,
  274,   94,  274,  108,  283,  284,  116,  274,  271,  125,
  276,  262,  258,  123,   10,  120,  264,  265,  266,  267,
  268,  126,  263,  125,  125,  125,   10,  257,  257,    0,
  258,  105,  113,   18,   39,   66,   72,   61,  121,
};
#define YYFINAL 3
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 285
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,"'\\n'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'}'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"T_OBJECT","T_VERTEX",
"T_CENTER","T_EYE","T_LIGHT","T_STYLE","T_COLOR","T_RED","T_GREEN","T_BLUE",
"T_GREY","T_WHITE","T_SHADED","T_TEXTURED","T_INT","T_FLOAT","T_NAME",
"T_LBRACE","T_RBRACE","T_SURFACE","T_ROTATE","T_GIFFILE","T_PXMFILE","T_COMMA",
"T_BACKGROUND","T_FADE","T_STARS","T_NONE","T_WIRE",
};
char *yyrule[] = {
"$accept : world",
"world : eye light background object object_list",
"world : error",
"eye : T_EYE lbrace fp comma fp comma fp rbrace",
"eye : T_EYE error '\\n'",
"light : T_LIGHT lbrace fp comma fp comma fp rbrace",
"light : T_LIGHT error '\\n'",
"light :",
"background : T_BACKGROUND backs",
"background :",
"backs : T_NONE",
"backs : giffile fade",
"backs : T_STARS integer",
"fade : T_FADE",
"fade :",
"giffile : T_GIFFILE",
"object_list : object object_list",
"object_list :",
"$$1 :",
"object : T_OBJECT $$1 name lbrace center rotations surface surface_list rbrace",
"name : T_NAME",
"name :",
"center : T_CENTER lbrace fp comma fp comma fp rbrace",
"center : T_CENTER error '}'",
"rotations : T_ROTATE lbrace integer comma integer comma integer rbrace",
"rotations : T_ROTATE error '}'",
"$$2 :",
"surface : T_SURFACE name $$2 lbrace style vertex vertex vertex vertex_list rbrace",
"surface_list : surface surface_list",
"surface_list :",
"style : T_STYLE styles",
"style : T_STYLE error '\\n'",
"styles : T_COLOR integer",
"styles : T_SHADED hues",
"$$3 :",
"styles : T_TEXTURED $$3 filename",
"styles : T_WIRE T_COLOR integer",
"hues : T_RED",
"hues : T_GREEN",
"hues : T_BLUE",
"hues : T_GREY",
"hues : T_WHITE",
"filename : giffile fade",
"filename : T_PXMFILE",
"filename : error '\\n'",
"vertex : T_VERTEX lbrace fp comma fp comma fp rbrace",
"vertex : T_VERTEX error '}'",
"vertex_list : vertex vertex_list",
"vertex_list :",
"lbrace : T_LBRACE",
"lbrace : error '}'",
"rbrace : T_RBRACE",
"rbrace : error '\\n'",
"fp : T_FLOAT",
"fp : error",
"integer : T_INT",
"integer : error",
"comma : T_COMMA",
"comma : error",
};
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE
#line 147 "parser.y"
#include <stdarg.h>
 
void Error(char *format, ...)
{
  va_list arg;
 
  GraphicsDone();
  printf("ERROR: ");
  va_start(arg, format);
  vprintf(format, arg);
  va_end(arg);
  printf(" on line %d.\n", lineno);
}

#include "lexyy.c"

#line 289 "y_tab.c"
#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 2:
#line 43 "parser.y"
{ printf("Nothing to parse!\n"); YYABORT; }
break;
case 3:
#line 46 "parser.y"
{ MoveEye(MakePoint(yyvsp[-5].fval, yyvsp[-3].fval, yyvsp[-1].fval, NULL)); }
break;
case 4:
#line 47 "parser.y"
{ Error("eye coordinate definition is incorrect"); }
break;
case 5:
#line 50 "parser.y"
{ MoveLight(MakePoint(yyvsp[-5].fval, yyvsp[-3].fval, yyvsp[-1].fval, NULL)); }
break;
case 6:
#line 51 "parser.y"
{ Error("light coordinate definition is incorrect"); }
break;
case 9:
#line 56 "parser.y"
{ LoadBackground(NULL, 0); SeedStars(0); }
break;
case 10:
#line 59 "parser.y"
{ LoadBackground(NULL, 0); SeedStars(0); }
break;
case 11:
#line 60 "parser.y"
{ LoadBackground(yyvsp[-1].sval, yyvsp[0].ival); SeedStars(0); }
break;
case 12:
#line 61 "parser.y"
{ LoadBackground(NULL, 0); SeedStars(yyvsp[0].ival); }
break;
case 13:
#line 64 "parser.y"
{ yyval.ival = 1; }
break;
case 14:
#line 65 "parser.y"
{ yyval.ival = 0; }
break;
case 15:
#line 68 "parser.y"
{ strcpy(yyval.sval, yytext); }
break;
case 18:
#line 75 "parser.y"
{ object = NewObject(world); }
break;
case 22:
#line 82 "parser.y"
{ MakePoint(yyvsp[-5].fval, yyvsp[-3].fval, yyvsp[-1].fval, &object->center); }
break;
case 23:
#line 83 "parser.y"
{ Error("bad or missing center definition"); }
break;
case 24:
#line 86 "parser.y"
{ object->xcdelta = yyvsp[-5].ival; object->ycdelta = yyvsp[-3].ival; object->zcdelta = yyvsp[-1].ival; }
break;
case 25:
#line 87 "parser.y"
{ Error("incorrect rotation definition"); }
break;
case 26:
#line 90 "parser.y"
{ surface = NewSurface(object); }
break;
case 31:
#line 98 "parser.y"
{ Error("incorrect style definition"); }
break;
case 32:
#line 101 "parser.y"
{ surface->style = SOLID; surface->color = yyvsp[0].ival; }
break;
case 33:
#line 102 "parser.y"
{ surface->style = yyvsp[0].ival; ShadedPaletteInit(); }
break;
case 34:
#line 103 "parser.y"
{ surface->style = TEXTURED; }
break;
case 36:
#line 104 "parser.y"
{ surface->style = WIREFRAME; surface->color = yyvsp[0].ival; }
break;
case 37:
#line 107 "parser.y"
{ yyval.ival = SHADED_RED; }
break;
case 38:
#line 108 "parser.y"
{ yyval.ival = SHADED_GREEN; }
break;
case 39:
#line 109 "parser.y"
{ yyval.ival = SHADED_BLUE; }
break;
case 40:
#line 110 "parser.y"
{ yyval.ival = SHADED_GREY; }
break;
case 41:
#line 111 "parser.y"
{ yyval.ival = SHADED_GREY; }
break;
case 42:
#line 114 "parser.y"
{ LoadGifBitmap(surface, yyvsp[-1].sval, yyvsp[0].ival); }
break;
case 43:
#line 115 "parser.y"
{ LoadPxmBitmap(surface, yytext); }
break;
case 44:
#line 116 "parser.y"
{ Error("filename expected"); }
break;
case 45:
#line 119 "parser.y"
{ AddPoint(surface, MakePoint(yyvsp[-5].fval, yyvsp[-3].fval, yyvsp[-1].fval, NULL)); }
break;
case 46:
#line 120 "parser.y"
{ Error("incorrect vertex definition"); }
break;
case 50:
#line 128 "parser.y"
{ Error("{ expected"); }
break;
case 52:
#line 132 "parser.y"
{ Error("} expected"); }
break;
case 53:
#line 135 "parser.y"
{ yyval.fval = strtofloat(yytext); }
break;
case 54:
#line 136 "parser.y"
{ Error("float expected"); }
break;
case 55:
#line 139 "parser.y"
{ yyval.ival = atoi(yytext); }
break;
case 56:
#line 140 "parser.y"
{ Error("integer expected"); }
break;
case 58:
#line 144 "parser.y"
{ Error(", expected"); }
break;
#line 590 "y_tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
