
This stuff is 32-bit C code for gcc. It's not plug&play in any way, but it
may help you get the idea. What do you need image mapping for, and on what
OS (or extender) are you programming?

Please don't distribute it further. It's pretty useless as it is...


/* Real-time 3D rendering for Linux */
/* Copyright 1993 Harm Hanemaayer */
/* bitmapped.c	Bitmapped polygon scanning */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <values.h>
#include <limits.h>
#include "config.h"
#include "macros.h"
#include "def.h"
#include "objects.h"
#include "calc.h"
#include "draw.h"
#include "bitmapped.h"
#include "bitmappeddef.h"
#include "grdriver.h"

#ifndef MININT
#define MININT INT_MIN
#endif


/* Bitmapped shading */

/* The clipping routines are exactly like the conventional clipping */
/* routines, the bitmap position is interpolated like the screen coordinate. */

static inline void bitmappedclipleft( BitmappedGrPolygon *p1, BitmappedGrPolygon *p2 ) {
/* clip against left window boundary */
	GrVertex *vertex = p1->v;
	GrVertex *vertex2 = p2->v;
	int *bx = p1->bx;
	int *bx2 = p2->bx;
	int *by = p1->by;
	int *by2 = p2->by;
	#ifdef BITMAPPED_PERSPECTIVE
	int *z = p1->z;
	int *z2 = p2->z;
	#endif
	int vcount2;
	int i;
	vcount2 = 0;
	for (i = 1; i < p1->nu_vertices; i++) {
		int c1 = (vertex[i - 1].x >= CLIPX1);	/* 1 if p1 inside */
		int c2 = (vertex[i].x >= CLIPX1);	/* 1 if p2 inside */
		if (!c1 && !c2)
			continue;	/* completely outside */
		vertex2[vcount2].x = CLIPX1;
		if (c2) {
			if (!c1) {
	 			vertex2[vcount2].y =
					vertex[i - 1].y
					+ muldiv64(CLIPX1 - vertex[i - 1].x,
					vertex[i].y - vertex[i - 1].y,
					vertex[i].x - vertex[i - 1].x);
				#ifdef BITMAPPED_PERSPECTIVE
				z2[vcount2] =
					z[i - 1]
					+ muldiv64(CLIPX1 - vertex[i - 1].x,
					z[i] - z[i - 1],
					vertex[i].x - vertex[i - 1].x);
				#endif
				bx2[vcount2] =
					bx[i - 1]
					+ muldiv64(CLIPX1 - vertex[i - 1].x,
					bx[i] - bx[i - 1],
					vertex[i].x - vertex[i - 1].x);
				by2[vcount2++] =
					by[i - 1]
					+ muldiv64(CLIPX1 - vertex[i - 1].x,
					by[i] - by[i - 1],
					vertex[i].x - vertex[i - 1].x);
			}
			bx2[vcount2] = bx[i];
			by2[vcount2] = by[i];
			#ifdef BITMAPPED_PERSPECTIVE
			z2[vcount2] = z[i];
			#endif
			vertex2[vcount2++] = vertex[i];	/* add p2 */
		}
		else {	/* c1 */
			vertex2[vcount2].y =
				vertex[i].y
				+ muldiv64(CLIPX1 - vertex[i].x,
				vertex[i - 1].y - vertex[i].y,
				vertex[i - 1].x - vertex[i].x);
			#ifdef BITMAPPED_PERSPECTIVE
			z2[vcount2] =
				z[i]
				+ muldiv64(CLIPX1 - vertex[i].x,
				z[i - 1] - z[i],
				vertex[i - 1].x - vertex[i].x);
			#endif
			bx2[vcount2] =
				bx[i]
				+ muldiv64(CLIPX1 - vertex[i].x,
				bx[i - 1] - bx[i],
				vertex[i - 1].x - vertex[i].x);
			by2[vcount2++] =
				by[i]
				+ muldiv64(CLIPX1 - vertex[i].x,
				by[i - 1] - by[i],
				vertex[i - 1].x - vertex[i].x);
		}
	}
	bx2[vcount2] = bx2[0];
	by2[vcount2] = by2[0];
	#ifdef BITMAPPED_PERSPECTIVE
	z2[vcount2] = z2[0];
	#endif
	vertex2[vcount2++] = vertex2[0];	/* close ring */
	p2->nu_vertices = vcount2;
}

static inline void bitmappedclipright( BitmappedGrPolygon *p1, BitmappedGrPolygon *p2 ) {
/* clip against right window boundary */
	GrVertex *vertex = p1->v;
	GrVertex *vertex2 = p2->v;
	int *bx = p1->bx;
	int *bx2 = p2->bx;
	int *by = p1->by;
	int *by2 = p2->by;
	#ifdef BITMAPPED_PERSPECTIVE
	int *z = p1->z;
	int *z2 = p2->z;
	#endif
	int vcount = p1->nu_vertices;
	int vcount2;
	int i;
	vcount2 = 0;
	for (i = 1; i < vcount; i++) {
		int c1 = (vertex[i - 1].x <= CLIPX2);		/* inside? */
		int c2 = (vertex[i].x <= CLIPX2);
		if (!c1 && !c2)	/* completely outside */
			continue;
		vertex2[vcount2].x = CLIPX2;
		if (c2) {
			if (!c1) {
				vertex2[vcount2].y = 
					vertex[i - 1].y
					+ muldiv64(CLIPX2 - vertex[i - 1].x,
					vertex[i].y - vertex[i - 1].y,
					vertex[i].x - vertex[i - 1].x);
				#ifdef BITMAPPED_PERSPECTIVE
				z2[vcount2] = 
					z[i - 1]
					+ muldiv64(CLIPX2 - vertex[i - 1].x,
					z[i] - z[i - 1],
					vertex[i].x - vertex[i - 1].x);
				#endif
				bx2[vcount2] = 
					bx[i - 1]
					+ muldiv64(CLIPX2 - vertex[i - 1].x,
					bx[i] - bx[i - 1],
					vertex[i].x - vertex[i - 1].x);
				by2[vcount2++] =
					by[i - 1]
					+ muldiv64(CLIPX2 - vertex[i - 1].x,
					by[i] - by[i - 1],
					vertex[i].x - vertex[i - 1].x);
			}
			bx2[vcount2] = bx[i];
			by2[vcount2] = by[i];
			#ifdef BITMAPPED_PERSPECTIVE
			z2[vcount2] = z[i];
			#endif
			vertex2[vcount2++] = vertex[i];	/* add p2 */
		}
		else {	/* c1 */
			vertex2[vcount2].y = 
				vertex[i].y
				+ muldiv64(CLIPX2 - vertex[i].x,
				vertex[i - 1].y - vertex[i].y, 
				vertex[i - 1].x - vertex[i].x);
			#ifdef BITMAPPED_PERSPECTIVE
			z2[vcount2] = 
				z[i]
				+ muldiv64(CLIPX2 - vertex[i].x,
				z[i - 1] - z[i], 
				vertex[i - 1].x - vertex[i].x);
			#endif
			bx2[vcount2] = 
				bx[i]
				+ muldiv64(CLIPX2 - vertex[i].x,
				bx[i - 1] - bx[i], 
				vertex[i - 1].x - vertex[i].x);
			by2[vcount2++] = 
				by[i]
				+ muldiv64(CLIPX2 - vertex[i].x,
				by[i - 1] - by[i], 
				vertex[i - 1].x - vertex[i].x);
		}
	}
	bx2[vcount2] = bx2[0];
	by2[vcount2] = by2[0];
	#ifdef BITMAPPED_PERSPECTIVE
	z2[vcount2] = z2[0];
	#endif
	vertex2[vcount2++] = vertex2[0];	/* close ring */
	p2->nu_vertices = vcount2;
}

static inline void bitmappedcliptop( BitmappedGrPolygon *p1, BitmappedGrPolygon *p2 ) {
/* clip against top window boundary */
	GrVertex *vertex = p1->v;
	GrVertex *vertex2 = p2->v;
	int *bx = p1->bx;
	int *bx2 = p2->bx;
	int *by = p1->by;
	int *by2 = p2->by;
	#ifdef BITMAPPED_PERSPECTIVE
	int *z = p1->z;
	int *z2 = p2->z;
	#endif
	int vcount = p1->nu_vertices;
	int vcount2;
	int i;
	vcount2 = 0;
	for (i = 1; i < vcount; i++) {
		int c1 = (vertex[i - 1].y >= CLIPY1);	/* 1 if p1 inside */
		int c2 = (vertex[i].y >= CLIPY1);	/* 1 if p2 inside */
		if (!c1 && !c2)
			continue;	/* completely outside */
		vertex2[vcount2].y = CLIPY1;
		if (c2) {
			if (!c1) {
	 			vertex2[vcount2].x = 
					vertex[i - 1].x
					+ muldiv64(CLIPY1 - vertex[i - 1].y,
					vertex[i].x - vertex[i - 1].x,
					vertex[i].y - vertex[i - 1].y);
				#ifdef BITMAPPED_PERSPECTIVE
	 			z2[vcount2] = 
					z[i - 1]
					+ muldiv64(CLIPY1 - vertex[i - 1].y,
					z[i] - z[i - 1],
					vertex[i].y - vertex[i - 1].y);
				#endif
	 			bx2[vcount2] = 
					bx[i - 1]
					+ muldiv64(CLIPY1 - vertex[i - 1].y,
					bx[i] - bx[i - 1],
					vertex[i].y - vertex[i - 1].y);
	 			by2[vcount2++] = 
					by[i - 1]
					+ muldiv64(CLIPY1 - vertex[i - 1].y,
					by[i] - by[i - 1],
					vertex[i].y - vertex[i - 1].y);
			}
			bx2[vcount2] = bx[i];
			by2[vcount2] = by[i];
			#ifdef BITMAPPED_PERSPECTIVE
			z2[vcount2] = z[i];
			#endif
			vertex2[vcount2++] = vertex[i];	/* add p2 */
		}
		else {	/* c1 */
			vertex2[vcount2].x =
				vertex[i].x
				+ muldiv64(CLIPY1 - vertex[i].y,
				vertex[i - 1].x - vertex[i].x,
				vertex[i - 1].y - vertex[i].y);
			#ifdef BITMAPPED_PERSPECTIVE
			z2[vcount2] =
				z[i]
				+ muldiv64(CLIPY1 - vertex[i].y,
				z[i - 1] - z[i],
				vertex[i - 1].y - vertex[i].y);
			#endif
			bx2[vcount2] =
				bx[i]
				+ muldiv64(CLIPY1 - vertex[i].y,
				bx[i - 1] - bx[i],
				vertex[i - 1].y - vertex[i].y);
			by2[vcount2++] =
				by[i]
				+ muldiv64(CLIPY1 - vertex[i].y,
				by[i - 1] - by[i],
				vertex[i - 1].y - vertex[i].y);
		}
	}
	bx2[vcount2] = bx2[0];
	by2[vcount2] = by2[0];
	#ifdef BITMAPPED_PERSPECTIVE
	z2[vcount2] = z2[0];
	#endif
	vertex2[vcount2++] = vertex2[0];	/* close ring */
	p2->nu_vertices = vcount2;
}

static inline void bitmappedclipbottom( BitmappedGrPolygon *p1, BitmappedGrPolygon *p2 ) {
/* clip against bottom window boundary */
	GrVertex *vertex = p1->v;
	GrVertex *vertex2 = p2->v;
	int *bx = p1->bx;
	int *bx2 = p2->bx;
	int *by = p1->by;
	int *by2 = p2->by;
	#ifdef BITMAPPED_PERSPECTIVE
	int *z = p1->z;
	int *z2 = p2->z;
	#endif
	int vcount = p1->nu_vertices;
	int vcount2;
	int i;
	vcount2 = 0;
	for (i = 1; i < vcount; i++) {
		int c1 = (vertex[i - 1].y <= CLIPY2);		/* inside? */
		int c2 = (vertex[i].y <= CLIPY2);
		if (!c1 && !c2)	/* completely outside */
			continue;
		vertex2[vcount2].y = CLIPY2;
		if (c2) {
			if (!c1) {
				vertex2[vcount2].x = 
					vertex[i - 1].x
					+ muldiv64(CLIPY2 - vertex[i - 1].y,
					vertex[i].x - vertex[i - 1].x,
					vertex[i].y - vertex[i - 1].y);
				#ifdef BITMAPPED_PERSPECTIVE
				z2[vcount2] = 
					z[i - 1]
					+ muldiv64(CLIPY2 - vertex[i - 1].y,
					z[i] - z[i - 1],
					vertex[i].y - vertex[i - 1].y);
				#endif
				bx2[vcount2] = 
					bx[i - 1]
					+ muldiv64(CLIPY2 - vertex[i - 1].y,
					bx[i] - bx[i - 1],
					vertex[i].y - vertex[i - 1].y);
				by2[vcount2++] = 
					by[i - 1]
					+ muldiv64(CLIPY2 - vertex[i - 1].y,
					by[i] - by[i - 1],
					vertex[i].y - vertex[i - 1].y);
			}
			bx2[vcount2] = bx[i];
			by2[vcount2] = by[i];
			#ifdef BITMAPPED_PERSPECTIVE
			z2[vcount2] = z[i];
			#endif
			vertex2[vcount2++] = vertex[i];	/* add p2 */
		}
		else {	/* c1 */
			vertex2[vcount2].x = 
				vertex[i].x
				+ muldiv64(CLIPY2 - vertex[i].y,
				vertex[i - 1].x - vertex[i].x,
				vertex[i - 1].y - vertex[i].y);
			#ifdef BITMAPPED_PERSPECTIVE
			z2[vcount2] = 
				z[i]
				+ muldiv64(CLIPY2 - vertex[i].y,
				z[i - 1] - z[i],
				vertex[i - 1].y - vertex[i].y);
			#endif
			bx2[vcount2] = 
				bx[i]
				+ muldiv64(CLIPY2 - vertex[i].y,
				bx[i - 1] - bx[i],
				vertex[i - 1].y - vertex[i].y);
			by2[vcount2++] = 
				by[i]
				+ muldiv64(CLIPY2 - vertex[i].y,
				by[i - 1] - by[i],
				vertex[i - 1].y - vertex[i].y);
		}
	}
	bx2[vcount2] = bx2[0];
	by2[vcount2] = by2[0];
	#ifdef BITMAPPED_PERSPECTIVE
	z2[vcount2] = z2[0];
	#endif
	vertex2[vcount2++] = vertex2[0];	/* close ring */
	p2->nu_vertices = vcount2;
}


static void bitmappedclipconvexpolygon( BitmappedGrPolygon *p,
BitmappedGrPolygon *clipped ) {
/* Clip polygon, clipped->v must be large enough */
/* Note: last vertex of p must be the same as first vertex */
	BitmappedGrPolygon ptemp;
	ptemp.v = (GrVertex *)alloca(sizeof(GrVertex) * (p->nu_vertices + 4));
	ptemp.bx = (int *)alloca(sizeof(int) * (p->nu_vertices + 4));
	ptemp.by = (int *)alloca(sizeof(int) * (p->nu_vertices + 4));
	ptemp.z = (int *)alloca(sizeof(int) * (p->nu_vertices + 4));
	bitmappedclipleft(p, &ptemp);
	bitmappedclipright(&ptemp, clipped);
	bitmappedcliptop(clipped, &ptemp);
	bitmappedclipbottom(&ptemp, clipped);
}

#ifdef BITMAPPED_PERSPECTIVE
/* perspective interpolation over y (correct bitmapped groundplanes) */
static void bitmappedperspectivescan( int bx1, int by1, int z1, int y1,
int bx2, int by2, int z2, int y2, int *bxt, int *byt ) {
	int dy = y2 - y1;	// > 0
	int zfactor = muldiv64(z2, 65536, z1);	// abs(z2 / z1) < 32768
	// 16 bit fraction for zfactor/zdivfactor
	int zdivfactor = (zfactor + 65536) * dy;
//	printf("zfactor: %d  zdivfactor: %d\n", zfactor, zdivfactor);
	// 8 bit fraction for bxadd */
	// initial bxadd
	int bxadd = muldiv64((bx2 - bx1) * 2, 1 << (16 + 8), zdivfactor);
	int byadd = muldiv64((by2 - by1) * 2, 1 << (16 + 8), zdivfactor);
	// target bxadd
	int temp = 65536;
	int bxadd1 = muldiv64(zfactor, bxadd, temp);
	int byadd1 = muldiv64(zfactor, byadd, temp);
//	printf("bxadd0: %d  bxadd1: %d  byadd0: %d  byadd1: %d\n",
//		bxadd, bxadd1, byadd, byadd1);
	int bxaddadd = (bxadd1 - bxadd) / dy;
	int byaddadd = (byadd1 - byadd) / dy;
//	printf("bxaddadd: %d  byaddadd: %d\n", bxaddadd, byaddadd);
	/* 8 bit fraction for bx */
	int bx = bx1 << 8;
	int by = by1 << 8;
	for (int y = 0; y < dy; y++) {
		bxt[y] = bx >> 8;
		byt[y] = by >> 8;
//		printf("by = %d  ", by >> 16);
		bx += bxadd;
		by += byadd;
		bxadd += bxaddadd;
		byadd += byaddadd;
	}
//	printf("\n");
}
#endif

static void bitmapscanpolygon( BitmappedGrPolygon *p, int ymin, int ymax,
int *xmin, int *xmax, int *bx_xmin, int *bx_xmax, int *by_xmin, int *by_xmax,
int *t, int *bxt, int *byt ) {
	/* determine minimum and maximum x for each scanline */

	/* initialize minx and maxx arrays */
	__memsetlong(xmin, MAXINT, ymax - ymin);
	__memsetlong(xmax, MININT, ymax - ymin);

	GrVertex *v1, *v2;
	v1 = p->v;
	int j;
	for (j = 0; j < p->nu_vertices - 1; j++, v1 = v2) {
		int y;
		int x1, y1, x2, y2, bx1, by1, bx2, by2, z1, z2;
		v2 = &v1[1];
		y1 = v1->y;
		y2 = v2->y;
		if (y1 == y2)
			continue;	/* discard horizontal edges */
		x1 = v1->x;
		x2 = v2->x;
		bx1 = p->bx[j];		/* position in bitmap */
		by1 = p->by[j];
		bx2 = p->bx[j + 1];
		by2 = p->by[j + 1];
		#ifdef BITMAPPED_PERSPECTIVE
		z1 = p->z[j];		/* distance */
		z2 = p->z[j + 1];
		#endif
		if (y1 > y2) {
			swap(x1, x2);
			swap(y1, y2);
			swap(bx1, bx2);
			swap(by1, by2);
			#ifdef BITMAPPED_PERSPECTIVE
			swap(z1, z2);
			#endif
		}

		/* interpolate x */
		makextable(x1, y1, x2, y2, t);

		#ifdef BITMAPPED_PERSPECTIVE
		bitmappedperspectivescan(bx1, by1, z1, y1, bx2, by2, z2, y2,
			bxt, byt);
		#else
		/* interpolate bitmap x */
		makextable(bx1, y1, bx2, y2, bxt);
		/* interpolate bitmap y */
		makextable(by1, y1, by2, y2, byt);
		#endif

		for (y = y1; y < y2; y++) {	/* discard y2 */
			if (t[y - y1] < xmin[y - ymin]) {
				xmin[y - ymin] = t[y - y1];
				bx_xmin[y - ymin] = bxt[y - y1];
				by_xmin[y - ymin] = byt[y - y1];
			}
			if (t[y - y1] > xmax[y - ymin]) {
				xmax[y - ymin] = t[y - y1];
				bx_xmax[y - ymin] = bxt[y - y1];
				by_xmax[y - ymin] = byt[y - y1];
			}
		}
	}
}


void drawbitmappedconvexpolygon( BitmappedGrPolygon *bgrp ) {
	BitmappedGrPolygon clipped;
	int *xmin, *xmax;
	int *bx_xmin, *bx_xmax;
	int *by_xmin, *by_xmax;
	int *t;
	int *bxt, *byt;
	int ymin, ymax;

	int clipcheckcode = clipcheck(bgrp);
	if (clipcheckcode == 2)		/* completely outside */
		return;
	if (clipcheckcode == 1) {	/* partially outside */
		clipped.v = (GrVertex *)
			alloca(sizeof(GrVertex) * (bgrp->nu_vertices + 4));
		clipped.bx = (int *)
			alloca(sizeof(int) * (bgrp->nu_vertices + 4));
		clipped.by = (int *)
			alloca(sizeof(int) * (bgrp->nu_vertices + 4));
		#ifdef BITMAPPED_PERSPECTIVE
		clipped.z = (int *)
			alloca(sizeof(int) * (bgrp->nu_vertices + 4));
		#endif
		clipped.bitmapwidth =  bgrp->bitmapwidth;
		clipped.bitmapheight = bgrp->bitmapheight;
		clipped.bitmapdata = bgrp->bitmapdata;
		bitmappedclipconvexpolygon(bgrp, &clipped);
		bgrp = &clipped;
	}

	determineyrange(bgrp, ymin, ymax); /* ymin, ymax passed by reference */
	if (ymin == ymax)
		return;

	xmin = (int *)alloca(sizeof(int) * (ymax - ymin));
	xmax = (int *)alloca(sizeof(int) * (ymax - ymin));
	bx_xmin = (int *)alloca(sizeof(int) * (ymax - ymin));
	bx_xmax = (int *)alloca(sizeof(int) * (ymax - ymin));
	by_xmin = (int *)alloca(sizeof(int) * (ymax - ymin));
	by_xmax = (int *)alloca(sizeof(int) * (ymax - ymin));
	t = (int *)alloca(sizeof(int) * (ymax - ymin));
	bxt = (int *)alloca(sizeof(int) * (ymax - ymin));
	byt = (int *)alloca(sizeof(int) * (ymax - ymin));

	bitmapscanpolygon(bgrp, ymin, ymax, xmin, xmax, bx_xmin, bx_xmax,
		by_xmin, by_xmax, t, bxt, byt);

	grdriver_bitmappedhlinelist(ymin, ymax - 1, xmin, xmax, bx_xmin,
		bx_xmax, by_xmin, by_xmax, bgrp->bitmapwidth,
		bgrp->bitmapheight, bgrp->bitmapdata );
}


Here's some code that implements the scanline interpolation and drawing:


/* Generic one byte-per-pixel linear framebuffer driver */


#include <stdlib.h>
#include "macros.h"

#include "grconfig.h"
#include "grdriver.h"
#include "bitmappeddef.h"


static unsigned char *BACKSCREEN;
static int *ZBUFFER;
static int WIDTH;
static int HEIGHT;
static int LINEWIDTH;


/* Local inline functions */

static inline void __setpixel( int x, int y, int c ) {
	BACKSCREEN[y * LINEWIDTH + x] = c;
}

static inline void __hline( int x1, int y, int x2, int c ) {
	if (x1 <= x2)
		__memset(BACKSCREEN + y * LINEWIDTH + x1, c, x2 - x1 + 1);
}

void backscreen8_setpixel( int x, int y, int c ) {
	__setpixel(x, y, c);
}

void backscreen8_hline( int x1, int y, int x2, int c ) {
	__hline(x1, y, x2, c);
}

void backscreen8_vline( int x, int y1, int y2, int c ) {
}

void backscreen8_line( int x1, int y1, int x2, int y2, int c ) {
}

void backscreen8_hlinelist( int ymin, int ymax, int *xmin,
int *xmax, int c ) {
	int i;
	/* Note that rightmost pixel is discarded, unlike in hline. */
	c = c / 8;
	for (i = 0; i <= ymax - ymin; i++)
		__hline(xmin[i], i + ymin, xmax[i] - 1, c);
}

void backscreen8_zbufferhlinelist( int ymin, int ymax, int *xmin,
int *xmax, int *zxmin, int *zxmax, int c ) {
/* Assumes z smaller than 1 << 23 */
	int y;
	for (y = 0; y <= ymax - ymin; y++) {
		#ifdef HANDLEBIGZ
		long long z = zxmin[y];
		long long zadd = (long long)(zxmax[y] - z) * 256
			/ (xmax[y] - xmin[y]);
		#else
		int z = zxmin[y];
		int zadd = (zxmax[y] - z) * 256 / (xmax[y] - xmin[y]);
		#endif
		z <<= 8;
		unsigned char *vp = LINEWIDTH * (y + ymin) + xmin[y] + 
			BACKSCREEN;
		int *zp = (LINEWIDTH * (y + ymin) + xmin[y]) * 4 +
			ZBUFFER;

		int count = xmax[y] - xmin[y];

		while (count > 0) {
			if ((z >> 8) > *zp)
				*vp = c;
			vp++;
			zp++;
			z += zadd;
			count--;
		}
	}
}

void backscreen8_gouraudhlinelist( int ymin, int ymax, int *xmin,
int *xmax, int *ixmin, int *ixmax ) {
	int y;
	for (y = 0; y <= ymax - ymin; y++) {
		if (xmin[y] >= xmax[y])
			continue;
		if (ixmin[y] == ixmax[y]) {
			/* No gradations in this span. */
			__hline(xmin[y], y + ymin, xmax[y] - 1,
				ixmin[y] / 8);
			continue;
		}

		/* Initial intensity at the left. */ 
		int i = ixmin[y];		/* 0 - 2047 */
		/* Calculate scaled step value. */
		int iadd = (ixmax[y] - i) * 256	/ (xmax[y] - xmin[y]);
		/* Scale color by 256; lower 8 bits is fraction. */
		i <<= 8;

		/* Calculate offset into the framebuffer. */
		unsigned char *vp = LINEWIDTH * (y + ymin) + xmin[y] + 
			(unsigned char *)BACKSCREEN;

		/* Number of pixels to fill; rightmost is discarded. */
		int count = xmax[y] - xmin[y];

		/* Use unrolled loop for chunks of 16 pixels. */
		while (count >= 16) {
			/* Color 16 pixels. */
			#ifdef __i386__
			__asm__(
				"movl %0,%%eax\n\t"
				"shrl $11,%%eax\n\t"
				"movb %%al,(%1)\n\t"
				"addl %4,%0\n\t"
				"movl %0,%%eax\n\t"
				"shrl $11,%%eax\n\t"
				"movb %%al,1(%1)\n\t"
				"addl %4,%0\n\t"
				"movl %0,%%eax\n\t"
				"shrl $11,%%eax\n\t"
				"movb %%al,2(%1)\n\t"
				"addl %4,%0\n\t"
				"movl %0,%%eax\n\t"
				"shrl $11,%%eax\n\t"
				"movb %%al,3(%1)\n\t"
				"addl %4,%0\n\t"
				"movl %0,%%eax\n\t"
				"shrl $11,%%eax\n\t"
				"movb %%al,4(%1)\n\t"
				"addl %4,%0\n\t"
				"movl %0,%%eax\n\t"
				"shrl $11,%%eax\n\t"
				"movb %%al,5(%1)\n\t"
				"addl %4,%0\n\t"
				"movl %0,%%eax\n\t"
				"shrl $11,%%eax\n\t"
				"movb %%al,6(%1)\n\t"
				"addl %4,%0\n\t"
				"movl %0,%%eax\n\t"
				"shrl $11,%%eax\n\t"
				"movb %%al,7(%1)\n\t"
				"addl %4,%0\n\t"
				"movl %0,%%eax\n\t"
				"shrl $11,%%eax\n\t"
				"movb %%al,8(%1)\n\t"
				"addl %4,%0\n\t"
				"movl %0,%%eax\n\t"
				"shrl $11,%%eax\n\t"
				"movb %%al,9(%1)\n\t"
				"addl %4,%0\n\t"
				"movl %0,%%eax\n\t"
				"shrl $11,%%eax\n\t"
				"movb %%al,10(%1)\n\t"
				"addl %4,%0\n\t"
				"movl %0,%%eax\n\t"
				"shrl $11,%%eax\n\t"
				"movb %%al,11(%1)\n\t"
				"addl %4,%0\n\t"
				"movl %0,%%eax\n\t"
				"shrl $11,%%eax\n\t"
				"movb %%al,12(%1)\n\t"
				"addl %4,%0\n\t"
				"movl %0,%%eax\n\t"
				"shrl $11,%%eax\n\t"
				"movb %%al,13(%1)\n\t"
				"addl %4,%0\n\t"
				"movl %0,%%eax\n\t"
				"shrl $11,%%eax\n\t"
				"movb %%al,14(%1)\n\t"
				"addl %4,%0\n\t"
				"movl %0,%%eax\n\t"
				"shrl $11,%%eax\n\t"
				"movb %%al,15(%1)\n\t"
				"addl %4,%0\n\t"
				: "=r" (i), "=r" (vp)
				: "r" (i), "r" (vp), "g" (iadd)
				: "ax"
			);
			vp += 16;
			#else
			*vp++ = i >> 11; i += iadd; *vp++ = i >> 11; i += iadd;
			*vp++ = i >> 11; i += iadd; *vp++ = i >> 11; i += iadd;
			*vp++ = i >> 11; i += iadd; *vp++ = i >> 11; i += iadd;
			*vp++ = i >> 11; i += iadd; *vp++ = i >> 11; i += iadd;
			*vp++ = i >> 11; i += iadd; *vp++ = i >> 11; i += iadd;
			*vp++ = i >> 11; i += iadd; *vp++ = i >> 11; i += iadd;
			*vp++ = i >> 11; i += iadd; *vp++ = i >> 11; i += iadd;
			*vp++ = i >> 11; i += iadd; *vp++ = i >> 11; i += iadd;
			#endif
			count -= 16;
		}
		/* Draw remaining pixels. */
		switch (count) {
			/* Fall through chain. */
			case 15 : *vp++ = i >> 11; i += iadd;
			case 14 : *vp++ = i >> 11; i += iadd;
			case 13 : *vp++ = i >> 11; i += iadd;
			case 12 : *vp++ = i >> 11; i += iadd;
			case 11 : *vp++ = i >> 11; i += iadd;
			case 10 : *vp++ = i >> 11; i += iadd;
			case 9 : *vp++ = i >> 11; i += iadd;
			case 8 : *vp++ = i >> 11; i += iadd;
			case 7 : *vp++ = i >> 11; i += iadd;
			case 6 : *vp++ = i >> 11; i += iadd;
			case 5 : *vp++ = i >> 11; i += iadd;
			case 4 : *vp++ = i >> 11; i += iadd;
			case 3 : *vp++ = i >> 11; i += iadd;
			case 2 : *vp++ = i >> 11; i += iadd;
			case 1 : *vp++ = i >> 11; i += iadd;
			case 0 : break;
		}
	}
}


void backscreen8_simplegouraudhlinelist( int ymin, int ymax, 
int *xmin, int *xmax, int *ixmin, int *ixmax ) {
/* simplified Gouraud shading: horizontal lines in a single color */
	int y;
	for (y = 0; y <= ymax - ymin; y++)
		/* Use average of left and right intensity. */
		__hline(xmin[y], y + ymin, xmax[y] - 1,
			(ixmin[y] + ixmax[y]) / 16);
}

void backscreen8_bitmappedhlinelist( int ymin, int ymax, int *xmin,
int *xmax, int *bx_xmin, int *bx_xmax, int *by_xmin, int *by_xmax,
int bitmapwidth, int bitmapheight, char *bitmapdata ) {
	/* Bitmap coordinates are already scaled BITMAPPEDSCALESHIFT bits. */
	int y;
	for (y = 0; y <= ymax - ymin; y++) {
		if (xmin[y] >= xmax[y])
			continue;
		int bx, by;
		/* Bitmap coordinates at the left end of the scanline. */
		bx = bx_xmin[y];
		by = by_xmin[y];
		/* Calculate offset into framebuffer. */
		unsigned char *vp = LINEWIDTH * (y + ymin) + xmin[y] + 
			(unsigned char *)BACKSCREEN;
		/* Number of pixels (rightmost is discarded). */
		int count = xmax[y] - xmin[y];
		/* Step size for bitmap coordinates. */
		int bxadd = (bx_xmax[y] - bx) * 256 / count;
		int byadd = (by_xmax[y] - by) * 256 / count;
		/* Scale up by another 8 bits for better precision. */
		bx <<= 8;
		by <<= 8;
		/* Special cases to avoid multiplication in loop. */
		switch (bitmapwidth) {
		case 32 :
			while (count > 0) {
				*vp = *(bitmapdata +
					(by >> (8 + BITMAPPEDSCALESHIFT)) * 32
					+ (bx >> (8 + BITMAPPEDSCALESHIFT)));
				vp++;
				bx += bxadd;
				by += byadd;
				count--;
			}
			break;
		case 64 :
			while (count > 0) {
				*vp = *(bitmapdata +
					(by >> (8 + BITMAPPEDSCALESHIFT)) * 64
					+ (bx >> (8 + BITMAPPEDSCALESHIFT)));
				vp++;
				bx += bxadd;
				by += byadd;
				count--;
			}
			break;
		default :
			while (count > 0) {
				*vp = *(bitmapdata + bitmapwidth *
					(by >> (8 + BITMAPPEDSCALESHIFT))
					+ (bx >> (8 + BITMAPPEDSCALESHIFT)));
				vp++;
				bx += bxadd;
				by += byadd;
				count--;
			}
			break;
		}
	}
}

void backscreen8_clearscreen( int c ) {
	memset(BACKSCREEN, c, LINEWIDTH * HEIGHT);
}

void backscreen8_init( int w, int h, void *b ) {
	WIDTH = w;
	LINEWIDTH = w;
	HEIGHT = h;
	BACKSCREEN = b;
	#ifdef USE_ZBUFFER
	ZBUFFER = malloc(w * h * 4);
	memsetlong(ZBUFFER, MAXINT, w * h);
	#endif
}

 