; 
;  This is a 3D animation demo, written by Yann/Iguana
;  Credits to:
;    * Jare/Iguana for his nonjump Bresenham,
;    * Tran/Renaissance for letting us see the sources of the Amnesia demo
;    * Tran/Renaissance for his great PMODE 2.4
;
; 

        JUMPS           ; Automatic out-of-range conditional jump fixing
.MODEL  SMALL

; 
; Macros to profile the 3D engine
; 
SetBorder2      MACRO Color
                push    ax
                push    dx
                cli                     ; So that the flip-flop isn't
                                        ; uninit-ed by some IRQ...
                mov     dx,3DAh
                in      al,dx           ; Init the flip-flop for the
                                        ; attribute controller
                mov     dx,3C0h         ; Attribute controller port
                mov     al,31h          ; Overscan reg, don't switch ray off
                out     dx,al           ; Write Register #
                mov     al,Color
                out     dx,al           ; Write Border Color
                sti
                pop     dx
                pop     ax
                ENDM

SetBorder       MACRO Color             ; To profile
                ;SetBorder2 Color
                ENDM

.STACK 1000h    ; 4K stack
.DATA?
ClippedFacetsBuffer DW 4096 DUP (?)
SortedFacetsList DW 4096 DUP (?)
; For each facet: DW offset of the next linkedlist item
;                 DD distance of the middle point ^ 2
;                 DW offset of the facet in the DS (in the Clip. buffer)
SortedFacetsHeadPtr DW ?
NextFreeSlotPtr DW ?

LinesBuffer1 DW 3072 DUP (?)
LinesBuffer2 DW 3072 DUP (?)
LinesBufferPtr DW ?
NumBufferedLines1 DW ?
NumBufferedLines2 DW ?
NumBufferedLinesPtr DW ?

.DATA
EVEN
QuitPrg DW 0
VGASeg  DW 0A400h
; Drawing mode:
WIREFRAME   = 0
SOLID       = 1
Mode    DW SOLID

; ------------------------ Description of the environment ---------------------
INCLUDE ..\road.inc
; ^^^^^^^^^^^^^^^^^^^^^^^^ Description of the environment ^^^^^^^^^^^^^^^^^^^^^

; ------------------------ Description of the movement ------------------------
Movement LABEL WORD

INCLUDE ..\roadm.inc

 DW -1

; ^^^^^^^^^^^^^^^^^^^^^^^^ Description of the movement ^^^^^^^^^^^^^^^^^^^^^^^^

CameraPts LABEL WORD
        DW NUM_POINTS DUP (?,?,?)

NumFacets DW ?

;SinTable created by Jon Beltran de Heredia
;Sines are in 8.8 fixedpoint, from 0 degrees to 360+90 degrees (in order to
; calculate the cosines with the same table)
SinTbl  LABEL   WORD
DW 0,4,9,13,18,22,27,31,36,40,44,49,53,58,62
DW 66,71,75,79,83,88,92,96,100,104,108,112,116,120,124
DW 128,132,136,139,143,147,150,154,158,161,165,168,171,175,178
DW 181,184,187,190,193,196,199,202,204,207,210,212,215,217,219
DW 222,224,226,228,230,232,234,236,237,239,241,242,243,245,246
DW 247,248,249,250,251,252,253,254,254,255,255,255,256,256,256
DW 256,256,256,256,255,255,255,254,254,253,252,251,250,249,248
DW 247,246,245,243,242,241,239,237,236,234,232,230,228,226,224
DW 222,219,217,215,212,210,207,204,202,199,196,193,190,187,184
DW 181,178,175,171,168,165,161,158,154,150,147,143,139,136,132
DW 128,124,120,116,112,108,104,100,96,92,88,83,79,75,71
DW 66,62,58,53,49,44,40,36,31,27,22,18,13,9,4
DW 0,-4,-9,-13,-18,-22,-27,-31,-36,-40,-44,-49,-53,-58,-62
DW -66,-71,-75,-79,-83,-88,-92,-96,-100,-104,-108,-112,-116,-120,-124
DW -128,-132,-136,-139,-143,-147,-150,-154,-158,-161,-165,-168,-171,-175,-178
DW -181,-184,-187,-190,-193,-196,-199,-202,-204,-207,-210,-212,-215,-217,-219
DW -222,-224,-226,-228,-230,-232,-234,-236,-237,-239,-241,-242,-243,-245,-246
DW -247,-248,-249,-250,-251,-252,-253,-254,-254,-255,-255,-255,-256,-256,-256
DW -256,-256,-256,-256,-255,-255,-255,-254,-254,-253,-252,-251,-250,-249,-248
DW -247,-246,-245,-243,-242,-241,-239,-237,-236,-234,-232,-230,-228,-226,-224
DW -222,-219,-217,-215,-212,-210,-207,-204,-202,-199,-196,-193,-190,-187,-184
DW -181,-178,-175,-171,-168,-165,-161,-158,-154,-150,-147,-143,-139,-136,-132
DW -128,-124,-120,-116,-112,-108,-104,-100,-96,-92,-88,-83,-79,-75,-71
DW -66,-62,-58,-53,-49,-44,-40,-36,-31,-27,-22,-18,-13,-9,-4
DW 0,4,9,13,18,22,27,31,36,40,44,49,53,58,62
DW 66,71,75,79,83,88,92,96,100,104,108,112,116,120,124
DW 128,132,136,139,143,147,150,154,158,161,165,168,171,175,178
DW 181,184,187,190,193,196,199,202,204,207,210,212,215,217,219
DW 222,224,226,228,230,232,234,236,237,239,241,242,243,245,246
DW 247,248,249,250,251,252,253,254,254,255,255,255,256,256,256,256


ByeMsg  DB 'Greetings to everyone in FidoNet.R34 PROASM_E & R34.DEMOS chats'
        DB 0Dh,0Ah
        DB 'Good bye!', 0Dh, 0Ah
        DB 'Coded by Yann/Iguana', 0Dh, 0Ah
        DB '$'

EVEN
;*****
; Distance: near z clipping plane
ZN DW ?
;*****
; Angle: field of view (in degrees)
FOV DW ?
;*****
; Distance: from the eye to the projection plane (calc as 100/sin(FOV/2))
Dist DW ?
;*****
; Vector: eye coors
_ex DW ?
_ey DW ?
_ez DW ?
; Vector: look-at point coors
_ax DW ?
_ay DW ?
_az DW ?
; Vector: looking direction
_tx DW ?
_ty DW ?
_tz DW ?
; Vector length: |t|
_t DW ?
; Distance: lambda = sqrt(tx^2+ty^2)
lambda DW ?
; 3x3 Matrix: rotation matrix to put t along z axis
M11 DW ?
M12 DW ?
M13 DW ?
M21 DW ?
M22 DW ?
M23 DW ?
M31 DW ?
M32 DW ?
M33 DW ?

; 
;  Function to calc M matrix from _e and _a vectors
; 
.CODE
        EVEN
CalcM   PROC
        ; Assure there is no overflow
        mov     ax,[_ax]
        cmp     ax,[_ex]
        jne     CML0
        mov     ax,[_ay]
        cmp     ax,[_ey]
        jne     CML0
        add     ax,256
        mov     [_ay],ax
CML0:
        ; Calc _t = _a - _e
        mov     ax,[_ax]
        sub     ax,[_ex]
        mov     [_tx],ax
        mov     bx,[_ay]
        sub     bx,[_ey]
        mov     [_ty],bx
        mov     cx,[_az]
        sub     cx,[_ez]
        mov     [_tz],cx
        ; Calc lamdba and |t|
        imul    ax
        mov     di,dx
        mov     si,ax
        mov     ax,bx
        imul    bx
        add     si,ax
        adc     di,dx
        push    di
        push    si
        push    cx
        call    SqRoot
        mov     [lambda],ax
        pop     ax              ; Restore tz
        pop     si              ; Restore lambda
        pop     di              ; ^
        imul    ax
        add     si,ax
        adc     di,dx
        call    SqRoot
        mov     [_t],ax
        ; We got all the needed quantities, calc M1i
        mov     cx,[lambda]
        mov     ax,[_ty]
        cwd
        mov     dl,ah
        mov     ah,al
        xor     al,al
        idiv    cx
        mov     [M11],ax
        mov     ax,[_tx]
        neg     ax
        cwd
        mov     dl,ah
        mov     ah,al
        xor     al,al
        idiv    cx
        mov     [M12],ax
        mov     [M13],0
        ; Now we calc M2i
        mov     bx,[_tz]
        mov     si,[lambda]
        mov     di,[_t]
        ; Calc M21 = tx*tz/(lambda*|t|)
        mov     ax,[_tx]
        imul    bx
        idiv    si
        cwd
        mov     dl,ah
        mov     ah,al
        xor     al,al
        idiv    di
        mov     [M21],ax
        ; Calc M22 = ty*tz/(lambda*|t|)
        mov     ax,[_ty]
        imul    bx
        idiv    si
        cwd
        mov     dl,ah
        mov     ah,al
        xor     al,al
        idiv    di
        mov     [M22],ax
        ; Calc M23 = -lambda/|t|
        mov     ax,si
        neg     ax
        cwd
        mov     dl,ah
        mov     ah,al
        xor     al,al
        idiv    di
        mov     [M23],ax
        ; Now we only have to calc M3i = _t normalized
        ; _tz is in BX and |t| is in DI
        mov     ax,[_tx]
        cwd
        mov     dl,ah
        mov     ah,al
        xor     al,al
        idiv    di
        mov     [M31],ax
        mov     ax,[_ty]
        cwd
        mov     dl,ah
        mov     ah,al
        xor     al,al
        idiv    di
        mov     [M32],ax
        mov     ax,bx           ; _tz
        cwd
        mov     dl,ah
        mov     ah,al
        xor     al,al
        idiv    di
        mov     [M33],ax
        ret
CalcM   ENDP

; 
;  Function to calc projection plane distance from the FOV [100/sin(FOV/2)]
; 
.CODE
        EVEN
CalcDist PROC
        mov     bx,[FOV]
        and     bx,0FFFEh
        mov     bx,SinTbl[bx]
        mov     ax,100*256              ; Height o'the screen (scaled)
        xor     dx,dx
        div     bx
        mov     [Dist],ax
        ret
CalcDist ENDP

; 
;  Function to calc 16 bit square root of 32 bit number in DISI, ret in AX
; 
.CODE
SqRoot  PROC
        xor     dx,dx
        mov     ax,1
        xor     bx,bx
        mov     cx,2
SRML:
        REPT 32
        sub     si,ax
        sbb     di,dx
        jc      SRExit
        add     ax,cx           ; Add 2
        adc     dx,bx           ; Add 0
        ENDM
        jmp     SRML
SRExit: clc
        rcr     dx,1
        rcr     ax,1
        ret
SqRoot  ENDP

; 
;  Function to calc the points from the camera's reference frame
; 
.CODE
        EVEN
WToCam  PROC
        mov     ax,ds
        mov     es,ax
        mov     si,OFFSET WorldPts
        mov     di,OFFSET CameraPts
        mov     cx,NUM_POINTS
WCML:   ; Calc X coor
        mov     ax,[si]                 ; Get X coor
        sub     ax,[_ex]
        cwd
        imul    [M11]
        mov     bx,ax
        mov     bp,dx
        mov     ax,[si+2]               ; Get Y coor
        sub     ax,[_ey]
        cwd
        imul    [M12]
        add     bx,ax
        adc     bp,dx
        mov     ax,[si+4]               ; Get Z coor
        sub     ax,[_ez]
        cwd
        imul    [M13]
        add     ax,bx
        adc     dx,bp
        mov     al,ah
        mov     ah,dl
        stosw                           ; Store X coor tran-ed and rot-ed
        ; Calc Y coor
        mov     ax,[si]                 ; Get X coor
        sub     ax,[_ex]
        cwd
        imul    [M21]
        mov     bx,ax
        mov     bp,dx
        mov     ax,[si+2]               ; Get Y coor
        sub     ax,[_ey]
        cwd
        imul    [M22]
        add     bx,ax
        adc     bp,dx
        mov     ax,[si+4]               ; Get Z coor
        sub     ax,[_ez]
        cwd
        imul    [M23]
        add     ax,bx
        adc     dx,bp
        mov     al,ah
        mov     ah,dl
        stosw                           ; Store Y coor tran-ed and rot-ed
        ; Calc Z coor
        mov     ax,[si]                 ; Get X coor
        sub     ax,[_ex]
        cwd
        imul    [M31]
        mov     bx,ax
        mov     bp,dx
        mov     ax,[si+2]               ; Get Y coor
        sub     ax,[_ey]
        cwd
        imul    [M32]
        add     bx,ax
        adc     bp,dx
        mov     ax,[si+4]               ; Get Z coor
        sub     ax,[_ez]
        cwd
        imul    [M33]
        add     ax,bx
        adc     dx,bp
        mov     al,ah
        mov     ah,dl
        stosw                           ; Store Z coor tran-ed and rot-ed
        add     si,6                    ; Next point
        dec     cx
        jz      WCExit                  ; Loop for all world points
        jmp     WCML
WCExit: ret
WToCam  ENDP

; 
;  Line drawing routine based upon code by Jare/Iguana (AKA Javier Arvalo)
; 
; Input: AH is the color, coors are in the following vars
.DATA
EVEN
MulBy80 LABEL WORD
I = 0
REPT 200
 DW I*80
 I = I + 1
ENDM
X1      DW ?
X2      DW ?
Y1      DW ?
Y2      DW ?
LVar1   DW 0            ; Increment for DI when there is overflow
        DW 0            ; Inc. for DI when there isn't overflow
AdjDown DW ?            ; Lookup Bresenham's algorithm
        DW 0            ; There isn't AdjDown w/o overflow
RotBits DB ?,?          ; Bits to rot when overflow
        DB ?,?          ; Bits to rot when not overflow

LineJmpTblPtr   DW ?

.CODE
        EVEN
DrawLine PROC
        mov     BYTE PTR cs:[ColorByte],ah
        mov     dx,3C4h
        mov     al,2
        out     dx,al                   ; Writes to map mask register
        push    es
        push    bp
        push    cx
        push    si
        push    di
        mov     ax,[Y1]
        mov     bx,[Y2]
        mov     cx,[X1]
        mov     si,[X2]
        cmp     ax,bx
        jc      SHORT LL1
        xchg   cx,si
        xchg   ax,bx
LL1:
        ; (cx,ax) = upper point (X1,Y1)
        ; (si,bx) = the other one (X2,Y2)
        sub     bx,ax                           ; deltaY
        mov     di,ax
        add     di,di
        mov     di,MulBy80[di]
        mov     dx,cx
        shr     dx,1
        shr     dx,1
        add     di,dx
        push    di
        mov     dx,cx
        and     cl,11b
        mov     al,00010001b
        rol     al,cl
        mov     BYTE PTR cs:[MaskByte],al
        sub     si,dx                           ; deltaX
        jc      SHORT LL1B
        jmp     LL2
LL1B:   ; arrives here if going from right to left
        neg     si
        mov     [LineJmpTblPtr],OFFSET LineJmpTbl1
        jmp     LL2B

LL2:    ; arrives here if going from left to right
        mov     [LineJmpTblPtr],OFFSET LineJmpTbl2
        jmp     LL2B

LL2B:   cmp     si,bx                           ; cmp deltaX,deltaY
        jnc     short LL3
        ; so deltaX < deltaY => non-overflow: dont rot; overflow: rot 1
        mov     [RotBits],1
        mov     [RotBits+2],0
        mov     dx,si
        xor     si,si                           ; Minor inc.
        mov     ax,80                           ; Major inc.
        jmp     SHORT LL4
  LL3:  ; so deltaX > deltaY => always rotate
        mov     [RotBits],1
        mov     [RotBits+2],1
        mov     dx,bx
        mov     bx,si
        mov     si,80                           ; Minor inc.
        xor     ax,ax                           ; Major inc.
  LL4:  mov     cx,bx
        or      cx,cx
        jnz     SHORT LL5
        add     sp,2                            ; Skip scr offset
        jmp     LExit
  LL5:  ; Now: AX == Major displacement (every pixel does this).
        ;      SI == Minor (only done when decimal part overflows).
        cmp     [LineJmpTblPtr],OFFSET LineJmpTbl1
        jnz     DontNeg
        neg     ax
        neg     si
DontNeg:
        add     si,ax
        mov     [LVar1],si
        mov     [LVar1+2],ax
        mov     si,dx
        ; Now:  ax == nothing
        ;       bx == major axis width
        ;       cx == major axis width
        ;       si == minor axis width
        ;       di == ScreenPtr
        ;       bp == nothing
        mov     bp,bx
        neg     bp                      ; bp == -major axis width (to round)
        mov     ax,bp                   ; ax == -major a.w.
        add     ax,ax                   ; ax *= 2
        mov     [AdjDown],ax
        add     si,si                   ; si == 2*minor a. w. (AdjUp)
        mov     es,[VGASeg]
        inc     cx                      ; To draw all the pixels
        mov     bx,cx
        mov     ax,cx
        add     ax,0Fh
        mov     cl,4
        shr     ax,cl
        mov     cx,ax                   ; cx = # of complete 16 pel groups + 1
        mov     ch,cl                   ; Counter will be CH
        and     bx,00001111b            ; cx = # of ungrouped pixels
        shl     bx,1
        mov     dx,3C5h                 ; Writes to map mask register
        pop     di
        mov     ah,0FFh
        ColorByte = $-1
        mov     al,0FFh
        MaskByte = $-1
        add     bx,[LineJmpTblPtr]
        jmp     WORD PTR [bx]

LineDumpPixel1 MACRO p
LineLoop1&p:
        out     dx,al                   ; Set map mask register
        mov     BYTE PTR es:[di],ah
        add     bp,si
        sbb     bx,bx
        add     bx,bx
        mov     cl,RotBits[bx+2]
        clc
        ror     al,cl
        sbb     di,LVar1[bx+2]
        add     bp,AdjDown[bx+2]
ENDM

LineDumpPixel2 MACRO p
LineLoop2&p:
        out     dx,al                   ; Set map mask register
        mov     BYTE PTR es:[di],ah
        add     bp,si
        sbb     bx,bx
        add     bx,bx
        mov     cl,RotBits[bx+2]
        clc
        rol     al,cl
        adc     di,LVar1[bx+2]
        add     bp,AdjDown[bx+2]
ENDM

LineLoop1:
        I = 0
        REPT 16
        LineDumpPixel1 %I
        I = I + 1
        ENDM
EndLineLoop1:
        dec     ch
        jz      LExit
        jmp     LineLoop1

LineLoop2:
        I = 0
        REPT 16
        LineDumpPixel2 %I
        I = I + 1
        ENDM
EndLineLoop2:
        dec     ch
        jz      SHORT LExit
        jmp     LineLoop2


LExit:  pop     di
        pop     si
        pop     cx
        pop     bp
        pop     es
        ret
DrawLine ENDP

.DATA
EVEN
LineJmpTbl1 LABEL WORD
LineDumpLabel1 MACRO p
        DW LineLoop1&p
ENDM
        DW LineLoop10
        I = 15
        REPT 15
         LineDumpLabel1 %I
         I = I - 1
        ENDM

LineJmpTbl2 LABEL WORD
LineDumpLabel2 MACRO p
        DW LineLoop2&p
ENDM
        DW LineLoop20
        I = 15
        REPT 15
         LineDumpLabel2 %I
         I = I - 1
        ENDM

; 
;  Function to erase all the lines of the previous frame
; 
.CODE
        EVEN
EraseBufferedLines PROC
        mov     si,[NumBufferedLinesPtr]
        mov     cx,[si]
        or      cx,cx
        jz      EBLExit
        mov     si,[LinesBufferPtr]
EBLML:  push    cx
        mov     ax,[si]
        mov     [X1],ax
        mov     ax,[si+2]
        mov     [Y1],ax
        mov     ax,[si+4]
        mov     [X2],ax
        mov     ax,[si+6]
        mov     [Y2],ax
        xor     ah,ah
        push    si
        call    DrawLine
        pop     si
        add     si,8
        pop     cx
        loop    EBLMl
        mov     si,[NumBufferedLinesPtr]
        mov     WORD PTR [si],0
EBLExit:
        ret
EraseBufferedLines ENDP

; 
;  Function to erase all the polygons of the previous frame
; 
.CODE
        EVEN
EraseBufferedPolys PROC
        xor     al,al                           ; Erase with black!
        mov     si,[LinesBufferPtr]
        call    DumpPBuf
        mov     di,[LinesBufferPtr]
        call    ClearPBuf
        ret

EraseBufferedPolys ENDP

; 
;  Function to draw the things in wireframe
; 
.DATA
EVEN
DWX DW ?
DWY DW ?
DWZ DW ?
DWClr   DB ?

.CODE
        EVEN
DrawWire PROC
        mov     si,[SortedFacetsHeadPtr]
        or      si,si
        jnz     DWML0
        jmp     DWExit
DWML0:  push    si
        mov     si,[si+6]               ; Get effective facet data ptr
        mov     cx,[si+6]               ; Get # of points
        dec     cx                      ; Loop for # of pts - 1
        mov     al,BYTE PTR [si+2]      ; Get color
        mov     [DWClr],al
        add     si,8                    ; Skip facet header
        mov     ax,[si]
        mov     [DWX],ax
        push    ax
        mov     ax,[si+2]
        mov     [DWY],ax
        push    ax
        mov     ax,[si+4]
        mov     [DWZ],ax
        push    ax
        add     si,6                    ; Skip 1st pt
DWML1:  mov     ax,[DWX]                ; Don't load again
        mov     [L3DX1],ax
        mov     ax,[DWY]
        mov     [L3DY1],ax
        mov     ax,[DWZ]
        mov     [L3DZ1],ax
        mov     ax,[si]
        mov     [L3DX2],ax
        mov     [DWX],ax
        mov     ax,[si+2]
        mov     [L3DY2],ax
        mov     [DWY],ax
        mov     ax,[si+4]
        mov     [L3DZ2],ax
        mov     [DWZ],ax
        mov     ah,[DWClr]
        push    si
        push    cx
        call    Draw3DLine
        pop     cx
        pop     si
        add     si,6                    ; Skip point
        loop    DWML1
        ; Now, we gotta draw the last line
        pop     [L3DZ2]
        pop     [L3DY2]
        pop     [L3DX2]
        mov     ax,[DWX]
        mov     [L3DX1],ax
        mov     ax,[DWY]
        mov     [L3DY1],ax
        mov     ax,[DWZ]
        mov     [L3DZ1],ax
        mov     ah,[DWClr]
        call    Draw3DLine
        pop     si                      ; Restore ptr to the linked list
        mov     si,[si]
        or      si,si
        jz      DWExit
        jmp     DWML0
DWExit: ret
DrawWire ENDP

; 
;  Function to draw the things solid!
; 
.DATA
        EVEN
DSOPBuf DW 200 DUP (?,?)
DSOX    DW ?
DSOY    DW ?
DSOZ    DW ?
DSOClr  DB ?

.CODE
        EVEN
DrawSolid PROC
        mov     si,[SortedFacetsHeadPtr]
        or      si,si
        jnz     DSOML0
        jmp     DSOExit
DSOML0: push    si
        mov     di,OFFSET DSOPBuf
        call    ClearPBuf
        pop     si
        push    si
        mov     si,[si+6]               ; Get effective facet data ptr
        mov     cx,[si+6]               ; Get # of points
        dec     cx                      ; Loop for # of pts - 1
        mov     al,BYTE PTR [si+2]      ; Get color
        mov     [DSOClr],al
        add     si,8                    ; Skip facet header
        mov     ax,[si]
        mov     [DSOX],ax
        push    ax
        mov     ax,[si+2]
        mov     [DSOY],ax
        push    ax
        mov     ax,[si+4]
        mov     [DSOZ],ax
        push    ax
        add     si,6                    ; Skip 1st pt
DSOML1: mov     ax,[DSOX]               ; Don't load again
        mov     [A3DX1],ax
        mov     ax,[DSOY]
        mov     [A3DY1],ax
        mov     ax,[DSOZ]
        mov     [A3DZ1],ax
        mov     ax,[si]
        mov     [A3DX2],ax
        mov     [DSOX],ax
        mov     ax,[si+2]
        mov     [A3DY2],ax
        mov     [DSOY],ax
        mov     ax,[si+4]
        mov     [A3DZ2],ax
        mov     [DSOZ],ax
        mov     di,OFFSET DSOPBuf
        push    si
        push    cx
        call    Add3DLine
        pop     cx
        pop     si
        add     si,6                    ; Skip point
        loop    DSOML1
        ; Now, we gotta draw the last line
        pop     [A3DZ2]
        pop     [A3DY2]
        pop     [A3DX2]
        mov     ax,[DSOX]
        mov     [A3DX1],ax
        mov     ax,[DSOY]
        mov     [A3DY1],ax
        mov     ax,[DSOZ]
        mov     [A3DZ1],ax
        mov     di,OFFSET DSOPBuf
        call    Add3DLine

        ; Now dump the polygon to screen
        mov     si,OFFSET DSOPBuf
        mov     al,[DSOClr]
        call    DumpPBuf

        ; Now buffer the polygon for latter erasing
        mov     si,OFFSET DSOPBuf
        mov     di,[LinesBufferPtr]
        call    AddPBuf

        ; Keep on with other polygons
        pop     si                      ; Restore ptr to the linked list
        mov     si,[si]
        or      si,si
        jz      DSOExit
        jmp     DSOML0
DSOExit: ret
DrawSolid ENDP

; 
;  Function to draw the 2D projection of a 3D line
; 
.DATA
        EVEN
L3DX1   DW ?
L3DY1   DW ?
L3DZ1   DW ?
L3DX2   DW ?
L3DY2   DW ?
L3DZ2   DW ?
D3DLColor   DB ?
.CODE
        EVEN
Draw3DLine PROC
        mov     [D3DLColor],ah
        mov     di,[L3DZ1]              ; Get Z coor
        mov     ax,[L3DX1]              ; Get X coor
        imul    [Dist]
        idiv    di                      ; X' = X * Dist / Z
        add     ax,160                  ; To center in screen
        mov     [X1],ax
        mov     ax,[L3DY1]              ; Get Y coor
        imul    [Dist]
        idiv    di                      ; Y' = Y * Dist / Z
        add     ax,100
        mov     [Y1],ax
        mov     di,[L3DZ2]              ; Get Z coor
        mov     ax,[L3DX2]              ; Get X coor
        imul    [Dist]
        idiv    di                      ; X' = X * Dist / Z
        add     ax,160                  ; To center in screen
        mov     [X2],ax
        mov     ax,[L3DY2]              ; Get Y coor
        imul    [Dist]
        idiv    di                      ; Y' = Y * Dist / Z
        add     ax,100
        mov     [Y2],ax
        ; Clip the line in (X1,Y1)-(X2,Y2)
        call    ClipLine
        jc      D3DLL0  ; Completely invisible
        ; Buffer the line for later erasing:
        mov     si,[NumBufferedLinesPtr]
        mov     si,[si]
        add     si,si
        add     si,si
        add     si,si                   ; 8 bytes per buf. line
        add     si,[LinesBufferPtr]
        mov     ax,[X1]
        mov     [si],ax
        mov     ax,[Y1]
        mov     [si+2],ax
        mov     ax,[X2]
        mov     [si+4],ax
        mov     ax,[Y2]
        mov     [si+6],ax
        mov     si,[NumBufferedLinesPtr]
        inc     WORD PTR [si]
        ; Draw the line without clipping:
        mov     ah,[D3DLColor]
        call    DrawLine
D3DLL0:
        ret
Draw3DLine ENDP

; 
;  Function to add the 2D projection of a 3D line to a polygon buffer
; 
; DI -> Polygon buffer
.DATA
        EVEN
A3DX1   DW ?
A3DY1   DW ?
A3DZ1   DW ?
A3DX2   DW ?
A3DY2   DW ?
A3DZ2   DW ?
A3DLPBuf DW ?

.CODE
        EVEN
Add3DLine PROC
        mov     [A3DLPBuf],di
        mov     di,[A3DZ1]              ; Get Z coor
        mov     ax,[A3DX1]              ; Get X coor
        imul    [Dist]
        idiv    di                      ; X' = X * Dist / Z
        add     ax,160                  ; To center in screen
        mov     [ALPBX1],ax
        mov     ax,[A3DY1]              ; Get Y coor
        imul    [Dist]
        idiv    di                      ; Y' = Y * Dist / Z
        add     ax,100
        mov     [ALPBY1],ax
        mov     di,[A3DZ2]              ; Get Z coor
        mov     ax,[A3DX2]              ; Get X coor
        imul    [Dist]
        idiv    di                      ; X' = X * Dist / Z
        add     ax,160                  ; To center in screen
        mov     [ALPBX2],ax
        mov     ax,[A3DY2]              ; Get Y coor
        imul    [Dist]
        idiv    di                      ; Y' = Y * Dist / Z
        add     ax,100
        mov     [ALPBY2],ax
        ; Clip the line in ALPB (X1,Y1)-(X2,Y2)
        call    ClipVLine
        jc      A3DLL0  ; Completely outside
        ; Add the line without further clipping:
        mov     di,[A3DLPBuf]
        call    AddLineToPBuf
A3DLL0:
        ret
Add3DLine ENDP

; 
;  Function to build new facets clipping against Z = ZN
; 
.DATA
EVEN
LastPoint       DW ?
VertCounter     DW ?

.CODE
        EVEN
BuildClip PROC
        mov     ax,ds
        mov     es,ax
        mov     bp,OFFSET ClippedFacetsBuffer
        mov     si,OFFSET Facets
        mov     [NumFacets],0
        mov     cx,NUM_FACETS

   ; Loops for all the facets in the scene

BCML0:  push    cx      ; Save facet counter
        mov     di,bp
        movsw              ; Copy facet type
        movsw              ; Copy facet data lo
        movsw              ; Copy facet data hi
        xor     ax,ax
        stosw   ; Initially 0 points in clipped facet
        lodsw   ; Get # of points before clipping
        mov     [VertCounter],ax
        mov     bx,ax
        add     bx,bx      ; # of bytes to the last point
        mov     bx,[si+bx-2]
        mov     [LastPoint],bx   ; Keep inx of the last point
        mov     ax,bx      ; \
        add     bx,bx      ; \
        add     bx,ax      ; \
        add     bx,bx      ; bx = 6 * inx
        mov     dx,[ZN]
        xor     cl,cl      ; The flag
        cmp     CameraPts[bx+4],dx  ; CMP Zlast,ZN
        jl      BCML1
        inc     cl

   ; Loops for all the vertices in the facet

BCML1:  mov    bx,[si]
        mov    ax,bx       ; \
        add    bx,bx       ; \
        add    bx,ax       ; \
        add    bx,bx       ; bx =  6 * inx
        add    bx,OFFSET CameraPts
        mov    ax,[bx+4]
        mov    dx,[ZN]
        xor    ch,ch
        cmp    ax,dx
        jl     BCL0
        inc    ch
  BCL0: xor    cl,ch
        jz     BCL1        ; If both on the same side, needn't clip
        push   cx
        push   si
        push   bp
        mov    si,[LastPoint]
        mov    cx,si       ; \
        add    si,si       ; \
        add    si,cx       ; \
        add    si,si       ; si = 6 * inx
        add    si,OFFSET CameraPts
        mov    cx,[ZN]
        sub    cx,ax
        jns    BCL2
        neg    cx
  BCL2: sub    ax,[si+4]
        jns    BCL3
        neg    ax
  BCL3: mov    bp,ax
        mov    ax,[si]     ; Get X1
        sub    ax,[bx]     ; AX = (X1-X0)
        imul   cx          ; AX = (ZN-Z0).(X1-X0)
        idiv   bp          ; AX = (ZN-Z0).(X1-X0)/(Z1-Z0)
        add    ax,[bx]     ; AX += X0
        stosw
        mov    ax,[si+2]   ; Get Y1
        sub    ax,[bx+2]   ; AX = (Y1-Y0)
        imul   cx          ; AX = (ZN-Z0).(Y1-Y0)
        idiv   bp          ; AX = (ZN-Z0).(Y1-Y0)/(Z1-Z0)
        add    ax,[bx+2]   ; AX += Y0
        stosw
        mov    ax,[ZN]
        stosw
        pop    bp
        pop    si
        pop    cx
        inc    WORD PTR ds:[bp+6]   ; One more point in clipped facet ptlist
  BCL1: mov    cl,ch
        or     cl,cl
        jz     BCL4
        mov    ax,[bx]
        stosw
        mov    ax,[bx+2]
        stosw
        mov    ax,[bx+4]
        stosw
        inc    WORD PTR ds:[bp+6]   ; 1 more point ...
  BCL4: lodsw
        mov    [LastPoint],ax
        dec    [VertCounter]
        jnz     BCML1
        cmp    WORD PTR ds:[bp+6],0
        je     BCL5
        mov    bp,di
        inc    [NumFacets]
  BCL5: pop    cx
        loop   BCML0

        ret

BuildClip ENDP

; 
;  Function to clear the screen (just 1st page)
; 
        EVEN
ClrScr  PROC
        mov     dx,3C4h
        mov     ax,0F02h                ; Map Mask register = 1111b
        out     dx,ax
        mov     es,[VGASeg]
        xor     di,di
        xor     ax,ax                   ; Fill with zeros
        mov     cx,8192d                ; Words in first page
        rep     stosw
        ret
ClrScr  ENDP

; 
;  Function to clip the line defined by (X1,Y1)-(X2,Y2) to the 320x200 rect
; 
; We use the familiar Cohen-Sutherland algorithm:
;
;    1001 | 1000 | 1010
;    ------------------
;    0001 | 0000 | 0010
;    ------------------
;    0101 | 0100 | 0110
;
.CODE
        EVEN
ClipLine PROC
        ; In CL and CH we calc the codes for P1 and P2
        mov     bx,[X1]
        mov     bp,[X2]
        mov     si,[Y1]
        mov     di,[Y2]
CLAgain:
        xor     cl,cl           ; Code for P1
        or      bx,bx
        jns     CL0
        or      cl,0001b
CL0:    cmp     bx,320
        jl      CL1
        or      cl,0010b
CL1:    or      si,si
        jns     CL2
        or      cl,1000b
CL2:    cmp     si,200
        jl      CL3
        or      cl,0100b
CL3:    xor     ch,ch           ; Code for P2
        or      bp,bp
        jns     CL4
        or      ch,0001b
CL4:    cmp     bp,320
        jl      CL5
        or      ch,0010b
CL5:    or      di,di
        jns     CL6
        or      ch,1000b
CL6:    cmp     di,200
        jl      CL7
        or      ch,0100b
CL7:
        ; Now, we have: CL=P1 code, CH=P2 code, BX=X1, BP=X2, SI=Y1, DI=Y2
        mov     al,cl
        or      al,ch
        jnz     CL8
        ; Both segments are inside the screen
        jmp     CLExit
CL8:    test    cl,ch
        jz      CL9
        ; Both segments are outside on the same side
        stc                     ; Don't draw
        ret
CL9:    xor     cl,ch
        cmp     si,di           ; Make sure Y1 < Y2
        jle     CL10
        xchg    si,di
        xchg    bx,bp
CL10:
        test    cl,1000b        ; Have to cut against Y=0 ?
        jz      CL11
        ; Cut against Y=0
        push    di
        sub     bx,bp
        mov     ax,bx
        imul    di
        sub     di,si
        idiv    di
        add     ax,bp           ; NewX1 = X2+(X1-X2)*Y2/(Y2-Y1)
        mov     bx,ax           ; NewX1 = ^^^^^^^^^^^^^^^^^^^^^
        xor     si,si           ; NewY1 = 0
        pop     di
        jmp     CLAgain
CL11:   test    cl,0100b
        jz      CL12
        ; Cut against Y=199
        push    si
        sub     si,199
        sub     di,199
        ; Cutting against 0
        sub     bp,bx
        mov     ax,bp
        imul    si
        sub     si,di
        idiv    si
        add     ax,bx           ; NewX2 = X1+(X2-X1)*Y1/(Y1-Y2)
        mov     bp,ax
        mov     di,199          ; NewY2 = 199
        pop     si              ; NewY1 = OldY1
        jmp     CLAgain
CL12:   cmp     bx,bp           ; Make sure X1 < X2
        jle     CL15
        xchg    si,di
        xchg    bx,bp
CL15:   test    cl,0001b        ; Have to cut against X=0 ?
        jz      CL13
        ; Cut against X=0
        push    bp
        sub     si,di
        mov     ax,si
        imul    bp
        sub     bp,bx
        idiv    bp
        add     ax,di           ; NewY1 = Y2+(Y1-Y2)*X2/(X2-X1)
        mov     si,ax           ; NewY1 = ^^^^^^^^^^^^^^^^^^^^^
        xor     bx,bx           ; NewX1 = 0
        pop     bp
        jmp     CLAgain
CL13:   test    cl,0010b
        jz      CLExit
        ; Cut against X=319
        push    bx
        sub     bx,319
        sub     bp,319
        ; Cutting against 0
        sub     di,si
        mov     ax,di
        imul    bx
        sub     bx,bp
        idiv    bx
        add     ax,si           ; NewY2 = Y1+(Y2-Y1)*X1/(X1-X2)
        mov     di,ax
        mov     bp,319          ; NewX2 = 319
        pop     bx              ; NewY1 = OldY1
        jmp     CLAgain
CLExit: ; We've passed all the clippings
        mov     [X1],bx
        mov     [X2],bp
        mov     [Y1],si
        mov     [Y2],di
        clc                     ; Visible
        ret
ClipLine ENDP

; 
;  Function to clip line defined by ALPB (X1,Y1)-(X2,Y2) to the INFx200 rect
; 
; We use a variation of the familiar Cohen-Sutherland algorithm:
;
;     10
;    ----
;     00
;    ----
;     01
;
.CODE
        EVEN
ClipVLine PROC
        ; In CL and CH we calc the codes for P1 and P2
        mov     bx,[ALPBX1]
        mov     bp,[ALPBX2]
        mov     si,[ALPBY1]
        mov     di,[ALPBY2]
CVLAgain:
        xor     cl,cl           ; Code for P1
        or      si,si
        jns     CVL2
        or      cl,10b
CVL2:   cmp     si,200
        jl      CVL3
        or      cl,01b
CVL3:   xor     ch,ch           ; Code for P2
        or      di,di
        jns     CVL6
        or      ch,10b
CVL6:   cmp     di,200
        jl      CVL7
        or      ch,01b
CVL7:
        ; Now, we have: CL=P1 code, CH=P2 code, BX=X1, BP=X2, SI=Y1, DI=Y2
        mov     al,cl
        or      al,ch
        jnz     CVL8
        ; Both segments are inside the rectangle
        jmp     CVLExit
CVL8:   test    cl,ch
        jz      CVL9
        ; Both segments are outside on the same side
        stc                     ; Don't draw
        ret
CVL9:   xor     cl,ch
        cmp     si,di           ; Make sure Y1 < Y2
        jle     CVL10
        xchg    si,di
        xchg    bx,bp
CVL10:
        test    cl,10b        ; Have to cut against Y=0 ?
        jz      CVL11
        ; Cut against Y=0
        push    di
        sub     bx,bp
        mov     ax,bx
        imul    di
        sub     di,si
        idiv    di
        add     ax,bp           ; NewX1 = X2+(X1-X2)*Y2/(Y2-Y1)
        mov     bx,ax           ; NewX1 = ^^^^^^^^^^^^^^^^^^^^^
        xor     si,si           ; NewY1 = 0
        pop     di
        jmp     CVLAgain
CVL11:  test    cl,01b
        jz      CVLExit
        ; Cut against Y=199
        push    si
        sub     si,199
        sub     di,199
        ; Cutting against 0
        sub     bp,bx
        mov     ax,bp
        imul    si
        sub     si,di
        idiv    si
        add     ax,bx           ; NewX2 = X1+(X2-X1)*Y1/(Y1-Y2)
        mov     bp,ax
        mov     di,199          ; NewY2 = 199
        pop     si              ; NewY1 = OldY1
        jmp     CVLAgain
CVLExit: ; We've passed all the clippings
        mov     [ALPBX1],bx
        mov     [ALPBX2],bp
        mov     [ALPBY1],si
        mov     [ALPBY2],di
        clc                     ; Visible
        ret
ClipVLine ENDP

; 
;  Function to sort the facets in back-to-front order for the painter's alg.
; 
.DATA
EVEN
Averages DW ?,?,?
CoorsCounter DW ?
ThisFacetPtr DW ?
NextFacetPtr DW ?

.CODE
        EVEN
SortByDist PROC
        mov     si,OFFSET ClippedFacetsBuffer
        mov     cx,[NumFacets]
        or      cx,cx
        jnz     SDL3
        mov     [SortedFacetsHeadPtr],0
        jmp     SDExit
SDL3:
        mov     [NextFreeSlotPtr],OFFSET SortedFacetsList
        mov     [SortedFacetsHeadPtr],0
SDML:   push    cx
        mov     cx,[si+6]               ; Get # of pts in the facet
        mov     [ThisFacetPtr],si
        add     si,8                    ; To point to the coors
        mov     [CoorsCounter],6
SDL0:   push    si
        push    cx                      ; Keep # of points
        xor     dx,dx
        xor     ax,ax
SDL1:   mov     bx,[si]
        or      bx,bx
        jns     SDL4
        neg     bx
        sub     ax,bx
        sbb     dx,0
        add     si,6
        loop    SDL1
        jmp     SDL5
SDL4:   add     ax,bx
        adc     dx,0
        add     si,6
        loop    SDL1
SDL5:   sub     si,4
        mov     [NextFacetPtr],si
        pop     cx                      ; Restore # of points
        pop     si
        add     si,2
        idiv    cx                      ; Calc average
        mov     bx,[CoorsCounter]
        neg     bx
        add     bx,6
        mov     Averages[bx],ax
        sub     [CoorsCounter],2
        jnz     SDL0
        mov     ax,[Averages]           ; Get average X coor
        imul    ax
        mov     di,dx
        mov     cx,ax
        mov     ax,[Averages+2]         ; Get average Y coor
        imul    ax
        add     cx,ax
        adc     di,dx
        mov     ax,[Averages+4]         ; Get average Z coor
        imul    ax
        add     cx,ax
        adc     di,dx
        ; Now we have x^2+y^2+z^2 in DICX, insert into the sorted list
        mov     bx,[NextFreeSlotPtr]
        mov     [bx+2],cx
        mov     [bx+4],di
        mov     ax,[ThisFacetPtr]
        mov     [bx+6],ax
        ; Do the loop to insert
        mov     bx,OFFSET SortedFacetsHeadPtr
SDL2:   mov     si,[bx]                 ; Get address of next facet item
        or      si,si
        jz      SDDoInsert
        cmp     di,[si+4]               ; CMP ThisHiDist,ThatHiDist
        jg      SDDoInsert
        jl      SDGotoNext
        cmp     cx,[si+2]
        jge     SDDoInsert
SDGotoNext:
        mov     bx,si
        jmp     SDL2
SDDoInsert:
        ; Here, bx points to the Next ptr to alter, [bx] is the Next
        ;  field to put in our Next field
        mov     si,[NextFreeSlotPtr]
        mov     ax,[bx]
        mov     [si],ax                 ; Set our Next field to insert
        mov     [bx],si                 ; Alter the Next field
        add     si,8
        mov     [NextFreeSlotPtr],si    ; Update NextFreeSlot
        ; Continue the loop
        mov     si,[NextFacetPtr]
        pop     cx                      ; Restore # of facets
        dec     cx
        jz      SDExit
        jmp     SDML
SDExit:
        ret
SortByDist ENDP

; 
;  Function to sequence the animation
; 
TAGSIZE = 2 + 2*14      ; Tag id plus 14 words
.DATA
NextTag DW OFFSET Movement
DSFramesLeft DW 0
DSStart DW 6 DUP(?)     ; Starting _ex,_ey,_ez,_ax,_ay,_az
DSEnd   DW 6 DUP(?)     ; Ending    "
DSCrnt  DW 6 DUP(?)     ; Current value
DSIntA  DW 6 DUP(?)     ; Integer advance (done always)
DSFracA DW 6 DUP(?)     ; Fractional advance (only when carry)
DSFrac  DW 6 DUP(?)     ; Current fractional part
DSAdjU  DW 6 DUP(?)     ; Adjust fractional part
DSAdjD  DW 6 DUP(?)     ; Only when carry, substract this

.CODE
        EVEN
DoSeq   PROC
        mov     ax,[DSFramesLeft]
        or      ax,ax
        jz      DSInitTag
        jmp     DSNrmSeq
DSInitTag:
        ; So we have to setup the Bres data for the new sequence tag
        mov     si,[NextTag]
        add     [NextTag],TAGSIZE
        mov     ax,[si]
        inc     ax
        jnz     DSL0
        mov     [QuitPrg],1
        ret
DSL0:   ; So it's definitely a brand new animation tag
        mov     ax,ds
        mov     es,ax
        inc     si
        inc     si
        mov     di,OFFSET DSStart
        mov     cx,12
        rep movsw               ; Get starting and ending coordinates
        lodsw                   ; Get the FOV
        mov     [FOV],ax
        lodsw                   ; Get the # of frames for this tag
        mov     [DSFramesLeft],ax
        cmp     ax,1
        jne     DSL4
        ; Needn't do a Bres 'cos it's just one frame
        mov     si,OFFSET DSStart
        mov     di,OFFSET DSCrnt
        mov     cx,6
        rep movsw
        jmp     DSTransfer
DSL4:   mov     bp,ax           ; Keep in BP the # of frames, during the MLoop
        mov     si,10           ; Start calculating from the last of the 6
DSML0:  mov     bx,DSStart[si]
        mov     DSCrnt[si],bx
        mov     ax,DSEnd[si]
        sub     ax,bx           ; AX is the total delta
        mov     cx,1
        jns     DSL2
        neg     cx
DSL2:   mov     DSFracA[si],cx
        cwd
        idiv    bp              ; Divide by the # of frames
        mov     DSIntA[si],ax   ; Integral advance
        or      dx,dx
        jns     DSL3
        neg     dx
DSL3:   add     dx,dx           ; DX = 2 * dQuant
        mov     DSAdjU[si],dx
        mov     ax,bp
        neg     ax
        mov     DSFrac[si],ax
        mov     ax,bp
        add     ax,ax
        mov     DSAdjD[si],ax
        sub     si,1
        jc      DSTransfer
        dec     si
        jmp     DSML0

DSNrmSeq:                       ; Advance the Bresenhams
        mov     si,10
DSML1:  mov     ax,DSCrnt[si]
        mov     bx,DSFrac[si]
        add     ax,DSIntA[si]
        add     bx,DSAdjU[si]
        jnc     DSL1
        sub     bx,DSAdjD[si]
        add     ax,DSFracA[si]
DSL1:   mov     DSCrnt[si],ax
        mov     DSFrac[si],bx
        sub     si,1
        jc      DSTransfer
        dec     si
        jmp     DSML1

DSTransfer:                     ; Transfer to _e and _a
        mov     si,OFFSET DSCrnt
        lodsw
        mov     [_ex],ax
        lodsw
        mov     [_ey],ax
        lodsw
        mov     [_ez],ax
        lodsw
        mov     [_ax],ax
        lodsw
        mov     [_ay],ax
        lodsw
        mov     [_az],ax

        dec     [DSFramesLeft]
        ret
DoSeq   ENDP

; 
;  Function to clear a polygon buffer 
; 
; IN: DI -> Polygon buffer
.CODE
        EVEN
ClearPBuf PROC
        mov     ax,ds
        mov     es,ax
        mov     [di],7FFFh              ; Maximum X coor (32767)
        mov     [di+2],8000h            ; Minimum X coor (-32768)
        mov     si,di
        add     di,4
        mov     cx,199*2
        rep     movsw
        ret
ClearPBuf ENDP

; 
;  Function to add one polygon buffer to another
; 
; IN: SI -> Source polygon buffer (won't be changed)
;     DI -> Dest. polygon buffer (will be changed)
.CODE
        EVEN
AddPBuf PROC
        mov     ax,ds
        mov     es,ax
        mov     cx,200
APBML:  mov     ax,[si]                 ; Left X coor
        cmp     ax,[di]
        jg      APBL0
        mov     [di],ax
APBL0:  mov     ax,[si+2]
        cmp     ax,[di+2]
        jl      APBL1
        mov     [di+2],ax
APBL1:  add     si,4
        add     di,4
        loop    SHORT APBML
        ret
AddPBuf ENDP

; 
;  Function to dump a polygon buffer 
; 
; IN: SI -> Polygon buffer
;     AL :  Color
.DATA
DPBClr  DB ?
DPBLeft DB 0Fh,0Eh,0Ch,08h
DPBRight DB 00h,01h,03,07h

.CODE
        EVEN
DumpPBuf PROC
        mov     [DPBClr],al             ; Store color for latter use
        mov     ax,[VGASeg]
        mov     es,ax
        ; Init parameters for the 200 scans loop
        xor     di,di
        mov     cx,200
DPBML:  push    cx
        push    di
        push    si
        mov     bx,[si]
        cmp     bx,319
        jg      DPBL1                   ; Don't draw, completely out-right
        mov     cx,[si+2]
        cmp     cx,0
        jl      DPBL1                   ; Don't draw, completely out-left
        cmp     bx,0
        jge     DPBL2
        xor     bx,bx
        mov     [si],bx
DPBL2:  cmp     cx,319
        jle     DPBL3
        mov     cx,319
        mov     [si+2],cx
DPBL3:  ; Choose: Only one | Left & Right | Left & Middle & Right
        shr     bx,1
        shr     bx,1
        shr     cx,1
        shr     cx,1
        sub     cx,bx
        jz      DPBL5                   ; Draw: both points in same 4pixel
        dec     cx
        jz      DPBL6                   ; Draw: points in adjacent 4pixels

        ; Draw three parts
        mov     bx,[si]
        mov     cx,[si+2]

        ; Now draw left part
        mov     bp,bx
        shr     bp,1
        shr     bp,1
        add     di,bp
        mov     bp,bx
        and     bp,3
        mov     ah,ds:DPBLeft[bp]
        mov     al,2                    ; Map mask register
        mov     dx,3C4h
        out     dx,ax                   ; Set this reg
        mov     al,[DPBClr]
        stosb                           ; Draw and DI++
        
        ; Now draw middle part
        mov     ax,0F02h
        out     dx,ax                   ; Map mask reg: all planes
        mov     bp,cx
        and     bx,0FFFCh
        sub     bp,bx
        shr     bp,1
        shr     bp,1
        dec     bp
        xchg    cx,bp
        mov     bx,cx
        shr     cx,1
        mov     al,[DPBClr]
        or      cx,cx
        jz      DPBL7
        mov     ah,al
        rep     stosw                   ; Draw middle 2*(n%2) 4pixels
DPBL7:  and     bx,1
        jz      DPBL4
        stosb                           ; Draw last 4pixel if necessary
DPBL4:     
        ; Now draw right part
        and     bp,3
        mov     ah,ds:DPBRight[bp]
        mov     al,2
        out     dx,ax
        mov     al,[DPBClr]
        stosb
        jmp     DPBL1
        
DPBL5:  ; Draw if both points are in the same 4pixel
        mov     bx,[si]
        mov     bp,bx
        shr     bp,1
        shr     bp,1
        add     di,bp
        and     bx,3
        mov     ah,DPBLeft[bx]
        mov     bx,[si+2]
        and     bx,3
        and     ah,DPBRight[bx]
        mov     al,2
        mov     dx,3C4h
        out     dx,ax
        mov     al,[DPBClr]
        stosb
        jmp     DPBL1

DPBL6:  ; Draw if both points are in adjacent 4pixels
        mov     bx,[si]
        mov     bp,bx
        shr     bp,1
        shr     bp,1
        add     di,bp
        and     bx,3
        mov     ah,DPBLeft[bx]
        mov     al,2
        mov     dx,3C4h
        out     dx,ax
        mov     al,[DPBClr]
        stosb
        mov     bx,[si+2]
        and     bx,3
        mov     ah,DPBRight[bx]
        mov     al,2
        out     dx,ax
        mov     al,[DPBClr]
        stosb
        ;jmp     DPBL1
        

        ; Keep on with the loop
DPBL1:  pop     si
        pop     di
        pop     cx
        add     di,80d
        add     si,4
        loop    DPBML
        ret
DumpPBuf ENDP

; 
;  Function to insert a line into a polygon buffer 
; 
; IN: DI -> Polygon buffer
;     
.DATA
        EVEN
ALPBX1  DW ?
ALPBY1  DW ?
ALPBX2  DW ?
ALPBY2  DW ?

                DW ?
ALPBAdjFrac     DW 0

                DW 1
ALPBAdjCoorX    DW 0

.CODE
        EVEN
AddLineToPBuf PROC
        mov     ax,[ALPBY2]
        mov     bx,[ALPBY1]
        cmp     ax,bx
        jne     SHORT ALPBL0
        ret
ALPBL0: ja      ALPBL1                  ; Y2 > Y1 => don't swap
        mov     [ALPBY1],ax
        mov     [ALPBY2],bx
        xchg    ax,bx
        mov     cx,[ALPBX1]
        mov     dx,[ALPBX2]
        mov     [ALPBX1],dx
        mov     [ALPBX2],cx
ALPBL1: sub     ax,bx
        mov     bp,ax                   ; BP = dY
        shl     bx,1
        shl     bx,1
        add     di,bx
        mov     cx,ax
        inc     cx                      ; CX = dY + 1
        mov     ax,[ALPBX2]
        sub     ax,[ALPBX1]             ; AX = dX
        jns ALPBL4                      ; Going from left to right
        neg     ax                      ; Make dX >= 0
        mov     [ALPBAdjCoorX-2],-1     ; Coor adjusts negative
ALPBL4:
        cwd
        idiv    bp                      ; AX = dX / dY
        mov     si,dx                   ; SI = dX % dY
        mov     dx,ax                   ; DX = dX / dY
        neg     bp                      ; BP = - dY
        mov     ax,bp
        add     ax,ax                   ; AX = - 2 * dY
        mov     [ALPBAdjFrac-2],ax
        mov     ax,[ALPBX1]             ; AX = X1
        add     si,si                   ; SI = 2 * (dX % dY)
        cmp     WORD PTR [ALPBAdjCoorX-2],1
        je      ALPBML
        neg     dx
ALPBML: cmp     ax,[di]
        jg      ALPBL2                  ; Don't adjust left X
        mov     [di],ax
ALPBL2: cmp     ax,[di+2]
        jl      ALPBL3
        mov     [di+2],ax
ALPBL3: add     di,4
        add     ax,dx                   ; Increment X always
        add     bp,si                   ; Increment fractional part
        sbb     bx,bx
        add     bx,bx
        add     ax,ALPBAdjCoorX[bx]     ; Adjust Coor X (1 or 0)
        add     bp,ALPBAdjFrac[bx]      ; Adjust fractional part (0 or -2.dY)
        loop    SHORT ALPBML
        mov     [ALPBAdjCoorX-2],1
        ret
AddLineToPBuf ENDP


; 
;  Main function
; 
.CODE
        EVEN
Main    PROC
        mov     ax,@DATA
        mov     ds,ax

        mov     ax,0013h
        int     10h                     ; Standard 320x200x256 vmode
        mov     dx,3C4h
        mov     al,04
        out     dx,al
        inc     dx
        in      al,dx                   ; Read Sequencer memory mode
        and     al,NOT 8                ; register and unCHAIN4
        out     dx,al

        mov     dx,3C4h
        mov     ax,0F02h                ; Map Mask register = 1111b
        out     dx,ax
        mov     ax,0A000h
        mov     es,ax
        xor     di,di
        xor     ax,ax                   ; Fill with zeros
        mov     cx,32768d               ; Words in each map
        rep     stosw

        mov     dx,3D4h
        mov     al,14h
        out     dx,al
        inc     dx
        in      al,dx
        and     al,NOT 64               ; Turn off DWORD mode
        out     dx,al

        mov     dx,3D4h
        mov     al,17h
        out     dx,al
        inc     dx
        in      al,dx
        or      al,64                   ; Turn on BYTE mode
        out     dx,al

        cmp     [Mode],WIREFRAME
        jnz     ML4
        mov     [LinesBufferPtr],OFFSET LinesBuffer1
        mov     [NumBufferedLinesPtr],OFFSET NumBufferedLines1
        mov     [NumBufferedLines1],0
        mov     [NumBufferedLines2],0
        jmp     ML5
   ML4: mov     [LinesBufferPtr],OFFSET LinesBuffer1
        mov     di,OFFSET LinesBuffer1
        call    ClearPBuf
        mov     di,OFFSET LinesBuffer2
        call    ClearPBuf
   ML5:
        mov     [QuitPrg],0
        mov     [ZN],128
MMainLoop:
        SetBorder 2
        call    DoSeq
        SetBorder 3
        call    CalcM
        SetBorder 4
        call    CalcDist
        SetBorder 5
        call    WToCam
        SetBorder 6
        call    BuildClip
        SetBorder 7
        call    SortByDist
        SetBorder 8
        cmp     [Mode],WIREFRAME
        jnz     ML0
        call    DrawWire
        jmp     ML1
   ML0: call    DrawSolid
   ML1:
        SetBorder 0

        mov     dx,3DAh
MWaitA: in      al,dx
        test    al,8
        jnz     MWaitA

        mov     ax,[VGASeg]             ; Show just-drawn page
        mov     cl,4
        shl     ax,cl
        mov     al,0Ch                  ; Start Address Hi register
        mov     dx,3D4h
        out     dx,ax

        mov     dx,3DAh
MWait0: in      al,dx
        test    al,8
        jz      MWait0

        mov     dx,3DAh
MWait1: in      al,dx
        test    al,8
        jnz     MWait1

        SetBorder 1

        mov     ax,[LinesBufferPtr]
        xor     ax,OFFSET LinesBuffer1
        xor     ax,OFFSET LinesBuffer2
        mov     [LinesBufferPtr],ax
        mov     ax,[NumBufferedLinesPtr]
        xor     ax,OFFSET NumBufferedLines1
        xor     ax,OFFSET NumBufferedLines2
        mov     [NumBufferedLinesPtr],ax
        xor     [VGASeg],400h
        cmp     [Mode],WIREFRAME
        jnz     ML2
        call    EraseBufferedLines
        jmp     ML3
   ML2: call    EraseBufferedPolys
   ML3:

        mov     ax,[QuitPrg]
        or      ax,ax
        jnz     MExit
        jmp     MMainLoop

MExit:  mov     ax,0003
        int     10h
        mov     dx,OFFSET ByeMsg
        mov     ah,9
        int     21h
        mov     ax,4C00h
        int     21h

Main    ENDP

        END Main
