{*************************************************}
{*                  FGCE.PAS 1.00                *}
{*     Copyright (c) 1994 by Thomas Bargholz     *}
{*             All rights reserved               *}
{*************************************************}
{

Fastgraph Cursor Editor. Version 1.00.

The Fastgraph name is a registered trademark of Ted Gruber Software, Inc.
Used under kind permission.

This program is a mouse-cursor drawing program, that allows you to draw the
appearance of the desired cursor, test it, and then save it as source code
in the language of your choice.

The program requires EGA and a mouse.

Language : Borland Pascal 7.01.
Date     : November 5th, 1994.

This program requires Ted Gruber Software's Fastgraph (tm) graphics library
to recompile.
If you're looking for a good graphics library with support for video modes
from 320x200x2 to 1024x768x256, with support for PCX, GIF and FLI, lots of
animation features, mouse and joy-stick support and much much more, 
Fastgraph (tm) is the library for you... For more information contact:

Ted Gruber Software
P.O.Box 13408
Las Vegas, NV 89112
USA
Phone: +1 702-735-1980
Fax: +1 602-483-0193
CIS: 72000,1642


If you have any suggestions, comments or bug-reports conserning this program,
please contact:

e-mail     : tba@m.dia.dk
snail mail : Thomas Bargholz
             Smallegade 20A, 3 tv
             DK-2000 Frederiksberg
             Denmark

Do not contact Ted Gruber Software about this program, as they are not 
responsible for it.

}


{$DEFINE DEBUG}

{$IFDEF DEBUG}
{$I-,D+,L+,Y+,A+,X+,R+,G-}
{$ELSE}
{$I-,D-,L-,Y-,A+,X+,R-,G-}
{$ENDIF}

Uses
  FgMain,                         {main graphic initialization unit}
  FgMisc,                         {misc. routines unit: keyboard e.t.c}
  FgBitmap;                       {bitmap drawing unit}

Const
  Wait : Array[0..31] Of Word = (            {hour-glass cursor}
         $001F,$803F,$803F,$803F,$803F,$C07F,$E0FF,$F1FF,
         $F1FF,$E0FF,$C07F,$803F,$803F,$803F,$803F,$001F,
         $0000,$3F80,$3F80,$3F80,$3B80,$1500,$0A00,$0400,
         $0400,$0E00,$1B00,$3F80,$3B80,$3580,$2A80,$0000);

Type
  ButtonType = (Up, Dn);                     {button type}
  RadioType = (Sel, NotSel);                 {radio button type}
  OutputType = (c, Pascal, Fortran, Basic);  {source code language}
  TColor = (Black, White, Transp, Invert);   {cursor color}
  WBit = 0..15;                              {bits in a Word}

Const
  Output : OutputType = Pascal;              {default output}
  Color : TColor = Black;                    {default cursor color}

Const
  OutputName : String = 'CURSOR';            {default output file name}

Var
  F : Text;                                  {output when saving source code}
  FullCursor : Array[0..15,0..15] Of TColor; {keep track of the appearance}
  Cursor : Array[0..31] Of Word;             {actual code for cursor}


Procedure Button(State : ButtonType; PosX, PosY, Width : Integer;
                 Text : String);
  {- draws a button at location PosX, PosY, with the length Width,
     displaying the text Text. State is either Up or Dn}
Var
  Len : Integer;
Begin
  Len := Length(Text);
  Case State Of
    Up : Begin
           fg_move(PosX, PosY);
           fg_setcolor(15);
           fg_drawrel(Width,0);
           fg_setcolor(8);
           fg_drawrel(0,12);
           fg_drawrel(-Width,0);
           fg_setcolor(15);
           fg_drawrel(0,-12);
           fg_setcolor(7);
           fg_rect(PosX+2, PosX+8+Len*8,PosY+2, PosY+10);
           fg_setcolor(0);
           fg_move(PosX + 8, PosY + 10);
           fg_print(Text, Len);
         End;
    Dn : Begin
           fg_move(PosX, PosY);
           fg_setcolor(8);
           fg_drawrel(Width,0);
           fg_setcolor(15);
           fg_drawrel(0,12);
           fg_drawrel(-Width,0);
           fg_setcolor(7);
           fg_rect(PosX+2, PosX+8+Len*8,PosY+2, PosY+10);
           fg_setcolor(8);
           fg_drawrel(0,-12);
           fg_move(PosX + 9, PosY + 11);
           fg_setcolor(0);
           fg_print(Text, Len);
         End;
  End;
End;

Procedure RadioButton(State : RadioType; PosX, PosY : Integer;
                      Text : String);
  {- draws a radio button at location PosX, PosY, with the text Text.
     State is either Sel or NotSel (selected/not selcted)}
Var
  Len : Integer;
Begin
  Len := Length(Text);
  Case State Of
    Sel : Begin
            fg_setcolor(0);
            fg_move(PosX+5,PosY+5);
            fg_circle(5);
            fg_circlef(3);
            fg_move(PosX + 17, PosY + 9);
            fg_print(Text,Len);
          End;
    NotSel : Begin
               fg_setcolor(0);
               fg_move(PosX+5,PosY+5);
               fg_circle(5);
               fg_setcolor(7);
               fg_circlef(3);
               fg_move(PosX + 17, PosY + 9);
               fg_setcolor(0);
               fg_print(Text,Len);
             End;
  End;
End;

Procedure GroupBox(X,Y,Width,Height : Integer; Text : String);
  {- draws a group box, with upper left corner in position X,Y and
     with the width Width, and the height Height. Text is the group
     box caption}
Var
  Len : Integer;
Begin
  Len := Length(Text);
  fg_move(X,Y);
  fg_setcolor(8);
  fg_drawrel(Width,0);
  fg_setcolor(15);
  fg_drawrel(0,Height);
  fg_drawrel(-Width,0);
  fg_setcolor(8);
  fg_drawrel(0,-Height);
  fg_setcolor(7);
  fg_rect(X+3,X+6+Len*8,Y-4,Y+4);
  fg_setcolor(0);
  fg_move(X+6,Y+3);
  fg_print(Text,Len);
End;

Procedure DrawGrid;
  {- draw grid for the fat bit editor}
Begin
  fg_setcolor(7);
  fg_rect(110,206,30,126);                       {clear area for grid}
  fg_setcolor(8);
  fg_move(110,30); fg_drawrel(96,0);             {draw the lines that make }
  fg_move(110,36); fg_drawrel(96,0);             {up the grid              }
  fg_move(110,42); fg_drawrel(96,0);
  fg_move(110,48); fg_drawrel(96,0);
  fg_move(110,54); fg_drawrel(96,0);
  fg_move(110,60); fg_drawrel(96,0);
  fg_move(110,66); fg_drawrel(96,0);
  fg_move(110,72); fg_drawrel(96,0);
  fg_move(110,78); fg_drawrel(96,0);
  fg_move(110,84); fg_drawrel(96,0);
  fg_move(110,90); fg_drawrel(96,0);
  fg_move(110,96); fg_drawrel(96,0);
  fg_move(110,102);fg_drawrel(96,0);
  fg_move(110,108);fg_drawrel(96,0);
  fg_move(110,114);fg_drawrel(96,0);
  fg_move(110,120);fg_drawrel(96,0);
  fg_move(110,126);fg_drawrel(96,0);
  fg_move(110,30); fg_drawrel(0,96);
  fg_move(116,30); fg_drawrel(0,96);
  fg_move(122,30); fg_drawrel(0,96);
  fg_move(128,30); fg_drawrel(0,96);
  fg_move(134,30); fg_drawrel(0,96);
  fg_move(140,30); fg_drawrel(0,96);
  fg_move(146,30); fg_drawrel(0,96);
  fg_move(152,30); fg_drawrel(0,96);
  fg_move(158,30); fg_drawrel(0,96);
  fg_move(164,30); fg_drawrel(0,96);
  fg_move(170,30); fg_drawrel(0,96);
  fg_move(176,30); fg_drawrel(0,96);
  fg_move(182,30); fg_drawrel(0,96);
  fg_move(188,30); fg_drawrel(0,96);
  fg_move(194,30); fg_drawrel(0,96);
  fg_move(200,30); fg_drawrel(0,96);
  fg_move(206,30); fg_drawrel(0,96);
End;

Procedure BuildUI;
  {- create the user interface}
Begin
  fg_setcolor(15);
  fg_rect(0,fg_getmaxx,0,12);                    {top line}
  fg_rect(0,fg_getmaxx,fg_getmaxy-12,fg_getmaxy);{bottom line}
  fg_setcolor(7);
  fg_rect(0,fg_getmaxx,13,fg_getmaxy-13);        {work area}
  fg_setcolor(0);
  fg_move(6,11);
  fg_print('Fastgraph Cursor Editor 1.00',28);   {name in black at top}
  fg_move(6,198);
  fg_print('Source code : ',14);                 {name in black at bottom}
  fg_move(120,197);
  fg_print('CURSOR.PAS',10);                     {default output name}
  fg_setcolor(12);
  fg_move(5,10);
  fg_print('Fastgraph Cursor Editor 1.00',28);   {name in red at top}
  fg_move(5,197);
  fg_print('Source code : ',14);                 {name in red at bottom}
  Button(Up,5,20,56,'Save');                     {"Save" - button}
  Button(Up,5,35,56,'Clear');                    {"Clear" - button}
  Button(Up,5,50,56,'Test');                     {"Test" - button}
  Button(Up,5,65,56,'Exit');                     {"Exit" - button}
  RadioButton(Sel,7,130,'Pascal');               {"Pascal" - radio button}
  RadioButton(NotSel,7,142,'c');                 {"c" - radio button}
  RadioButton(NotSel,7,154,'Fortran');           {"Fortran" - radio button}
  RadioButton(NotSel,7,166,'Basic');             {"Basic" - radio button}
  GroupBox(3,125,80,55,'Source');                {group box for above radio}
  RadioButton(Sel,236,130,'Black');              {"Black" - radio button}
  RadioButton(NotSel,236,142,'White');           {"White" - radio button}
  RadioButton(NotSel,236,154,'Transp');          {"Transp" - radio button}
  RadioButton(NotSel,236,166,'Invert');          {"Invert" - radio button}
  GroupBox(232,125,80,55,'Color');               {group box for above radio}
  DrawGrid;
  GroupBox(90,20,135,125,'Fat');                 {group box for fat bit}
  GroupBox(255,20,42,45,'Life');                 {group box for real size}
  fg_mousevis(1);
End;

Function HexWord(W : Word) : String;
  {- converts a Word into a hex string}
Const
  Digits : Array[0..$F] Of Char = '0123456789ABCDEF';
Begin
  HexWord[0] := #4;
  HexWord[1] := Digits[Hi(W) Shr 4];
  HexWord[2] := Digits[Hi(W) And $F];
  HexWord[3] := Digits[Lo(W) Shr 4];
  HexWord[4] := Digits[Lo(W) And $F];
End;

Procedure SavePas;
  {- save cursor as Pascal source code}
Var
  I : Integer;
Begin
  Assign(F,OutputName + '.PAS');
  Rewrite(F);
  WriteLn(F);
  WriteLn(F,'const');
  WriteLn(F,'  MyCursor : array[0..31] of Word = (');
  Write(F,'         ');
  For I := 0 To 7 Do
    Write(F,'$',HexWord(Cursor[I]),',');
  WriteLn(F);
  Write(F,'         ');
  For I := 8 To 15 Do
    Write(F,'$',HexWord(Cursor[I]),',');
  WriteLn(F);
  Write(F,'         ');
  For I := 16 To 23 Do
    Write(F,'$',HexWord(Cursor[I]),',');
  WriteLn(F);
  Write(F,'         ');
  For I := 24 To 30 Do
    Write(F,'$',HexWord(Cursor[I]),',');
  WriteLn(F,'$',HexWord(Cursor[31]),');');
  WriteLn(F);
  Close(F);
End;

Procedure SaveC;
  {- save cursor as c source code}
Var
  I : Integer;
Begin
  Assign(F,OutputName + '.C');
  Rewrite(F);
  WriteLn(F);
  Write(F,'short mycursor[] = {');
  For I := 0 To 7 Do
    Write(F,'0x',HexWord(Cursor[I]),',');
  WriteLn(F);
  Write(F,'                    ');
  For I := 8 To 15 Do
    Write(F,'0x',HexWord(Cursor[I]),',');
  WriteLn(F);
  Write(F,'                    ');
  For I := 16 To 23 Do
    Write(F,'0x',HexWord(Cursor[I]),',');
  WriteLn(F);
  Write(F,'                    ');
  For I := 24 To 30 Do
    Write(F,'0x',HexWord(Cursor[I]),',');
  WriteLn(F,'0x',HexWord(Cursor[31]),'};');
  WriteLn(F);
  Close(F);
End;

Procedure SaveFor;
  {- save cursor as Fortran source code}
Var
  I : Integer;
Begin
  Assign(F,OutputName + '.FOR');
  Rewrite(F);
  WriteLn(F);
  WriteLn(F,'       INTEGER*2 MYCURSOR(32)');
  WriteLn(F);
  WriteLn(F,'       DATA MYCURSOR /');
  Write(F,'      +   ');
  For I := 0 To 7 Do
    Write(F,'#',HexWord(Cursor[I]),',');
  WriteLn(F);
  Write(F,'      +   ');
  For I := 8 To 15 Do
    Write(F,'#',HexWord(Cursor[I]),',');
  WriteLn(F);
  Write(F,'      +   ');
  For I := 16 To 23 Do
    Write(F,'#',HexWord(Cursor[I]),',');
  WriteLn(F);
  Write(F,'      +   ');
  For I := 24 To 30 Do
    Write(F,'#',HexWord(Cursor[I]),',');
  WriteLn(F,'#',HexWord(Cursor[31]),'/');
  WriteLn(F);
  Close(F);
End;

Procedure SaveBas;
  {- save cursor as Baic source code}
Var
  I : Integer;
Begin
  Assign(F,OutputName + '.BAS');
  Rewrite(F);
  WriteLn(F);
  WriteLn(F,'DIM MyCursor(32)');
  WriteLn(F);
  WriteLn(F,'Rem MyCursor values');
  Write(F,'DATA ');
  For I := 0 To 7 Do
    Write(F,'&',HexWord(Cursor[I]),',');
  WriteLn(F);
  Write(F,'DATA ');
  For I := 8 To 15 Do
    Write(F,'&',HexWord(Cursor[I]),',');
  WriteLn(F);
  Write(F,'DATA ');
  For I := 16 To 23 Do
    Write(F,'&',HexWord(Cursor[I]),',');
  WriteLn(F);
  Write(F,'DATA ');
  For I := 24 To 30 Do
    Write(F,'&',HexWord(Cursor[I]),',');
  WriteLn(F,'&',HexWord(Cursor[31]));
  WriteLn(F);
  Close(F);
End;


Procedure CalcCursor;
  {- calculates the word values for the actual cursor}

  Procedure SetBitW(Var W : Word; Bit : WBit);Assembler;
    {- set specified bit in a Word}
  Asm
    Mov Cl, Bit
    Mov BX, 1
    SHL BX, CL
    LES DI, W
    OR ES:[DI], BX
  End;

Var
  I, J : Integer;
Begin
  FillChar(Cursor,SizeOf(Cursor),0);             {solid black as default,
                                                  as no bits are set}
  For I := 0 To 15 Do
    For J := 0 To 15 Do
      Case FullCursor[I,J] Of
        White : SetBitW(Cursor[J+16],15-I);      {set the bits for white}
        Transp : SetBitW(Cursor[J],15-I);        {set the bits for transp.}
        Invert : Begin                           {set the bits for inverted}
                   SetBitW(Cursor[J+16],15-I);
                   SetBitW(Cursor[J],15-I);
                 End;
      End;
End;


Var
  OldMode : Byte;                                {stores the old video mode}
  Count, X, Y : Integer;                         {track mouse}
  Bt, PosX, PosY : Integer;                      {  -- " -- }
  TileX, TileY : Integer;                        {position in fat bit editor}
  key, aux : Byte;                               {keyboard scan codes}
  Ch : Char;                                     {keyboard pressed chararacter}
  S : String;                                    {filename as a string}
  I : Integer;                                   {length of filename}

Begin
  OldMode := fg_getmode;                         {save old video mode}
  If fg_testmode(13,1) = 0 Then                  {hardware ok?}
  Begin
    fg_setmode(OldMode);
    fg_reset;
    WriteLn('What a piece of crap hardware you got!');
    Halt(1);
  End;
  fg_setmode(13);                                {320x200 EGA graphic mode}
  if (fg_mouseini < 0) then                      {is a mouse present?}
  begin
    fg_setmode(OldMode);
    fg_reset;
    WriteLn('Sorry! Fastgraph Cursor Editor requires a rodent');
    Halt(1);
  end;

  FillChar(FullCursor,SizeOf(FullCursor),Transp);{work area is transparent}

  BuildUI;                                       {create the user interface}

  Repeat                                         {loop while checking mouse}
    fg_mousebut(-1,Count,PosX,PosY);             {left mouse button release}
    fg_mousebut(1,Count,X,Y);                    {left mouse button press}
    If (X = 0) And (Y = 0) Then Continue;
    If (X >= 6) And (X <= 60) And (Y In [21..31]) Then
    Begin                                        {mouse press : Save button}
      fg_mousevis(0);
      Button(Dn,5,20,56,'Save');                 {draw pressed button}
      fg_mousevis(1);
      Repeat
        fg_mousebut(-1,Count,X,Y);               {wait for a mouse release}
      Until Count > 0;
      If (X >= 6) And (X <= 60) And (Y In [21..31]) Then
      Begin                                      {relase inside button}
        fg_mouseptr(Wait,6,8);                   {use hour-glass cursor}
        CalcCursor;                              {calculate data for cursor}
        Case Output Of                           {save correct source code}
          Pascal : SavePas;
          c : SaveC;
          Fortran : SaveFor;
          Basic : SaveBas;
        End;
        fg_mousepos(PosX, PosY, Bt);             {get mouse position}
        fg_mouseini;                             {reset mouse cursor}
        fg_mousemov(PosX, PosY);                 {set mouse position}
      End;
      fg_mousevis(0);
      Button(Up,5,20,56,'Save');                 {redraw button}
      fg_mousevis(1);
      Continue;
    End;
    If (X >= 6) And (X <= 60) And (Y In [36..46]) Then
    Begin                                        {mouse press : Clear button}
      fg_mousevis(0);
      Button(Dn,5,35,56,'Clear');                {draw pressed button}
      fg_mousevis(1);
      Repeat
        fg_mousebut(-1,Count,X,Y);               {wait for mouse release}
      Until Count > 0;
      If (X >= 6) And (X <= 60) And (Y In [36..46]) Then
      Begin                                      {release inside button}
        FillChar(FullCursor,SizeOf(FullCursor),Transp);{reset data structure}
        fg_mousevis(0);
        DrawGrid;                                {reset grid}
        fg_setcolor(7);
        fg_rect(265,290,35,60);                  {reset life size area}
        fg_mousevis(1);
      End;
      fg_mousevis(0);
      Button(Up,5,35,56,'Clear');                {redraw button}
      fg_mousevis(1);
      Continue;
    End;
    If (X >= 6) And (X <= 60) And (Y In [51..61]) Then
    Begin                                        {mouse press : Test button}
      fg_mousevis(0);
      Button(Dn,5,50,56,'Test');                 {draw pressed button}
      fg_mousevis(1);
      Repeat                                     {wait for a mouse release}
        fg_mousebut(-1,Count,PosX,PosY);
      Until Count > 0;
      If (PosX >= 6) And (PosX <= 60) And (PosY In [51..61]) Then
      Begin                                      {released inside button}
        CalcCursor;                              {calculate data for cursor}
        fg_mouseptr(Cursor,0,0);
        Repeat
          fg_mousebut(1,Count,PosX,PosY);        {wait for a mouse press}
        Until Count > 0;
        Repeat
          fg_mousebut(-1,Count,PosX,PosY);       {wait for mouse release}
        Until Count > 0;
        fg_mousepos(PosX, PosY, Bt);             {get mouse position}
        fg_mouseini;                             {reset mouse cursor}
        fg_mousemov(PosX, PosY);                 {set mouse position}
      End;
      Button(Up,5,50,56,'Test');                 {redraw button}
      fg_mousevis(1);
      Continue;
    End;
    If (X >= 6) And (X <= 60) And (Y In [66..76]) Then
    Begin                                        {mouse press : Exit button}
      fg_mousevis(0);
      Button(Dn,5,65,56,'Exit');                 {draw pressed button}
      fg_mousevis(1);
      Repeat
        fg_mousebut(-1,Count,X,Y);               {wait for mouse release}
      Until Count > 0;
      If (X >= 6) And (X <= 60) And (Y In [66..76]) Then
        Break;                                   {released inside button}
      fg_mousevis(0);
      Button(Up,5,65,56,'Exit');                 {redraw button}
      fg_mousevis(1);
      Continue;
    End;
    If (X >= 5) And (X <= 75) And (Y In [130..140]) Then
    Begin                                        {mouse press : Pascal radiobt}
      If Output <> Pascal Then
      Begin
        fg_mousevis(0);
        RadioButton(Sel,7,130,'Pascal');         {redraw radio buttons}
        RadioButton(NotSel,7,142,'c');
        RadioButton(NotSel,7,154,'Fortran');
        RadioButton(NotSel,7,166,'Basic');
        Output := Pascal;                        {new selected output type}
        fg_setcolor(15);
        fg_rect(118,220,189,198);                {erase filename in status}
        fg_setcolor(0);
        fg_move(120,197);
        fg_print(OutputName + '.PAS',Length(OutputName)+4);{new filename}
        fg_mousevis(1);
        Continue;
      End;
    End;
    If (X >= 5) And (X <= 75) And (Y In [142..152]) Then
    Begin                                        {mouse press : c radiobt}
      If Output <> c Then
      Begin
        fg_mousevis(0);
        RadioButton(NotSel,7,130,'Pascal');      {redraw radio buttons}
        RadioButton(Sel,7,142,'c');
        RadioButton(NotSel,7,154,'Fortran');
        RadioButton(NotSel,7,166,'Basic');
        Output := c;                             {new selected output type}
        fg_setcolor(15);
        fg_rect(118,220,189,198);                {erase filename in status}
        fg_setcolor(0);
        fg_move(120,197);
        fg_print(OutputName + '.C',Length(OutputName)+2);{new filename}
        fg_mousevis(1);
        Continue;
      End;
    End;
    If (X >= 5) And (X <= 75) And (Y In [154..164]) Then
    Begin                                        {mouse press : Fortran radio}
      If Output <> Fortran Then
      Begin
        fg_mousevis(0);
        RadioButton(NotSel,7,130,'Pascal');      {redraw radio buttons}
        RadioButton(NotSel,7,142,'c');
        RadioButton(Sel,7,154,'Fortran');
        RadioButton(NotSel,7,166,'Basic');
        Output := Fortran;                       {new selected output type}
        fg_setcolor(15);
        fg_rect(118,220,189,198);                {erase filename in status}
        fg_setcolor(0);
        fg_move(120,197);
        fg_print(OutputName + '.FOR',Length(OutputName)+4);{new filename}
        fg_mousevis(1);
        Continue;
      End;
    End;
    If (X >= 5) And (X <= 75) And (Y In [166..176]) Then
    Begin                                        {mouse press : Basic radiobt}
      If Output <> Basic Then
      Begin
        fg_mousevis(0);
        RadioButton(NotSel,7,130,'Pascal');      {redraw radio buttons}
        RadioButton(NotSel,7,142,'c');
        RadioButton(NotSel,7,154,'Fortran');
        RadioButton(Sel,7,166,'Basic');
        Output := Basic;                         {set new output type}
        fg_setcolor(15);
        fg_rect(118,220,189,198);                {erase filename in status}
        fg_setcolor(0);
        fg_move(120,197);
        fg_print(OutputName + '.BAS',Length(OutputName)+4);{new filename}
        fg_mousevis(1);
        Continue;
      End;
    End;
    If (X >= 236) And (X <= 308) And (Y In [130..140]) Then
    Begin                                        {mouse press : Black radiobt}
      If Color <> Black Then
      Begin
        fg_mousevis(0);
        RadioButton(Sel,236,130,'Black');        {redraw radio buttons}
        RadioButton(NotSel,236,142,'White');
        RadioButton(NotSel,236,154,'Transp');
        RadioButton(NotSel,236,166,'Invert');
        fg_mousevis(1);
        Color := Black;                          {set new color type}
        Continue;
      End;
    End;
    If (X >= 238) And (X <= 308) And (Y In [142..152]) Then
    Begin                                        {mouse press : White radiobt}
      If Color <> White Then
      Begin
        fg_mousevis(0);
        RadioButton(NotSel,236,130,'Black');     {redraw radio buttons}
        RadioButton(Sel,236,142,'White');
        RadioButton(NotSel,236,154,'Transp');
        RadioButton(NotSel,236,166,'Invert');
        fg_mousevis(1);
        Color := White;                          {set new color type}
        Continue;
      End;
    End;
    If (X >= 238) And (X <= 308) And (Y In [154..164]) Then
    Begin                                        {mouse press : Transp radiobt}
      If Color <> Transp Then
      Begin
        fg_mousevis(0);
        RadioButton(NotSel,236,130,'Black');     {redraw radio buttons}
        RadioButton(NotSel,236,142,'White');
        RadioButton(Sel,236,154,'Transp');
        RadioButton(NotSel,236,166,'Invert');
        fg_mousevis(1);
        Color := Transp;                         {set new color type}
        Continue;
      End;
    End;
    If (X >= 238) And (X <= 308) And (Y In [166..176]) Then
    Begin                                        {mouse press : Invert radiobt}
      If Color <> Invert Then
      Begin
        fg_mousevis(0);
        RadioButton(NotSel,236,130,'Black');     {redraw radio buttons}
        RadioButton(NotSel,236,142,'White');
        RadioButton(NotSel,236,154,'Transp');
        RadioButton(Sel,236,166,'Invert');
        fg_mousevis(1);
        Color := Invert;                         {set new color type}
        Continue;
      End;
    End;
    If (X >= 118) And (X <= 214) And (Y In [180..200]) Then
    Begin                                        {mouse click : filename}
      fg_mousevis(0);
      fg_setcolor(15);
      fg_rect(118,220,189,198);                  {erase filename in status}
      fg_setcolor(0);
      fg_move(120,197);
      fg_print('|',1);
      S := '';
      I := 0;
      Repeat
        fg_intkey(Key,Aux);                      {empty keyboard buffer}
      Until (Key = 0) And (Aux = 0);
      Repeat
        fg_getkey(key,aux);                      {get keyboard}
        Ch := UpCase(Chr(key));
        If (Ch In ['0'..'9','A'..'Z',#123,#125,#95,#91,#93,#40,#41,#45]) Then
           {valid keys are: 0-9,A-Z,{,_,[,],(,),- and }
        Begin                                    {did we have a valid key?}
          Inc(I);                                {increment char count}
          If I > 8 Then
            I := 8;                              {max 8 characters}
          If I = 8 Then
            S := Copy(S,1,7);
          S := S + Ch;
        End;
        If Key = 8 Then                          {backspace}
        Begin
          If I > 1 Then
          Begin
            S := Copy(S,1,Length(S)-1);          {remove last char}
            Dec(I);                              {decrement char count}
          End
          Else
          Begin
            I := 0;                              {not chars available}
            S := '';                             {empty string}
          End;
        End;
        If I = 8 Then                            {change only 8'th character}
        Begin
          fg_setcolor(15);
          fg_rect(176,220,189,198);              {erase last char}
          fg_setcolor(0);
          fg_move(176,197);
          fg_print(S[8]+'|',2);                  {write new last char}
        End
        Else
        Begin                                    {add character}
          fg_setcolor(15);
          fg_rect(112 + I*8,220,189,198);
          fg_setcolor(0);
          fg_move(112 + I*8,197);
          If S <> '' Then
            fg_print(S[I]+'|',2)
          Else
            fg_print(' |',2);
        End;
      Until (key = 13) Or (key = 27);            {enter or escape}
      If key = 13 Then                           {if enter was pressed, and}
        If S <> '' Then                          {the user gave a new name:}
          OutputName := S;                       {save it as the default   }
      Case Output Of                             {add the extension}
        Pascal : S := OutputName + '.PAS';
        c : S := OutputName + '.C';
        Fortran : S := OutputName + '.FOR';
        Basic : S := OutputName + '.BAS';
      End;
      fg_setcolor(15);
      fg_rect(118,220,189,198);                  {erase filename from status}
      fg_setcolor(0);
      fg_move(120,197);
      fg_print(S,Length(S));                     {write the new output name}
      fg_mousevis(1);
      Continue;
    End;
    If (X >= 110) And (X <= 206) And (Y In [30..126]) Then
    Begin                                        {inside the fat bit grid}
      Case Color Of
        Black : fg_setcolor(0);                  {set selected color}
        White : fg_setcolor(15);
        Transp : fg_setcolor(7);
        Invert : fg_setcolor(3);
      End;
      PosX := 100;
      Repeat
        fg_mousepos(X,Y,Bt);                     {get mouse position}
        TileX := (X-110) Div 6;                  {calculate X bit}
        TileY := (Y-30) Div 6;                   {calculate Y bit}
        If (TileX >= 0) And (TileX <= 15) And (TileY >= 0) And
           (TileY <= 15) And ((TileX <> PosX) Or (TileY <> PosY)) Then
        Begin                                    {mouse moved inside grid}
          fg_mousevis(0);
          fg_rect(111+TileX*6,115+TileX*6,31+TileY*6,35+TileY*6);{fat bit}
          fg_point(269+TileX,36+TileY);          {real size cursor}
          fg_mousevis(1);
          FullCursor[TileX,TileY] := Color;      {update data structure}
          PosX := TileX;                         {save current X bit}
          PosY := TileY;                         {save current Y bit}
        End;
        fg_mousebut(-1,Count,X,Y);               {check if mouse was released}
      Until Count > 0;
      Continue;
    End;
  Until True = False;                            {which should last forever}

  fg_setmode(OldMode);                           {reset video mode}
  fg_reset;                                      {reset Fastgraph}

End.


