'***********************************************************************
'
' FISHTANK.BAS -- This program demonstrates multi-object non-destructive
' animation. The coral background is displayed on page 2 and copied to
' page 0, the visual page. A packed pixel run file containing the 6 fish
' is displayed on page 1, and then FGgetimage is used to load the fish
' into the fish bitmaps.
'
' To make the fish move, the background is copied to page 1 and the fish
' are put over the background using FGclpimage and FGflpimage. The
' fish are clipped at the edge of the screen. Page 1 is then copied to
' page 0 using FGcopypage. This process is repeated in a loop.
'
' To compile this program and link it with Fastgraph version 4.0:
'
'    BC /O FISHTANK;                    (QuickBASIC 4.5)
'    LINK FISHTANK,,NUL,FGQB;
'
'    BC /Fs /O FISHTANK;                (BASIC PDS 7.x)
'    LINK FISHTANK,,NUL,FGQBX;
'
'    BC /O FISHTANK;                    (Visual Basic for DOS)
'    LINK FISHTANK,,NUL,FGVBDOS;
'
' This program also can be linked with Fastgraph/Light version 4.0 if
' you replace the FGxxx library references with FGLxxx.
'
' For more examples of animation using Fastgraph, or for an evaluation
' copy of Fastgraph/Light, call DDBBS at (702) 796-7134. For Fastgraph
' voice support, call Ted Gruber Software at (702) 735-1980.
'
'***********************************************************************

REM $INCLUDE: 'fastgraf.bi'

DEFINT A-Z

DECLARE SUB GetFish ()
DECLARE SUB GoFish  ()
DECLARE SUB PutFish (FishNum,X,Y,FishDir)

DECLARE FUNCTION MIN (Value1,Value2)
DECLARE FUNCTION MAX (Value1,Value2)

' *** number of fish ***

CONST NFISH = 11

' *** fish bitmaps ***

DIM SHARED Fishes AS STRING*5356
DIM SHARED MapOffset(6), MapSize(6)

' *** palette values ***

DATA 0,1,2,3,4,5,6,7,16,0,18,19,20,21,22,23

' *** arrays containing locations and size of the fish ***

DIM SHARED FishX1(6), FishY1(6), FishWidth(6), FishHeight(6)

'************************************************************************
'*                                                                      *
'*                                 main                                 *
'*                                                                      *
'************************************************************************

REM make sure the system supports video mode 13 with 4 pages

IF FGtestmode(13,4) = 0 THEN
   PRINT
   PRINT "This program requires an EGA or VGA card"
   PRINT "with at least 128k. If an EGA card is"
   PRINT "present, it must be the active adapter."
   STOP
END IF

REM initialize the video environment

OldMode = FGgetmode
FGsetmode 13
FOR PaletteNumber = 0 TO 15
   READ PaletteValue
   FGpalette PaletteNumber, PaletteValue
NEXT
RANDOMIZE TIMER

REM get the coral background from a file and put it on page 2

FGsetpage 2
FGmove 0, 199
Status = FGshowppr("CORAL.PPR"+CHR$(0),320)

REM copy the background from page 2 to page 0, the visual page

FGcopypage 2, 0

REM get the fish

GetFish

REM make the fish go

GoFish

REM restore the original video state

FGsetmode OldMode
FGreset

END

'************************************************************************
'*                                                                      *
'*             GetFish -- fill up the fish bitmap arrays                *
'*                                                                      *
'************************************************************************

SUB GetFish

DIM Temp AS STRING*1224

REM location of fish (x and y)
DATA   0, 64,128,200,  0, 80
DATA 199,199,199,199,150,150

REM size of fish (width and height)
DATA  28, 27, 34, 28, 31, 34
DATA  25, 38, 26, 30, 22, 36

REM fill up the fish location arrays

FOR FishNum = 0 TO 5
   READ FishX1(FishNum)
NEXT
FOR FishNum = 0 TO 5
   READ FishY1(FishNum)
NEXT
FOR FishNum = 0 TO 5
   READ FishWidth(FishNum)
NEXT
FOR FishNum = 0 TO 5
   READ FishHeight(FishNum)
NEXT

REM get the fish from a file and put them on page 1

FGsetpage 1
FGmove 0, 199
Status = FGshowppr("FISH.PPR"+CHR$(0),320)

REM build the fish bitmaps

TotalSize = 1
FOR FishNum = 0 TO 5
   Size = FishWidth(FishNum) * FishHeight(FishNum)
   Offset = TotalSize
   TotalSize = TotalSize + Size
   FGmove FishX1(FishNum), FishY1(FishNum)
   FGgetimage Temp, FishWidth(FishNum), FishHeight(FishNum)
   MID$(Fishes,Offset,Size) = Temp
   MapOffset(FishNum) = Offset
   MapSize(FishNum) = Size
NEXT

END SUB

'************************************************************************
'*                                                                      *
'*             GoFish -- make the fish swim around                      *
'*                                                                      *
'************************************************************************

SUB GoFish

REM There are 11 fish total, and 6 different kinds of fish. These
REM arrays keep track of what kind of fish each fish is, and how each
REM fish moves:

REM Fish()   -- which fish bitmap applies to this fish?
REM X()      -- starting x coordinate
REM Y()      -- starting y coordinate

REM Xmin()   -- how far left (off screen) the fish can go
REM Xmax()   -- how far right (off screen) the fish can go
REM Xinc()   -- how fast the fish goes left and right
REM Dir()    -- starting direction for each fish

REM Ymin()   -- how far up this fish can go
REM Ymax()   -- how far down this fish can go
REM Yinc()   -- how fast the fish moves up or down
REM Yturn()  -- how long fish can go in the vertical direction
REM             before stopping or turning around
REM Ycount() -- counter to compare to yturn

DIM  Fish(NFISH), X(NFISH), Y(NFISH)
DATA    1,   1,   2,   3,   3,   0,   0,   5,   4,   2,   3
DATA -100,-150,-450,-140,-200, 520, 620,-800, 800, 800,-300
DATA   40,  60, 150,  80,  70, 190, 180, 100,  30, 130,  92

DIM  Xmin(NFISH), Xmax(NFISH), Xinc(NFISH), Dir(NFISH)
DATA -300,-300,-800,-200,-200,-200,-300,-900,-900,-900,-400
DATA  600, 600,1100,1000,1000, 750, 800,1200,1400,1200, 900
DATA    2,   2,   8,   5,   5,  -3,  -3,   7,  -8,  -9,   6
DATA    0,   0,   0,   0,   0,   1,   1,   0,   1,   1,   0

DIM  Ymin(NFISH), Ymax(NFISH), Yturn(NFISH), Ycount(NFISH), Yinc(NFISH)
DATA   40,  60, 120,  70,  60, 160, 160,  80,  30, 110,  72
DATA   80, 100, 170, 110, 100, 199, 199, 120,  70, 150, 122
DATA   50,  30,  10,  30,  20,  10,  10,  10,  30,   20, 10

DIM KeyCode AS STRING*1
DIM AuxCode AS STRING*1

REM fill the arrays that control the fish movement

FOR I = 0 TO NFISH-1
   READ Fish(I)
NEXT
FOR I = 0 TO NFISH-1
   READ X(I)
NEXT
FOR I = 0 TO NFISH-1
   READ Y(I)
NEXT
FOR I = 0 TO NFISH-1
   READ Xmin(I)
NEXT
FOR I = 0 TO NFISH-1
   READ Xmax(I)
NEXT
FOR I = 0 TO NFISH-1
   READ Xinc(I)
NEXT
FOR I = 0 TO NFISH-1
   READ Dir(I)
NEXT
FOR I = 0 TO NFISH-1
   READ Ymin(I)
NEXT
FOR I = 0 TO NFISH-1
   READ Ymax(I)
NEXT
FOR I = 0 TO NFISH-1
   READ Yturn(I)
   Ycount(I) = 0
   Yinc(I) = 0
NEXT

REM make the fish swim around

DO
   ' copy the background from page 2 to page 1

   FGcopypage 2, 1

   ' put all the fish on the background

   FOR I = 0 TO NFISH-1

      FGsetpage 1
      Ycount(I) = Ycount(I) + 1
      IF Ycount(I) > Yturn(I) THEN
         Ycount(I) = 0
         Yinc(I) = (RND * 32767) MOD 3 - 1
      END IF
      Y(I) = Y(I) + Yinc(I)
      Y(I) = MIN(Ymax(I),MAX(Y(I),Ymin(I)))

      IF X(I) >= 0 AND X(I) < 320 THEN
         PutFish Fish(I), X(I), Y(I), Dir(I)
      ELSEIF X(I) < 0 AND X(I) > -72 THEN
         FGtransfer 0, 71, 0, 199, 104, 199, 1, 3
         FGsetpage 3
         PutFish Fish(I), X(I)+104, Y(I), Dir(I)
         FGtransfer 104, 175, 0, 199, 0, 199, 3, 1
      END IF
      X(I) = X(I) + Xinc(I)
      IF X(I) <= Xmin(I) OR X(I) >= Xmax(I) THEN
         Xinc(I) = -Xinc(I)
         Dir(I) = 1 - Dir(I)
      END IF
   NEXT

   ' copy page 1 to page 0

   FGsetpage 0
   FGcopypage 1, 0

   ' intercept a keystroke, if it is escape exit the program

   FGintkey KeyCode, AuxCode

LOOP UNTIL KeyCode = CHR$(27)

END SUB

'************************************************************************
'*                                                                      *
'*       PutFish -- draw one of the six fish anywhere you want          *
'*                                                                      *
'************************************************************************

SUB PutFish(FishNum,X,Y,FishDir)

REM move to position where the fish will appear

FGmove X, Y

REM draw a left- or right-facing fish, depending on FishDir

Offset = MapOffset(FishNum)
Size = MapSize(FishNum)

IF FishDir = 0 THEN
   FGflpimage MID$(Fishes,Offset,Size), FishWidth(FishNum), FishHeight(FishNum)
ELSE
   FGclpimage MID$(Fishes,Offset,Size), FishWidth(FishNum), FishHeight(FishNum)
END IF

END SUB

'************************************************************************
'*                                                                      *
'*            min -- determine the smaller of two integer values        *
'*                                                                      *
'************************************************************************

FUNCTION MIN (Value1, Value2)

IF Value1 <= Value2 THEN
  MIN = Value1
ELSE
  MIN = Value2
END IF

END FUNCTION

'************************************************************************
'*                                                                      *
'*            max -- determine the larger of two integer values         *
'*                                                                      *
'************************************************************************

FUNCTION MAX (Value1, Value2)

IF Value1 >= Value2 THEN
  MAX = Value1
ELSE
  MAX = Value2
END IF

END FUNCTION
