/**********************************************************************\
                                                                     
Fontdemo program -- this is a Fastgraph demo program by Diana Gruber 
I created the font file 14pt.fnt in my favorite paint program (dPaint
II enhanced) and used the SNAPSHOT utility to capture it into a packed 
pixel run format.  This program displays the font file and then uses 
the fg_getmap funtion to store the  characters in a mode-independent 
bitmap format.  Normally you would want to do the "get_font" function 
on an off-screen page.

I included some routines to display the characters. Feel free to 
incorporate any of this code in your programs, and give me a call if 
you need technical support. The technical support number is 
(702) 735-1980.                      

to compile and link (Microsoft C):

   cl /c /W3 /AM fontdemo.c
   link /E fontdemo,fontdemo.exe,NUL.MAP,fgm
                                                                      
\**********************************************************************/

#include "fontdemo.h"

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <fastgraf.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#define FALSE 0
#define TRUE  1
#define PTSIZE 14

int old_mode;
int hidden;
int visual;

char *font;
char *pfont;

/* spacing for 14 point proportional spaced characters */

int spacing[] = {
/* !  "  #  $  %  &  '  (  )  *  +  ,  - */
   4, 7, 9, 8,13, 9, 4, 5, 5, 8, 8, 4, 6,

/* .  /  0  1  2  3  4  5  6  7  8  9  : */
   4, 5, 8, 6, 8, 8, 8, 8, 8, 8, 8, 8, 4,

/* ;  <  =  >  ?  @  A  B  C  D  E  F  G */
   4, 8, 8, 8, 8,13,10,10, 9,10, 9, 9,10,

/* H  I  J  K  L  M  N  O  P  Q  R  S  T */
  10, 4, 7, 9, 9,12,10,10,10,10,11, 9,10,

/* U  V  W  X  Y  Z  [  \  ]  ^  _  `  a */
  10,10,16,10,12,11, 5, 6, 5, 7, 9, 6, 8,

/* b  c  d  e  f  g  h  i  j  k  l  m  n */
   8, 8, 8, 8, 5, 8, 8, 4, 4, 8, 4,12, 8,

/* o  p  q  r  s  t  u  v  w  x  y  z  { */
   8, 8, 8, 7, 8, 5, 8,10,12,10,10, 8, 6,

/* |  }  ~ */
   5, 6,12};

/**********************************************************************\
*                                                                      *
*                                 main                                 *
*                                                                      *
\**********************************************************************/

void main()
{
   unsigned char key,aux;

   if (fg_egacheck() != 4) 
   {
      printf("\n");
      printf("This program requires an EGA with 256K \n");
      printf("and an Enhanced Color Display (ECD).\n\n");
      printf("If an EGA is present, it must be the active adapter.\n");
      exit(0);
   }

   init_graphics(16);

   fg_setpage(visual);
   get_font();
   fg_setcolor(15);
   center_pstring("Press any key to continue",0,639,348);
   fg_getkey(&key,&aux);
   if (key == 27)
      quit_graphics();

   fg_setcolor(1);
   fg_rect(0,639,0,349);

   fg_setcolor(15);
   put_pstring("Proportional spaced 14 point font",10,20);
   put_pstring("The quick brown fox jumped over the lazy dog.",10,35);
   put_pstring("Don't you think this is an attractive font?",10,50);

   put_fstring("Fixed pitch 14 point font",10,80);
   put_fstring("Convenient for data entry",10,95);


   put_tstring("ROM text (hardware) font",8,1);
   put_tstring("Characters displayed in fixed character cells",9,1);

   fg_waitkey();
   quit_graphics();
}

/**********************************************************************\
*                                                                      *
*      abort_program -- called when the program can't be run           *
*                                                                      *
\**********************************************************************/

void abort_program()
{
   fg_setmode(old_mode);
   fg_reset();
   printf("\nUnable to execute program.\n");
   exit(0);
}

/**********************************************************************\
*                                                                      *
*  center_pstring -- display proportional characters, centered         *
*                                                                      *
\**********************************************************************/

void center_pstring(string,x1,x2,y)
char *string;
int x1, x2, y;
{
   int x;

   x = get_center(string,x1,x2);
   put_pstring(string,x,y);
}
   
/**********************************************************************\
*                                                                      *
*  center_string -- display fixed-pitch characters, centered           *
*                                                                      *
\**********************************************************************/

void center_string(string,x1,x2,y)
char *string;
int x1, x2, y;
{
   int nchar;
   int x;

   nchar = strlen(string);
   if (nchar == 0) return;

   x = ((x1 + x2) / 2) - (nchar * 4);
   put_fstring(string,x,y);
}

/**********************************************************************\
*                                                                      *
*                   exists -- does the file exist?                     *       
*                                                                      *
\**********************************************************************/

exists(filename)
char *filename;
{
   struct stat buf;
   int status;

   status = stat(filename,&buf);

   if (status == 0)
      return(TRUE);
   else
      return(FALSE);
}

/**********************************************************************\
*                                                                      *
*         final_message  -- colorful exit screen                       *
*                                                                      *
\**********************************************************************/

void final_message()
{
   int color;
   register int column;

   /* some green rectangles */

   fg_setcolor(10);
   fg_rect(0,79,0,4);
   fg_setcolor(2);
   fg_rect(2,77,1,3);

   /* display the string in a single color */

   fg_setattr(15,2,0);
   put_tstring("FONTDEMO program by Diana Gruber",2,25);

   /* change the colors of all the letters */

   color = 9;
   fg_locate(2,25);
   for (column = 25; column < 57; column++)
   {
      fg_setattr(color,2,0);
      fg_chgattr(1);
      color++;
      if (color > 15) color = 9;
   }

   fg_locate(5,0);
   return;
}

/**********************************************************************\
*                                                                      *
*  get_center -- locate center for proportionally-spaced characters    *
*                                                                      *
\**********************************************************************/

get_center(string,x1,x2)
char *string;
int x1, x2;
{
   return(((x1 + x2) / 2) - (length_pstring(string)/ 2));
}

/**********************************************************************\
*                                                                      *
*  get_font -- get the proportional and fixed-pitch character fonts    *
*                                                                      *
\**********************************************************************/

void get_font()
{
   register int i;
   register int index;
   int x, y;
   int yoffset;
   char fontfile[10];

   /* allocate dynamic memory for the fonts; also define font file name */

   font  = malloc(1316);
   pfont = malloc(2632);
   strcpy(fontfile,"14pt.ppr");
   yoffset = 18;

   /* if the allocate failed or the font file isn't present, go no further */

   if (font  == (char *)NULL) abort_program();
   if (pfont == (char *)NULL) abort_program();
   if (!exists(fontfile))     abort_program();

   /* display the 14pt fonts on the hidden page */

   fg_move(0,199);
   fg_dispfile(fontfile,320,1);

   /* retrieve the proportionally spaced and fixed-pitch fonts */

   fg_setcolor(11);
   index = 0;

   for (i = 0; i < 94; i++)
   {
      x = 1 + (i/13) * 16;
      y = yoffset + (i%13) * (PTSIZE+1);
      fg_move(x,y);
      fg_getmap(&pfont[index<<1],2,PTSIZE);
      x = 129 + (i/13) * 9;
      fg_move(x,y);
      fg_getmap(&font[index],1,PTSIZE);
      index += PTSIZE;
   }
}

/**********************************************************************\
*                                                                      *
*      init_graphics -- initialize the graphics environment            *
*                                                                      *
\**********************************************************************/

void init_graphics(mode)
int mode;
{

   /* find out what the old video mode is */

   old_mode = fg_getmode();

   /* new mode is hi-res EGA (640X350) */

   fg_setmode(mode);

   /* set up visual and hidden pages */

   fg_setpage(0);
   fg_setvpage(0);
   fg_sethpage(1);
   visual = 0;
   hidden = 1;   
}

/**********************************************************************\
*                                                                      *
*  length_pstring -- compute the length of a proportional string       *
*                                                                      *
\**********************************************************************/

length_pstring(string)
char *string;
{
   register int i;
   register int nchar;
   int length;
   char ch;

   nchar = strlen(string);
   if (nchar == 0) return(0);

   length = 0;

   for (i = 0; i < nchar; i++)
   {
      ch = string[i] - 33;
      if (ch == -6) /* this is ESC (27-33 = -6) */
         i += 2;
      else if (ch < 0)
         length += 8;
      else
         length += spacing[ch];
   }

   return(length);
}

/**********************************************************************\
*                                                                      *
*  put_fstring -- display fixed-pitch characters                       *
*                                                                      *
\**********************************************************************/

void put_fstring(string,x,y)
char *string;
int x, y;
{
   register int i;
   register int nchar;
   int index;
   char ch;
   
   nchar = strlen(string);
   if (nchar == 0) return;

   for (i = 0; i < nchar; i++)
   {
      ch = string[i] - 33;
      if (ch >= 0)
      {
         index = ch * PTSIZE;
         fg_move(x,y);
         fg_drawmap(&font[index],1,PTSIZE);
      }
      x += 8;
   }
}

/**********************************************************************\
*                                                                      *
*  put_pstring -- display proportionally-spaced characters             *
*                                                                      *
\**********************************************************************/

void put_pstring(string,x,y)
char *string;
int x, y;
{
   register int i;
   register int nchar;
   int index;
   char ch;

   nchar = strlen(string);
   if (nchar == 0) return;

   for (i = 0; i < nchar; i++)
   {
      ch = string[i] - 33;
      if (ch >= 0)
      {
         index = ch * PTSIZE * 2;
         fg_move(x,y);
         fg_drawmap(&pfont[index],2,PTSIZE);
         x += spacing[ch];
      }
      else
         x += 8;
   }
}

/**********************************************************************\
*                                                                      *
*  put_tstring -- display ROM BIOS text                                *
*                                                                      *
\**********************************************************************/

void put_tstring(string,row,col)
char *string;
int row, col;
{
   fg_locate(row,col);
   fg_text(string,strlen(string));
}

/**********************************************************************\
*                                                                      *
*    quit_graphics -- return the computer to its original state        *
*                                                                      *
\**********************************************************************/

void quit_graphics()
{
   fg_setmode(old_mode);
   fg_reset();
   final_message();
   exit(0);
}

