#include <fastgraf.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef __TURBOC__
#include <alloc.h>
#else
#include <malloc.h>
#endif

#define WIDTH  640
#define HEIGHT 400

void main(void);

void main()
{
   int handle;
   int old_mode;
#ifdef FG32
   char *buffer;
#else
   char huge *buffer;
#endif

   /* initialize the video environment */

   fg_initpm();
   old_mode = fg_getmode();
   fg_setmode(19);
   fg_vbinit();

   /* set up a 640x400 virtual buffer */

#ifdef FG32
   buffer = (char *)malloc(WIDTH*HEIGHT);
#elif defined(__TURBOC__)
   buffer = (char huge *)farmalloc((long)WIDTH*(long)HEIGHT);
#else
   buffer = (char huge *)halloc((long)WIDTH*(long)HEIGHT,1);
#endif
   if (buffer == NULL)
   {
      fg_setmode(old_mode);
      fg_reset();
      printf("Could not create the virtual buffer.\n");
      exit(1);
   }
   handle = fg_vbdefine(buffer,WIDTH,HEIGHT);
   fg_vbopen(handle);

   /* draw a 320x200 rectangle in each virtual buffer quadrant */

   fg_setcolor(9);
   fg_rect(0,319,0,199);
   fg_setcolor(10);
   fg_rect(320,639,0,199);
   fg_setcolor(11);
   fg_rect(0,319,200,399);
   fg_setcolor(12);
   fg_rect(320,639,200,399);

   /* paste each rectangle to the 320x200 active video page */

   fg_vbpaste(0,319,0,199,0,199);
   fg_waitkey();
   fg_vbpaste(320,639,0,199,0,199);
   fg_waitkey();
   fg_vbpaste(0,319,200,399,0,199);
   fg_waitkey();
   fg_vbpaste(320,639,200,399,0,199);
   fg_waitkey();

   /* paste the center 320x200 subset of the virtual buffer */

   fg_vbpaste(160,479,100,299,0,199);
   fg_waitkey();

   /* close the virtual buffer */

   fg_vbclose();

   /* restore original video mode and exit */

   fg_setmode(old_mode);
   fg_reset();
}
