program main;
uses fgmain, fgbitmap, fgmisc, fgsvga;

var
  mode, old_mode : integer;
  status         : integer;
  message        : string[5];

begin

{ Ask for the video mode number }

  write('Which video mode? ');
  read(mode);

{ Make sure the entered value is valid }

  if (mode < 0) or (mode > 29) then
  begin
    writeln(mode,' is not a valid video mode number.');
    exit;
  end;

{ Make sure the requested video mode is available }

  fg_initpm;
  if (mode > 23) then status := fg_svgainit(0);
  if (fg_testmode(mode,1) = 0) then
  begin
    writeln('Mode ',mode,' is not available on this system.');
    exit;
  end;

{ Establish the video mode }

  old_mode := fg_getmode;
  fg_setmode(mode);

{ Perform mode-specific initializations }

  if (mode <= 3) or (mode = 7) then     { text modes }
    fg_cursor(0)

  else if (mode = 4) or (mode = 5) then { CGA color modes }
  begin
    fg_palette(0,0);
    fg_defcolor(14,3);
  end

  else if (mode = 6) then      { CGA two-color mode }
  begin
    fg_palette(0,14);
    fg_defcolor(14,1);
  end

  else if (mode = 11) then     { Hercules mode }
    fg_defcolor(14,1)

  else if (mode = 12) then     { Hercules low-res mode }
    fg_defcolor(14,3)

  else if (mode = 17) then     { VGA two-color mode }
  begin
    fg_palette(1,14);
    fg_setrgb(14,63,63,21);
    fg_defcolor(14,1);
  end;

{ Display a message that includes the video mode number }

  fg_setcolor(14);
  fg_text('I''m running in mode ',20);
  str(mode,message);
  message := message + '. ';
  fg_text(message,3);

{ Wait for a keystroke }

  fg_waitkey;

{ Restore the original video mode and screen attributes }

  fg_setmode(old_mode);
  fg_reset;
end.
