program main;
uses fgmain, fgpcx;

var
  i, j : integer;
  mode, status : integer;
  minx, maxx, miny, maxy : integer;
  PCXpal : array [1..768] of byte;
  header : array [1..128] of byte;

begin
  fg_initpm;
  status := fg_pcxhead('CORAL.PCX'+chr(0),header);
  if (status = -1) then
  begin
    writeln('Can''t open CORAL.PCX.');
    exit;
  end
  else if (status = -2) then
  begin
    writeln('CORAL.PCX is not a PCX file.');
    exit;
  end;

  mode := fg_pcxmode(header);
  writeln('Optimal display mode is ',mode,'.');

  fg_pcxrange(header,minx,maxx,miny,maxy);
  writeln('Image size is ',maxx-minx+1,' by ',maxy-miny+1,' pixels.');

  status := fg_pcxpal('CORAL.PCX'+chr(0),PCXpal);
  writeln('First 16 palette values are:');
  j := 1;
  for i := 1 to 16 do
  begin
    writeln('  color ',i:2,': R=',PCXpal[j]:2,' G=',PCXpal[j+1]:2,
      ' B=',PCXpal[j+2]:2);
    j := j + 3;
  end;


end.
