program main;
uses fgmain, fgbitmap, fgmisc;

var
  source : array [1..2560] of byte;
  dest   : array [1..3200] of byte;

begin

  { initialize the video environment }

  fg_initpm;
  fg_setmode(19);

  { draw a blue rectangle with a thick white border }

  fg_setcolor(9);
  fg_rect(0,63,0,39);
  fg_setcolor(15);
  fg_boxdepth(5,5);
  fg_box(0,63,0,39);
  fg_move(32,20);
  fg_justify(0,0);
  fg_print('SHEAR',5);

  { retrieve the rectangle as a mode-specific bitmap }

  fg_move(0,39);
  fg_getimage(source,64,40);
  fg_waitkey;

  { shear the bitmap horizontally and to the right 16 pixels }
  { then display it in the lower left corner of the screen   }

  fg_move(0,199);
  fg_shear(source,dest,64,40,80,1);
  fg_putimage(dest,80,40);
  fg_waitkey;

  { restore 80x25 text mode and exit }

  fg_setmode(3);
  fg_reset;
end.
