program main;
{$IFDEF DPMI}
uses fgmain, fgbitmap, fgmisc, fgvb, WinAPI;
{$ELSE}
{$M 16384,0,16384}
uses fgmain, fgbitmap, fgmisc, fgvb;
{$ENDIF}

var
  handle : integer;
  new_mode, old_mode : integer;
  status : integer;
  buffer : pointer;

begin
  fg_initpm;
  new_mode := fg_bestmode(320,200,1);
  if (new_mode < 0) or (new_mode = 12) then
  begin
    write('This program requires a 320 ');
    writeln('x 200 color graphics mode.');
    exit;
  end;
  old_mode := fg_getmode;
  fg_setmode(new_mode);
  fg_vbinit;

{$IFDEF DPMI}
  buffer := GlobalAllocPtr(gmem_Fixed,Longint(64000));
  if (buffer = NIL) then
  begin
    fg_setmode(old_mode);
    fg_reset;
    writeln('Could not create the virtual buffer.');
    exit;
  end;
  handle := fg_vbdefine(buffer,320,200);
{$ELSE}
  handle := fg_vballoc(320,200);
  if (handle < 0) then
  begin
    fg_setmode(old_mode);
    fg_reset;
    writeln('Could not create the virtual buffer.');
    exit;
  end;
{$ENDIF}
  status := fg_vbopen(handle);

  fg_setcolor(7);
  fg_rect(0,159,0,99);
  fg_setcolor(9);
  fg_locate(6,6);
  fg_text('quadrant',8);

  fg_vbcopy(0,159,0,99,160, 99,handle,handle);
  fg_vbcopy(0,319,0,99,  0,199,handle,handle);
  fg_vbpaste(0,319,0,199,0,199);
  fg_waitkey;

  fg_vbclose;
{$IFDEF dpmi}
  GlobalFreePtr(buffer);
{$ELSE}
  fg_vbfree(handle);
{$ENDIF}
  fg_setmode(old_mode);
  fg_reset;
end.
