$INCLUDE: 'C:\FG\FASTGRAF.FI'

      PROGRAM MAIN

      INTEGER DELAY, Y
      INTEGER FG_MEASURE

C   Initialize the video environment

      CALL FG_INITPM
      CALL FG_SETMODE(20)

C   Define a processor-dependent panning delay

      DELAY = FG_MEASURE() / 16

C   Draw a blue box with a white border on page 1

      CALL FG_SETPAGE(1)
      CALL FG_SETCOLOR(9)
      CALL FG_FILLPAGE
      CALL FG_SETCOLOR(15)
      CALL FG_BOX(0,319,0,199)
      CALL FG_MOVE(160,100)
      CALL FG_JUSTIFY(0,0)
      CALL FG_PRINT('This is page 1',14)

C   Display what we just drew on page 1

      CALL FG_SETVPAGE(1)
      CALL FG_WAITKEY

C   Draw a red hollow box at the top of page 0 (now invisible)

      CALL FG_SETPAGE(0)
      CALL FG_SETCOLOR(12)
      CALL FG_BOX(0,319,0,19)
      CALL FG_SETCOLOR(15)
      CALL FG_MOVE(160,10)
      CALL FG_PRINT('SPLIT SCREEN',12)

C   Activate the split screen environment, making the first 20 lines  
C   of page 0 appear at the bottom of the screen, and making the first
C   180 lines of page 1 appear at the top                             

      CALL FG_SPLIT(180)
      CALL FG_WAITKEY

C   Pan upward in one-line increments, displaying the rest of page 1

      CALL FG_SETPAGE(1)
      DO 10 Y = 0,20
         CALL FG_PAN(0,Y)
         CALL FG_STALL(DELAY)
10    CONTINUE
      CALL FG_WAITKEY

C   Pan back down in one-line increments to the original position

      DO 20 Y = 20,0,-1
         CALL FG_PAN(0,Y)
         CALL FG_STALL(DELAY)
20    CONTINUE
      CALL FG_WAITKEY

C   Restore 80x25 text mode and exit

      CALL FG_SETMODE(3)
      CALL FG_RESET

      STOP ' '
      END
