/**********************************************************************\
*                                                                      *
*            xmas.c ---  Merry Christmas to everybody!!!               *
*                                                                      *
\**********************************************************************/

#include "xmas.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <fastgraf.h>

#define OK       1

int seed;
int hidden;
int visual;

int flakex[900];
int flakey[900];

char string[2500];

char jingle[]=
"T255O5L4CAGFL2CL8CCL4CAGFL2D.L4P"
"L4DA#AGL2E.L4PO+CCO-A#GL2A.L4P"
"L4CAGFL2C.L8L4PCAGFL2DL4PD"
"DA#AGO+CCCCDCO-A#GL2F.L4P"
"AAL2AL4AAL2AL4AO+CO-F.L8GL2A.L4P"
"A#A#A#.L8A#L4A#AAL8AAL4AGGAL2GO+CO-"
"L4AAL2AL4AAL2AL4AO+CO-F.L8GL2A.L4P"
"A#A#A#.L8A#L4A#AAL8AAL4O+CCO-A#GL2F.L1P";

char silent[] =
"T150O3S0L4G.L8S1AL4GL2E.S0L4G."
"L8AS1L4GL2E.O+DL4DL2O-B.O+CL4CL2O-G.AL4AO+S0C."
"O-L8BS+L4AG.L8AL4GL2E.AL4AO+C.O-L8BL4AG.L8AL4GL2E.O+DL4DF.L8D"
"L4O-BL2O+S0C.E.S1L4C.O-L8GL4EG.L8FL4D L1 0- CP";

char tree[] =
"T100O3O-L4CL8F.L16FL4FGL8A.L16AL4A.L8AGAL4A#EGFC"
"L8F.L16FL4FGL8A.L16AL4A.L8AGAL4A#EGF.O+L8C"
"CO-AO+L4D.L8CCO-A#L4A#.L8A#A#GL4O+C.L8O-A#A#AL4AC"
"L8F.L16FL4FGL8A.L16AL4A.L8AGAL4A#EGFL1P";

char child[] =
"T80O3L8GL4A#L8O+CD.L16D#L8DL4CO-L8AF."
"L16GL8AL4A#L8GG.L16F#L8GL4AL8F#L4DL8G"
"L4A#L8O+CD.L16D#L8DL4CL8O-AF.L16GL8AL8A#.L16AL8GF#."
"L16EL8F#L4G.G.O+F.L8F.L16EL8DL4CO-L8AF.L16G"
"L8AL4A#L8GG.L16F#L8GL4AL8F#L4D.L4O+F.L8F."
"L16EL8DL4CO-L8AL8F.L16GL8AA#.L16AL8G"
"L8F#.L16EL8F#L4G.G.L1P";

char manger[] =
"T150O3L4DD.L8CL4O-BBAGGF#EL2DL4D"
"D.L8EL4DDAF#EDGL2BO+L4D"
"L4D.L8CL4O-BS0BS1AGGF#EL2DL4D"
"L4O+C.O-L8BL4ABAGAEF#L2GL1P"
"T150O3L4DD.L8CL4O-BBAGGF#EL2DL4D"
"D.L8EL4DDAF#EDGL2BO+L4D"
"L4D.L8CL4O-BS0BS1AGGF#EL2DL4D"
"L4O+C.O-L8BL4ABAGAEF#L2GL1P$";

/**********************************************************************\
*                                                                     *
*                                 main                                 *
*                                                                      *
\**********************************************************************/

int colors[] = {0,46,2,3,12,5,20,7,56,57,58,59,60,61,62,63};

void main()
{
   unsigned char key,aux;
   int i,j;
   int index;

   if (fg_egacheck() != 4) 
   {
      printf("\n");
      printf("This program requires an EGA with 256K \n");
      printf("and an enhanced color display (ECD).\n\n");
      printf("If an EGA is present, it must be the active adaptor.\n");
      exit(0);
   }

   init_graphics();
   fg_palettes(colors);

   fg_setpage(visual);
   fg_waitfor(1);

   strcpy(string,jingle);
   strcat(string,silent);
   strcat(string,tree);
   strcat(string,child);
   strcat(string,manger);

   fg_move(0,349);
   fg_dispfile("xmas.ppr",640,1);

   fg_transfer(0,639,0,349,0,349,visual,hidden);

   index = 0;
   for (i = 0; i < 175; i++)
   {
      for (j = 0; j < 5; j++)
      {
         flakex[index] = j * 104+irandom(0,104);
         flakey[index] = -2*i;
         index++;
      }
   }

   for (i = 0; i < 200; i+=2)
      flakey[i] -= 350;

   for (i = 0; i < 400; i+=3)
      flakey[i] -= 350;

   for (i = 1; i < 875; i+=4)
      flakey[i] -= 350;

   fg_setpage(visual);
   fg_setcolor(15);
   fg_move(0,365);

   fg_waitfor(18);

   while(1)
   {
      fg_intkey(&key,&aux);
      if (key == 27)
         quit_graphics(); 

      if (fg_numlock()) 
      {
         if (fg_playing())
             fg_hush();
      }
      else 
      {  
         if (!fg_playing())
            fg_musicb(string,-1);
      }

      for (i = 0; i < 875; i++)
      {
         if (flakey[i] > 0)
            fg_restore(flakex[i],flakex[i]+1,flakey[i],flakey[i]+1);

         flakex[i] += irandom(-1,1);
         if (flakex[i] > 518) 
            flakex[i] = 2;
         else if (flakex[i] < 0) 
            flakex[i] =518;

         flakey[i] += irandom(0,3);
         if (flakey[i] > 349) 
            flakey[i] = -350;

         if (flakey[i] > 0)
            fg_rect(flakex[i],flakex[i]+1,flakey[i],flakey[i]+1);
      }
   }
}

/**********************************************************************\
*                                                                      *
*      init_graphics -- initialize the graphics environment            *
*                                                                      *
\**********************************************************************/

init_graphics()
{

   /* set mode to high-res EGA (640X350) */

   fg_setmode(16);

   /* set up visual and hidden pages */

   fg_setpage(0);
   fg_setvpage(0);
   fg_sethpage(1);

   visual = 0;
   hidden = 1;   

   fg_setnum(0);
   getseed();

   return(OK);
}

/**********************************************************************\
*                                                                      *
*    quit_graphics -- return the computer to its original state        *
*                                                                      *
\**********************************************************************/

void quit_graphics()
{

   /* turn off the music */

   fg_hush();

   /* set the mode to whatever it was originally */

   fg_setmode(3);

   /* if screen attributes were set, reset them and clear the screen*/

   fg_reset();
   exit(0);
}

/**********************************************************************\
*                                                                      *
*        getseed -- get a seed for the random number generator         *
*                                                                      *
\**********************************************************************/

getseed()
{
   long fg_getclock();

   seed = (int)(fg_getclock() & 0x7FFF);
   return(OK);
}

/**********************************************************************\
*                                                                      *
*              irandom -- Ted's random number generator                *
*                                                                      *
\**********************************************************************/

irandom(min,max)
int min;
int max;
{
   int temp;

   temp = seed ^ (seed >> 7);
   seed = ((temp << 8) ^ temp) & 0x7FFF;
   return((seed % (max-min+1)) + min);
}


