/************************************************************************
 Source code of an attempt to create the melting screen ala DOOM.
 It looks like a melting screen except it shrinks the screen towards
 the bottom.
 I am cheating and using FASTGRAPH to set the video mode and allocate
 extra pages. It would be easy to call an interrupt to set the mode and
 malloc to allocate the pages.

 Send any comments to;
 John Gonzalez
 71414,1353
*************************************************************************/
#include <conio.h>
#include <dos.h>
#include <stdlib.h>
#include <time.h>

#include "fastgraf.h"


#define SCREENWIDTH	320
#define SCREENHEIGHT	200

void Scale(unsigned int column,unsigned int destheight,unsigned int ypos,
	   unsigned char *frompage,unsigned char *topage);

int height[SCREENWIDTH / 4];
unsigned int screen_offset[SCREENHEIGHT];

main()
{ unsigned int i, j, k, a;
  char *vpage, *hpage1, *hpage2;
  randomize();

  /* Initialize height array with 1 to avoid division by 0 */
  for(i= 0;i < SCREENWIDTH / 4;i++)
    height[i]= 1;

  /* Initialize screen offset table */
  for(i= 0;i < SCREENHEIGHT;i++)
    screen_offset[i]= i * SCREENWIDTH;

  /* Set mode 19 */
  fg_setmode(19);

  /* Allocate a page, read in a pcx and create a far pointer to it */
  fg_allocate(1);
  fg_setpage(1);
  if(fg_showpcx("first.pcx",0))
    { fg_freepage(1);
      exit(1);
    };
  hpage1= MK_FP(fg_getaddr(),0);

  /* Again */
  fg_allocate(2);
  fg_setpage(2);
  if(fg_showpcx("second.pcx",0))
    { fg_freepage(1);
      fg_freepage(2);
      exit(2);
    };
  hpage2= MK_FP(fg_getaddr(),0);

  /* Make a pointer to the visual page */
  fg_setpage(0);
  vpage= MK_FP(fg_getaddr(),0);

  while(!kbhit())
    { for(j= 0;j < SCREENWIDTH / 4;j++)
	{
	  /* This section updates the top of the screen */
	  a= j * 4;
	  k= height[j];
	  while(k--)
	    { vpage[a]= hpage2[a++];
	      vpage[a]= hpage2[a++];
	      vpage[a]= hpage2[a++];
	      vpage[a]= hpage2[a];
	      a+= SCREENWIDTH - 3;
	    };

	  /* Now do the scaling */
	  Scale(j * 4,199 - height[j],height[j],hpage1,vpage);
	};
      for(j= 0;j < SCREENWIDTH / 4;j++)
	if(height[j] < 199) height[j]+= rand() % 8 + 4;
    };

  /* free pages */
  fg_freepage(1);
  fg_freepage(2);
  fg_setmode(3);
};

void Scale(unsigned int column,unsigned int destheight,unsigned int ypos,
	   unsigned char *frompage,unsigned char *topage)
{ unsigned int yratio, y= 0, offset;
  if(ypos > SCREENHEIGHT - 1 || destheight == 0) return;
  yratio= (SCREENHEIGHT << 8) / destheight; /* 8.8 */
  topage+= screen_offset[ypos] + column;
  while(destheight--)
    { offset= screen_offset[y >> 8] + column;
      *topage++= *(frompage + offset++);
      *topage++= *(frompage + offset++);
      *topage++= *(frompage + offset++);
      *topage= *(frompage + offset);
      topage+= SCREENWIDTH - 3;
      y+= yratio;
    };
};
