/****************************************************************************
 Program Name: mkf.c
 Author: G.T. Sanford III                   wk (615)885-9727
         7616 Nolensville Road              hm (615)776-2397
         Nolensville, TN  37135
 Copyright (c) February 1993
-----------------------------------------------------------------------------
 Description:   Fastgraph Font File Editor

                Preliminary version. Edits existing files only.

-----------------------------------------------------------------------------

                 M O D I F I C A T I O N    H I S T O R Y 

  Date    By    Modification
--------  ---  --------------------------------------------------------------



-------------------------- ALL RIGHTS RESERVED ------------------------------
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fastgraf.h>

#define GRID_X      64
#define GRID_Y      48
#define MIN_X      300
#define MAX_X      620
#define MIN_Y       20
#define MAX_Y      260
#define HIDE         1
#define SHOW         0
#define ON           1
#define OFF          0
#define NUM_ARROWS   4

typedef struct
{
   unsigned char MAXI_X;
   unsigned char MAXI_Y;
   unsigned char X_SIZES[ 96 ];
   unsigned char Y_SIZES[ 96 ];
}  FONT_HEADER;

FONT_HEADER fhdr;
unsigned char letters[ 96 ][ 384 ];      // maximum size
FILE * fptr;
char filename[ 65 ];
int  bitmapsize;
char buffer[ 81 ];
int  colarray[ 65 ];
int  rowarray[ 49 ];
int  CURRENT_CHAR_COL = -1;
int  CURRENT_CHAR_ROW = -1;
int  NEW_CHAR_COL = -1;
int  NEW_CHAR_ROW = -1;
int  loffset = -1;
int  GRID_ON = 1;
int  MADE_CHANGES = 0;

int arrows[ NUM_ARROWS ][ 3 ] =
{
   { 294,  20, 0 },
   { 294,  90, 0 },
   { 300,  14, 1 },
   { 340,  14, 1 }
};


/****************************************************************************
    G_SETCURS
   draw new cursor
   Supports 640 x 350 and 640 x 480
****************************************************************************/

void g_setcurs( int x, int y )
{
   int oldcolor;
   int ph = 14;                     // y == 350

   if ( fg_getmaxy() == 479 )       // y == 480
      ph = 16;

   oldcolor = fg_getcolor();

   fg_setcolor( 15 );
   fg_move( (y*8), ((x*ph)+(ph-1)) );
   fg_draw( ((y*8)+7), ((x*ph)+(ph-1)) );

   if ( *(char far *)0x400017 & 0x80 )      // Insert is on
   {
      fg_move( (y*8), ((x*ph)+(ph-2)) );
      fg_draw( ((y*8)+7), ((x*ph)+(ph-2)) );
   }

   fg_setcolor( oldcolor );
   return;
}
/*--- end of g_setcurs() --------------------------------------------------*/




/****************************************************************************
    G_SAYAT
   Put a string in graphics video with appropriate colors
   Supports 640 x 350 and 640 x 480
****************************************************************************/

void g_sayat( int row, int col, char * string, unsigned char attr )
{
   int len, oldcolor;
   int ph = 14;                    // y == 350

   if ( fg_getmaxy() == 479 )      // y == 480
      ph = 16;

   len = (int)strlen( string );
   oldcolor = fg_getcolor();
   fg_setcolor( (attr>>4) );
   fg_rect( (col*8), (((col+len)*8)-1), (row*ph), ((row*ph)+(ph-1)) );
   fg_setcolor( (attr & 0x0F) );
   fg_locate( row, col );
   fg_text( string, len );
   fg_setcolor( oldcolor );

   return;
}
/*--- end of g_sayat() ----------------------------------------------------*/




/****************************************************************************
    TRIM
   Remove trailing spaces
****************************************************************************/

char * trim( char * string )
{
   int length;

   length = strlen( string ) -1;
   if ( string[ length ] != ' ' )           // string already trimmed
      return( string );
   while ( string[ length ] == ' ' && length >= 0 ) 
      --length;                      // If char is ' ', decrement and retest

   string[ (length + 1) ] = '\0';    // terminate

   return( string );
}
/*--- end of trim() -------------------------------------------------------*/




/****************************************************************************
    DO_ARROW
   Draw the marker arrows and lines
****************************************************************************/

void do_arrow( int i, int how )
{
   if ( how )
      fg_setcolor( 9 );
   else
      fg_setcolor( 15 );

   fg_move( arrows[ i ][ 0 ], arrows[ i ][ 1 ] );
   if ( arrows[ i ][ 2 ] )    // vert
   {
      fg_draw( arrows[ i ][ 0 ], arrows[ i ][ 1 ]+4 );
      fg_point( arrows[ i ][ 0 ]-1, arrows[ i ][ 1 ]+3 );
      fg_point( arrows[ i ][ 0 ]+1, arrows[ i ][ 1 ]+3 );
      // vertical marker line:
      if ( how )
      {
         if ( GRID_ON )
            fg_setcolor( 7 );
         else
            fg_setcolor( 9 );
      }
      else
         fg_setcolor( 12 );
      fg_move( arrows[ i ][ 0 ], MIN_Y );
      fg_draw( arrows[ i ][ 0 ], MAX_Y );
   }
   else                       // horiz
   {
      fg_draw( arrows[ i ][ 0 ]+4, arrows[ i ][ 1 ] );
      fg_point( arrows[ i ][ 0 ]+3, arrows[ i ][ 1 ]-1 );
      fg_point( arrows[ i ][ 0 ]+3, arrows[ i ][ 1 ]+1 );
      // horizontal marker line:
      if ( how )
      {
         if ( GRID_ON )
            fg_setcolor( 7 );
         else
            fg_setcolor( 9 );
      }
      else
         fg_setcolor( 12 );
      fg_move( MIN_X, arrows[ i ][ 1 ] );
      fg_draw( MAX_X, arrows[ i ][ 1 ] );
   }

   return;
}
/*--- end of do_arrow() ---------------------------------------------------*/




/****************************************************************************
    MOVE_ARROW
   As long as the left button is held down, we will continue to update
   either the x or y coordinate of the arrow being held, within limits.
****************************************************************************/

void move_arrow( int i )
{
   int mx, my, buttons;
   int oldmx, oldmy, j;

   while ( 1 )
   {
      fg_mousepos( &mx, &my, &buttons );

      if ( buttons == 0 )            // button released
         break;

      if ( mx != oldmx || my != oldmy )
      {
         sprintf( buffer, "%3d - %3d", mx, my );
         g_sayat( 0, 0, buffer, (char)0x9F );
      }

      if ( arrows[ i ][ 2 ] )          // vert
      {
         if ( mx >= MIN_X && mx <= MAX_X )
         {
            if ( mx != oldmx )
            {
               fg_mousevis( OFF );
               do_arrow( i, HIDE );
               j = mx % 5;
               arrows[ i ][ 0 ] = mx-j;
               do_arrow( i, SHOW );
               fg_mousevis( ON );
            }
         }
      }
      else                             // horiz
      {
         if ( my >= MIN_Y && my <= MAX_Y )
         {
            if ( my != oldmy )
            {
               fg_mousevis( OFF );
               do_arrow( i, HIDE );
               j = my % 5;
               arrows[ i ][ 1 ] = my-j;
               do_arrow( i, SHOW );
               fg_mousevis( ON );
            }
         }
      }
      oldmx = mx;
      oldmy = my;
   }

   return;
}
/*--- end of move_arrow() -------------------------------------------------*/




/****************************************************************************
    DRAW_GRID
   Put the character grid on the screen
****************************************************************************/

void draw_grid( void )
{
   int i, j, mx, my, dx, dy;

   fg_setcolor( 0 );
   fg_rect( 200, 265, 20, 69 );           // actual size box

   fg_setcolor( 9 );
   fg_rect( MIN_X, MAX_X, MIN_Y, MAX_Y );          // clear grid area

   fg_setcolor( 7 );
   mx = MIN_X;
   my = MIN_Y;
   dy = MAX_Y;
   fg_move( mx, my );
   for ( i = 0; i <= GRID_X; i++ )        // draw vertical
   {
      colarray[ i ] = mx;                 // load array as we go
      if ( GRID_ON )
         fg_draw( mx, dy );
      mx += 5;
      fg_move( mx, my );
   }

   mx = MIN_X;
   my = MIN_Y;
   dx = MAX_X;
   fg_move( mx, my );
   for ( i = 0; i <= GRID_Y; i++ )        // draw horizontal
   {
      rowarray[ i ] = my;                 // load array as we go
      if ( GRID_ON )
         fg_draw( dx, my );
      my += 5;
      fg_move( mx, my );
   }

   fg_setcolor( 15 );

   for ( i = 0; i < NUM_ARROWS; i++ )       // little arrows in the air...
   {
      do_arrow( i, SHOW );
   }

   return;
}
/*--- end of draw_grid() --------------------------------------------------*/




/****************************************************************************
    AT_ARROW
   Is the mouse at one of the little arrows when the left button was pressed?
****************************************************************************/

int at_arrow( int mx, int my )
{
   int i;

   for ( i = 0; i < NUM_ARROWS; i++ )
   {
      if ( mx >= arrows[ i ][ 0 ]-3 && mx <= arrows[ i ][ 0 ]+3 )
      {
         if ( my >= arrows[ i ][ 1 ]-3 && my <= arrows[ i ][ 1 ]+3 )
         {
            return( i );
         }
      }
   }

   return( -1 );
}
/*--- end of at_arrow() ---------------------------------------------------*/




/****************************************************************************
    SAVE_GRID
   Install the current letter in the screen grid to the letter array
****************************************************************************/

void save_grid( void )
{
   int i, j, k, x, y, nb;
   int row, col;
   int count;

   if ( loffset < 0 )
      return;

   col = 0;
   x = (int)fhdr.X_SIZES[ loffset ];
   y = (int)fhdr.Y_SIZES[ loffset ];

   // actual number of bytes for this letter
   if ( x >  0 && x <  8 )
      nb = 1;
   if ( x >=  8 && x < 16 )
      nb = 2;
   if ( x >= 16 && x < 24 )
      nb = 3;
   if ( x >= 24 && x < 32 )
      nb = 4;
   if ( x >= 32 && x < 40 )
      nb = 5;
   if ( x >= 40 && x < 48 )
      nb = 6;
   if ( x >= 48 && x < 56 )
      nb = 7;
   if ( x >= 56 && x < 64 )
      nb = 8;

   for ( row = 0; row < y;  )
   {
      for ( j = 0; j < nb; j++ )
      {
         count = 128;
         for ( k = 0; k < 8; k++ )
         {
            if ( fg_getpixel( colarray[ col ]+1, rowarray[ row ]+1 ) == 15 )
            {
               letters[ loffset ][ ((row*nb)+j) ] |= count;  // turn on bit
            }
            else
            {
               letters[ loffset ][ ((row*nb)+j) ] &= ~count;  // turn off bit
            }
            count /= 2;
            col++;
         }
      }
      row++;
      col = 0;
      if ( row > y )
         break;
   }

   return;
}
/*--- end of save_grid() --------------------------------------------------*/




/****************************************************************************
    LOAD_GRID
   Install the current letter into the screen grid
****************************************************************************/

void load_grid( void )
{
   int i, j, k, x, y, nb;
   int row, col;
   int count;

   col = 0;
   x = (int)fhdr.X_SIZES[ loffset ];
   y = (int)fhdr.Y_SIZES[ loffset ];

   sprintf( buffer, "%2d x %2d", x, y );
   g_sayat( 5, 26, buffer, 0x1F );

   // actual number of bytes for this letter
   if ( x >  0 && x <  8 )
      nb = 1;
   if ( x >=  8 && x < 16 )
      nb = 2;
   if ( x >= 16 && x < 24 )
      nb = 3;
   if ( x >= 24 && x < 32 )
      nb = 4;
   if ( x >= 32 && x < 40 )
      nb = 5;
   if ( x >= 40 && x < 48 )
      nb = 6;
   if ( x >= 48 && x < 56 )
      nb = 7;
   if ( x >= 56 && x < 64 )
      nb = 8;

   fg_mousevis( OFF );
   for ( i = 0; i < (fhdr.MAXI_X*8); i++ )       // clear current letter
   {
      for ( j = 0; j < fhdr.MAXI_Y; j++ )
      {
         fg_setcolor( 9 );
         if ( GRID_ON )
            fg_rect( colarray[ i ]+1, colarray[ i ]+4, rowarray[ j ]+1, rowarray[ j ]+4 );
         else
            fg_rect( colarray[ i ], colarray[ i ]+4, rowarray[ j ], rowarray[ j ]+4 );
         fg_setcolor( 0 );
         fg_point( 201+i, 21+j );
      }
   }

   for ( row = 0; row < y; row++ )
   {
      for ( j = 0; j < nb; j++ )
      {
         count = 128;
         for ( k = 0; k < 8; k++ )
         {
            if ( letters[ loffset ][ ((row*nb)+j) ] & count )
            {
               fg_setcolor( 15 );
               if ( GRID_ON )
                  fg_rect( colarray[ col ]+1, colarray[ col ]+4, rowarray[ row ]+1, rowarray[ row ]+4 );
               else
                  fg_rect( colarray[ col ], colarray[ col ]+4, rowarray[ row ], rowarray[ row ]+4 );
               fg_point( 201+col, 21+row );
            }
            count /= 2;
            col++;
         }
      }
      col = 0;
   }

   // adjust arrows and marker lines to reflect the new letter:
   do_arrow( 1, HIDE );
   do_arrow( 3, HIDE );
   arrows[ 1 ][ 1 ] = ( fhdr.Y_SIZES[ loffset ] * 5 ) + MIN_Y;
   arrows[ 3 ][ 0 ] = ( fhdr.X_SIZES[ loffset ] * 5 ) + MIN_X;
   do_arrow( 1, SHOW );
   do_arrow( 3, SHOW );

   fg_mousevis( ON );

   return;
}
/*--- end of load_grid() --------------------------------------------------*/




/****************************************************************************
    FIND_COLUMN
   Locate the column of the new letter display request
****************************************************************************/

int find_column( int mx )
{
   int col, st, i;

   col = 0;
   for ( st = 75, i = 0; st <= 587 ; st += 16, i++ )
   {
      if ( mx >= st && mx < st+16 )
      {
         col = st+1;
         NEW_CHAR_COL = i;
         break;
      }
   }

   return( col );
}
/*--- end of find_column() ------------------------------------------------*/




/****************************************************************************
    ERASE_CURRENT
   Un-hilite the currently hi-lited letter
****************************************************************************/

void erase_current( void )
{
   int i, x, y;

   if ( CURRENT_CHAR_COL == -1 )
      return;

   x = 76 + ( CURRENT_CHAR_COL * 16 );

   switch ( CURRENT_CHAR_ROW )
   {
      case 0:
         y = 316;
         break;
      case 1:
         y = 344;
         break;
      case 2:
         y = 376;
         break;
   }

   fg_setcolor( 9 );
   fg_paint( x, y );
   fg_setcolor( 15 );

   return;
}
/*--- end of erase_current() ----------------------------------------------*/




/****************************************************************************
    SET_NEW
   Hilite the newly requested letter
****************************************************************************/

int set_new( int x, int row )
{
   int y;
   char ch[ 2 ];

   if ( loffset >= 0 )
      save_grid();

   switch ( row )
   {
      case 0:
         y = 316;
         NEW_CHAR_ROW = 0;
         ch[ 0 ] = (char)( NEW_CHAR_COL+32 );
         loffset = NEW_CHAR_COL;
         break;
      case 1:
         y = 344;
         NEW_CHAR_ROW = 1;
         ch[ 0 ] = (char)( NEW_CHAR_COL+64 );
         loffset = ( NEW_CHAR_COL+32 );
         break;
      case 2:
         y = 376;
         NEW_CHAR_ROW = 2;
         ch[ 0 ] = (char)( NEW_CHAR_COL+96 );
         loffset = ( NEW_CHAR_COL+64 );
         break;
   }

   if ( loffset < 0 )
      loffset = 0;

   CURRENT_CHAR_COL = NEW_CHAR_COL;
   CURRENT_CHAR_ROW = NEW_CHAR_ROW;

   fg_setcolor( 12 );
   fg_paint( x, y );

   ch[ 1 ] = '\0';
   g_sayat( 2, 22, ch, (char)0x0F );
   fg_setcolor( 15 );

   load_grid();

   return( 0 );
}
/*--- end of set_new() ----------------------------------------------------*/




/****************************************************************************
    G_GETKEY
   Get a key from the keyboard
****************************************************************************/

int g_getkey( void )
{
   unsigned char key;
   unsigned char aux;

   fg_getkey( &key, &aux );

   if ( aux == 0 )
      return( (int)key );
   else
      return( (int)(aux+256) );          // all extended keys will be > 256
}
/*--- end of g_getkey() ---------------------------------------------------*/




/****************************************************************************
    G_SMGETS
   Input the font file name
   ( This is a greatly simplified version of natgets() )
****************************************************************************/

int g_smgets( int row, int scol, char * string, char * mask, int * chg, int pct )
{
   int i, col, slen;
   int ch;
   char disp_buff[ 81 ];

   col = scol;
   slen = (signed int)strlen( mask );
   i = (signed int)strlen( string );
   while ( i < slen )
      string[ i++ ] = ' ';
   memcpy( disp_buff, string, slen );
   disp_buff[ slen ] = 0;
   string[ slen ] = 0;
   i = 0;

   while ( 1 )
   {
      g_sayat( row, scol, disp_buff, 0x4E );
      g_setcurs( row, col );
      ch = toupper( g_getkey() );
      switch ( ch )
      {
         case 27:                           // ESCape
         case 13:                           // Enter
            goto finished;
         case 8:                            // backspace
            if ( col > scol )
            {
               col--;
               string[ --i ] = ' ';
               disp_buff[ i ] = ' ';
            }
            break;
         case 333:                          // right arrow
            if ( col < ((scol+slen)-1) )
            {
               col++;
               i++;
            }
            break;
         case 331:                          // left arrow
            if ( col > scol )
            {
               col--;
               i--;
            }
            break;
         default:
            if ( i < slen )
            {
               if ( isprint( ch ) )
               {
                  disp_buff[ i ] = ch;
                  string[ i++ ] = ch;
                  col++;
               }
            }
            break;
      }
   }

   finished:

   return( ch );
}
/*--- end of g_smgets() ---------------------------------------------------*/




/****************************************************************************
    LOAD_FONT
   Load the requested font file
****************************************************************************/

void load_font( void )
{
   int result, i;
   char * chp;

   erase_current();

   g_sayat( 17,  1, "Current Font: ", 0x17 );
   while ( 1 )
   {
      result = g_smgets( 17, 15, filename, "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", &i, 0 );

      trim( filename );
      chp = strchr( filename, '.' );
      if ( chp != NULL )                   // found '.'
         memset( chp, '\0', 4 );
      strcat( filename, ".FGF" );
      g_sayat( 17, 15, "                                        ", 0x99 );
      g_sayat( 17, 15, filename, 0x0A );

      fptr = fopen( filename, "rb" );
      if ( fptr == NULL )
      {
         sprintf( buffer, "Cannot find %s", filename );
         g_sayat( 27, 10, buffer, 0x4F );
         fg_waitfor( 48 );
         fg_setcolor( 9 );
         fg_rect( 80, 640, 432, 448 );        // clear error message
         fg_setcolor( 15 );
      }
      else
         break;
   }

   fread( &fhdr, sizeof( char ), sizeof( fhdr ), fptr );

   // adjust arrows and marker lines to reflect this new font:
   do_arrow( 1, HIDE );
   do_arrow( 3, HIDE );
   arrows[ 1 ][ 1 ] = ( fhdr.MAXI_Y * 5 ) + MIN_Y;
   arrows[ 3 ][ 0 ] = ( (fhdr.MAXI_X * 8) * 5 ) + MIN_X;
   do_arrow( 1, SHOW );
   do_arrow( 3, SHOW );
   
   bitmapsize = (int)((int)fhdr.MAXI_X * (int)fhdr.MAXI_Y);

   for ( i = 0; i < 96; i++ )       // load each character
      fread( &letters[ i ], sizeof( char ), bitmapsize, fptr );

   fclose( fptr );

   loffset = -1;
   CURRENT_CHAR_COL = -1;
   CURRENT_CHAR_ROW = -1;
   NEW_CHAR_COL = -1;
   NEW_CHAR_ROW = -1;
   MADE_CHANGES = 0;

   return;
}
/*--- end of load_font() --------------------------------------------------*/




/****************************************************************************
    SAVE_FONT
   Save the modified font file
****************************************************************************/

void save_font( void )
{
   int i, ok = 0;
   int mx, my, buttons;
   int result;
   char * chp;

   if ( filename[ 0 ] == ' ' || filename[ 0 ] == '\0' )
   {
      g_sayat( 17,  1, "Current Font: ", 0x17 );
      result = g_smgets( 17, 15, filename, "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", &i, 0 );
      trim( filename );
      chp = strchr( filename, '.' );
      if ( chp != NULL )
         memset( chp, '\0', 4 );
      strcat( filename, ".FGF" );
      g_sayat( 17, 15, "                                        ", 0x99 );
      g_sayat( 17, 15, filename, 0x9F );
   }

   if ( access( filename, 0 ) == 0 )      // file exists
   {
      sprintf( buffer, " %s Already Exists, Overwrite? ", trim( filename ) );
      g_sayat( 27, 10, buffer, 0x4F );

      fg_setcolor( 1 );
      fg_rect( 140, 220, 104, 136 );
      fg_rect( 140, 220, 140, 172 );
      fg_setcolor( 7 );
      fg_box( 140, 220, 104, 136 );
      fg_box( 140, 220, 140, 172 );
      g_sayat( 7, 18, "Overwrite", 0x1F );
      g_sayat( 9, 18, " Cancel", 0x1F );

      fg_sound( 800, 6 );
      fg_sound( 400, 6 );
      fg_mousemov( 180, 156 );
      fg_mousevis( ON );

      while ( 1 )
      {
         fg_mousepos( &mx, &my, &buttons );
         if ( buttons == 0x01 )        // left button
         {
            if ( mx >= 140 && mx <= 220 )
            {
               if ( my >= 104 && my <= 136 )     // overwrite
               {
                  ok = 1;
                  break;
               }
               if ( my >= 140 && my <= 172 )     // cancel
               {
                  ok = 0;
                  break;
               }
            }
         }
      }
   }

   fg_mousevis( OFF );
   fg_setcolor( 9 );
   fg_rect( 80, 640, 432, 448 );        // clear error message
   fg_rect( 140, 220, 104, 136 );       // clear overwrite
   fg_rect( 140, 220, 140, 172 );       // clear cancel
   fg_mousevis( ON );

   if ( ok )
   {
      fptr = fopen( filename, "wb" );
      fwrite( &fhdr, sizeof( char ), sizeof( fhdr ), fptr );
      for ( i = 0; i < 96; i++ )       // load each character
      {
         fwrite( &letters[ i ], sizeof( char ), bitmapsize, fptr );
      }
      fclose( fptr );
   }

   return;
}
/*--- end of save_font() --------------------------------------------------*/




/****************************************************************************
    PROCESS_FILL
   Left mouse button was pressed, find out what they want processed and do it.
****************************************************************************/

void process_fill( int mx, int my )
{
   int i, j, foundx = 0, foundy = 0;
   int lpx, lpy, ok, buttons;

   for ( i = 0; i < GRID_X; i++ )
   {
      if ( mx >= colarray[ i ] && mx < colarray[ i+1 ] )
      {
         foundx = 1;          // inside screen grid x coordinates
         break;
      }
   }

   if ( foundx )
   {
      for ( j = 0; j < GRID_Y; j++ )
      {
         if ( my >= rowarray[ j ] && my < rowarray[ j+1 ] )
         {
            foundy = 1;          // inside screen grid y coordinates
            break;
         }
      }
   }
   if ( foundx && foundy )       // want to hi-lite a grid block
   {
      fg_setcolor( 15 );
      fg_mousevis( OFF );
      if ( GRID_ON )
         fg_rect( colarray[ i ]+1, colarray[ i ]+4, rowarray[ j ]+1, rowarray[ j ]+4 );
      else
         fg_rect( colarray[ i ], colarray[ i ]+4, rowarray[ j ], rowarray[ j ]+4 );
      lpx = 201+i;
      lpy = 21+j;
      fg_point( lpx, lpy );
      fg_mousevis( ON );
      MADE_CHANGES = 1;
   }
   else                                   // outside screen grid coordinates
   {
      if ( my >= 315 && my <= 405 )             // character grid
      {
         if ( my >= 315 && my < 343 )           // 1st row
         {
            lpx = find_column( mx );
            if ( lpx )
            {
               fg_mousevis( OFF );
               erase_current();
               set_new( lpx, 0 );
               fg_waitfor( 2 );
               fg_mousevis( ON );
            }
         }
         else if ( my >= 343 && my < 375 )      // 2nd row
         {
            lpx = find_column( mx );
            if ( lpx )
            {
               fg_mousevis( OFF );
               erase_current();
               set_new( lpx, 1 );
               fg_waitfor( 2 );
               fg_mousevis( ON );
            }
         }
         else if ( my >= 375 && my <= 405 )     // 3rd row
         {
            lpx = find_column( mx );
            if ( lpx )
            {
               fg_mousevis( OFF );
               erase_current();
               set_new( lpx, 2 );
               fg_waitfor( 2 );
               fg_mousevis( ON );
            }
         }
      }
      else if ( ( j = at_arrow( mx, my ) ) != -1 )    // maybe moving arrows
      {
         move_arrow( j );
      }
      else if ( my >= 40 && my <= 232 )            // main menu choices
      {
         if ( mx >= 6 && mx <= 99 )
         {
            if ( my >= 40 && my <= 71 )            // clear grid
            {
               fg_mousevis( OFF );
               fg_setcolor( 12 );
               fg_paint( 7, 41 );
               draw_grid();
               load_grid();
               fg_waitfor( 2 );
               fg_mousevis( OFF );
               fg_setcolor( 1 );
               fg_paint( 7, 41 );
               fg_mousevis( ON );
            }
            else if ( my >= 72 && my <= 103 )     // load font
            {
               fg_mousevis( OFF );
               fg_setcolor( 12 );
               fg_paint( 7, 73 );
               draw_grid();
               load_font();
               fg_waitfor( 2 );
               fg_setcolor( 1 );
               fg_paint( 7, 73 );
               fg_mousevis( ON );
            }
            else if ( my >= 104 && my <= 135 )      // save font
            {
               fg_mousevis( OFF );
               fg_setcolor( 12 );
               fg_paint( 7, 105 );
               save_font();
               fg_waitfor( 2 );
               fg_setcolor( 1 );
               fg_paint( 7, 105 );
               fg_mousevis( ON );
            }
            else if ( my >= 136 && my <= 167 )      // grid on/off
            {
               fg_mousevis( OFF );
               if ( GRID_ON )
               {
                  GRID_ON = 0;
                  g_sayat(  9, 6, "ON", 0x1F );
                  g_sayat(  9, 9, "OFF", 0x1C );
               }
               else
               {
                  GRID_ON = 1;
                  g_sayat(  9, 6, "ON", 0x1C );
                  g_sayat(  9, 9, "OFF", 0x1F );
               }
               draw_grid();
               load_grid();
               fg_waitfor( 4 );
               fg_setcolor( 1 );
               fg_mousevis( ON );
            }
            else if ( my >= 168 && my <= 199 )       // Exit
            {
               ok = 1;
               if ( MADE_CHANGES )
               {
                  sprintf( buffer, " Changes have been made. Quit anyway? " );
                  g_sayat( 27, 10, buffer, 0x4F );

                  fg_setcolor( 1 );
                  fg_rect( 140, 240, 104, 136 );
                  fg_rect( 140, 240, 140, 172 );
                  fg_setcolor( 7 );
                  fg_box( 140, 240, 104, 136 );
                  fg_box( 140, 240, 140, 172 );
                  g_sayat( 7, 18, "Exit To DOS", 0x1F );
                  g_sayat( 9, 19, "Continue", 0x1F );

                  fg_sound( 800, 6 );
                  fg_sound( 400, 6 );
                  fg_mousemov( 180, 156 );
                  fg_mousevis( ON );

                  while ( 1 )
                  {
                     fg_mousepos( &mx, &my, &buttons );
                     if ( buttons == 0x01 )                  // left button
                     {
                        if ( mx >= 140 && mx <= 220 )
                        {
                           if ( my >= 104 && my <= 136 )     // quit to DOS
                           {
                              ok = 1;
                              break;
                           }
                           if ( my >= 140 && my <= 172 )     // continue
                           {
                              ok = 0;
                              break;
                           }
                        }
                     }
                  }
                  fg_mousevis( OFF );
                  fg_setcolor( 9 );
                  fg_rect( 80, 640, 432, 448 );        // clear error message
                  fg_rect( 140, 240, 104, 136 );       // clear quit to DOS
                  fg_rect( 140, 240, 140, 172 );       // clear continue
                  fg_mousevis( ON );
               }
               if ( ok )
               {
                  fg_setmode( 3 );
                  exit( 0 );
               }
            }
         }
      }
   }

   return;
}
/*--- end of process_fill() -----------------------------------------------*/




/****************************************************************************
    PROCESS_EMPTY
   Right mouse button was pressed, they want to clear a grid block.
****************************************************************************/

void process_empty( int mx, int my )
{
   int i, j, foundx = 0, foundy = 0;
   int lpx, lpy;

   for ( i = 0; i < GRID_X; i++ )
   {
      if ( mx >= colarray[ i ] && mx < colarray[ i+1 ] )
      {
         foundx = 1;
         break;
      }
   }

   if ( foundx )
   {
      for ( j = 0; j < GRID_Y; j++ )
      {
         if ( my >= rowarray[ j ] && my < rowarray[ j+1 ] )
         {
            foundy = 1;
            break;
         }
      }
   }
   if ( foundx && foundy )
   {
      fg_setcolor( 9 );
      fg_mousevis( OFF );
      if ( GRID_ON )
         fg_rect( colarray[ i ]+1, colarray[ i ]+4, rowarray[ j ]+1, rowarray[ j ]+4 );
      else
         fg_rect( colarray[ i ], colarray[ i ]+4, rowarray[ j ], rowarray[ j ]+4 );
      lpx = 201+i;
      lpy = 21+j;
      fg_setcolor( 0 );
      fg_point( lpx, lpy );
      fg_mousevis( ON );
      MADE_CHANGES = 1;
   }

   return;
}
/*--- end of process_empty() ----------------------------------------------*/




/****************************************************************************
    MAIN
   Set up the mode, draw the initial screen, process mouse movement.
****************************************************************************/

void main( int argc, char ** argv )
{
   int mx, my, buttons = 0;
   int oldmx, oldmy, i;

   fg_setmode( fg_bestmode( 640, 480, 1 ) );
   fg_setcolor( 9 );
   fg_rect( 0, 639, 0, 479 );       // clear screen

   draw_grid();

   if ( fg_mouseini() == -1 )
   {
      fg_setmode( 3 );
      printf( "Mouse Required\n" );
      exit( 0 );
   }
   fg_mousevis( ON );

   fg_setcolor( 1 );
   fg_rect( 6, 99, 40, 232 );
   fg_setcolor( 7 );
   fg_move( 6, 40 );
   fg_draw( 99, 40 );
   fg_move( 6, 72 );
   fg_draw( 99, 72 );
   fg_move( 6, 104 );
   fg_draw( 99, 104 );
   fg_move( 6, 136 );
   fg_draw( 99, 136 );
   fg_move( 6, 168 );
   fg_draw( 99, 168 );
   fg_move( 6, 200 );
   fg_draw( 99, 200 );
   fg_move( 6, 232 );
   fg_draw( 99, 232 );
   fg_move( 6, 40 );
   fg_draw( 6, 232 );
   fg_move( 99, 40 );
   fg_draw( 99, 232 );

   g_sayat(  3, 1, "CLEAR GRID", 0x1F );
   g_sayat(  5, 1, "LOAD FONT", 0x1F );
   g_sayat(  7, 1, "SAVE FONT", 0x1F );
   g_sayat(  9, 1, "GRID ON/OFF", 0x1F );
   g_sayat( 11, 1, "EXIT", 0x1F );
   g_sayat(  9, 6, "ON", 0x1C );

   g_sayat( 20, 10, "  ! \" # $ % & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ?", (char)0x9F );
   g_sayat( 22, 10, "@ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [ \\ ] ^ _", (char)0x9F );
   g_sayat( 24, 10, "` a b c d e f g h i j k l m n o p q r s t u v w x y z { | } ~",    (char)0x9F );

   fg_setcolor( 7 );
   fg_move( 75, 315 );
   fg_draw( 587, 315 );
   fg_move( 75, 343 );
   fg_draw( 587, 343 );
   fg_move( 75, 375 );
   fg_draw( 587, 375 );
   fg_move( 75, 405 );
   fg_draw( 587, 405 );

   for ( i = 75; i < 588; i += 16 )
   {
      fg_move( i, 315 );
      fg_draw( i, 405 );
   }

   fg_mousemov( 86, 86 );        // ready to load font

   while ( 1 )
   {
      fg_mousepos( &mx, &my, &buttons );
      if ( mx != oldmx || my != oldmy )
      {
         sprintf( buffer, "%3d - %3d", mx, my );
         g_sayat( 0, 0, buffer, (char)0x9F );
         oldmx = mx;
         oldmy = my;
      }
      if ( buttons == 0x01 )        // left button
      {
         process_fill( mx, my );
      }
      if ( buttons == 0x02 )        // right button
      {
         process_empty( mx, my );
      }
   }
}
/*--- end of main() -------------------------------------------------------*/

/*--- end of file ---------------------------------------------------------*/

