/**********************************************************************\
*                                                                      *
*  DEFS.H: declarations, definitions, etc. for Quickfire               *
*                                                                      *
*  Copyright 1993, 1995 Diana Gruber. All Rights Reserved.             *
*  Last modified: April 10, 1995                                       *
*                                                                      *
*  This source code is provided "as is" without any warranties, etc.   *
*                                                                      *
\**********************************************************************/

#include <fastgraf.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <io.h>
#include <malloc.h>

/* variables are only declared in one file, are external to all
   other source code files */
#ifndef loadgame
    #define DECLARE extern
#else
    #define DECLARE
#endif

/* uncomment this line to make the program run in Mode X and
real mode. Otherwise, the program requires Mode 13h and protected
mode. */

//#define ModeX

#ifndef ModeX
/********************  virtual buffers  *************************/

DECLARE char *virtbuff1;   // buffer for storage virtual buffer
DECLARE int  workvb;       // handle for workspace virtual buffer
#endif

/********************  map declarations *************************/

/* coordinates of the physical page wrt world space */
DECLARE int tile_orgx;
DECLARE int tile_orgy;

/* coordinates of the visible screen wrt the physical page */
DECLARE int screen_orgx;
DECLARE int screen_orgy;
DECLARE int screen_xmax;
DECLARE int screen_ymax;

DECLARE int world_x;
DECLARE int world_y;
DECLARE int world_maxx;
DECLARE int world_maxy;

/* visual page Y offset and hidden page Y offset */
DECLARE int vpo,vpb;
DECLARE int hpo,hpb;

/* tile page offset */
DECLARE int tpo;

DECLARE short ncols;
DECLARE short nrows;

/* maximum number of rows & cols in world space */
#define MAXROWS 60
#define MAXCOLS 280

/* tile array for level */
DECLARE unsigned char far backtile[MAXCOLS][MAXROWS];
DECLARE char layout[2][22][15];

/********************  sprite declarations *************************/

DECLARE short nsprites;
typedef struct sprt
{
	char *bitmap;
	short width;
	short height;
   short xoffset;
   short yoffset;

}  SPRITE;

DECLARE SPRITE *sprite[40];

/* forward declarations */
DECLARE struct OBJstruct;
typedef struct OBJstruct OBJ, near *OBJp;

/* pointer to object action function */
typedef void near ACTION (OBJp objp);
typedef ACTION *ACTIONp; 

/* data structure for objects */
typedef struct OBJstruct 
{
  OBJp  next; 
  OBJp  prev; 
  short x;
  short y;
  short xspeed;
  short max_xspeed;
  short yspeed;
  short direction;
  short frame;
  short tile_xmin;
  short tile_xmax;
  short tile_ymin;
  short tile_ymax;

  SPRITE *image;
  ACTIONp action; 
  OBJp attached_sprite;
};

#define MAXENEMIES 5
DECLARE OBJp player;
DECLARE OBJp top_node, bottom_node;
DECLARE OBJp enemy[MAXENEMIES];
DECLARE OBJp score;

DECLARE SPRITE *fighter[8];
DECLARE SPRITE *explosion[11];

/*********************  key declarations *************************/

#define KB_CTRL  29
#define KB_ESC    1
#define KB_LEFT  75
#define KB_RIGHT 77
#define KB_UP    72
#define KB_DOWN  80

#define LEFT   0
#define RIGHT  1
#define UP     2
#define DOWN   3

#define OK     1

/********************  file handles *************************/

DECLARE FILE *tstream;
DECLARE FILE *dstream;

/******************* miscellaneous defines ******************/

#define BETWEEN(x,a,b) ((x >= a) && (x <= b))
#define MAX(x,y) ((x) > (y)) ? (x) : (y)
#define MIN(x,y) ((x) < (y)) ? (x) : (y)

#define FALSE 0
#define TRUE  1

/******************* miscellaneous variables ****************/

DECLARE char abort_string[50];

DECLARE short clockspeed;
DECLARE short stall_time;
DECLARE int   hidden;
DECLARE int   visual;
DECLARE short seed;

DECLARE int nbullets;
DECLARE int nenemies;
DECLARE int nenemy_bullets;
DECLARE short random_number;

DECLARE int scrolled;

DECLARE int frame_count;
DECLARE int framerate;
DECLARE int frame_factor;
DECLARE int bullet_count;

DECLARE long player_timer;
DECLARE long player_time_target;

DECLARE int nhits;
DECLARE int hit_value;

DECLARE int up,down,left,right,ctrl;
DECLARE int autopilot;

DECLARE long player_score;
DECLARE unsigned long frames;

#ifdef loadgame
   unsigned char launch_palette[] = {
    9, 0, 0, 12, 0, 0, 16, 0, 0, 19, 0, 0, 23, 0, 0, 27, 0, 0, 30, 0, 0,
   34, 0, 0, 37, 0, 0, 41, 0, 0, 45, 0, 0, 48, 0, 0, 52, 0, 0, 55, 0, 0,
   59, 0, 0, 63, 0, 0, 63, 2, 2, 63, 6, 6, 63, 9, 9, 63,13,13, 63,16,16,
   63,20,20, 63,24,24, 63,27,27, 63,31,31, 63,34,34, 63,38,38, 63,41,41,
   63,45,45, 63,48,48, 63,52,52, 63,56,56,  9, 0, 0, 12, 0, 0, 16, 0, 0,
   19, 0, 0, 23, 0, 0, 27, 0, 0, 30, 0, 0, 34, 0, 0, 37, 0, 0, 41, 0, 0,
   45, 0, 0, 48, 0, 0, 52, 0, 0, 55, 0, 0, 59, 0, 0, 63, 0, 0, 63, 2, 2,
   63, 6, 6, 63, 9, 9, 63,13,13, 63,16,16, 63,20,20, 63,24,24, 63,27,27,
   63,31,31, 63,34,34, 63,38,38, 63,41,41, 63,45,45, 63,48,48, 63,52,52,
   63,56,56
   };
#else
   extern unsigned char launch_palette[];
#endif

/******************** function declarations *****************/
/* qf.c */
void  main();
void  _near activate_level(void);
void  _near adjust_layout_down(void);
void  _near adjust_layout_right(void);
void  _near adjust_layout_up(void);
void  _near apply_sprite(struct OBJstruct _near *objp);
void  _near bullet_go(struct OBJstruct _near *objp);
void  _near do_explosion(struct OBJstruct _near *objp);
void  _near do_player_explosion(struct OBJstruct _near *objp);
void  _near enemy_bullet_go(struct OBJstruct _near *objp);
void  _near enemy_go(struct OBJstruct _near *objp);
void  _near kill_bullet(struct OBJstruct _near *objp);
void  _near kill_enemy(struct OBJstruct _near *objp);
void  _near kill_enemy_bullet(struct OBJstruct _near *objp);
void  _near kill_object(struct OBJstruct _near *objp);
void  _near kill_player_explosion(struct OBJstruct _near *objp);
void  _near launch_sequence(void);
void  _near new_score(struct OBJstruct _near *objp);
void  _near page_copy(void);
void  _near player_go(void);
void  _near put_sprite(struct sprt *frame,short world_x,short world_y);
void  put_tile(short i,short j);
void  _near rebuild_hidden(void);
void  _near put_score(struct OBJstruct _near *objp);
int   scroll_right(short npixels);
int   scroll_right_down(short scroll_y);
int   scroll_right_up(short scroll_x,short scroll_y);
void  _near start_bullet(void);
void  _near start_enemy_bullet(struct OBJstruct _near *objp);
void  _near start_enemy(void);
void  _near start_explosion(struct OBJstruct _near *objp);
void  _near start_player_explosion(struct OBJstruct _near *objp);
void  _near swap(void);
void  _near warp(short x,short y);

/* loadgame.c */
void  clear_layout(void);
void  exit_screen(void);
void  fcopy_array(char _far *s,char *t,short nchar);
void  getseed(void);
void  init_globals(void);
void  init_graphics(void);
void  intro_screens(void);
int   irandom(short min,short max);
void  load_level(void);
void  load_music(void);
void  load_sprite(void);
int   put_bstring(char *string,short nchar,short ix,short iy);
void  terminate_game(void);


