#include <fgwin.h>

#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

//#include <conio.h>
//#include <ctype.h>
//#include <dos.h>
//#include <io.h>

/* variables are only declared in one file, are external to all
   other source code files */
#ifndef loadgame
    #define DECLARE extern
#else
    #define DECLARE
#endif

/********************  virtual buffers  *************************/

DECLARE char *virtbuff1;   // buffer for storage virtual buffer
DECLARE int  workvb;       // handle for workspace virtual buffer

/********************  map declarations *************************/

/* coordinates of the physical page wrt world space */
DECLARE int tile_orgx;
DECLARE int tile_orgy;

/* coordinates of the visible screen wrt the physical page */
DECLARE int screen_orgx;
DECLARE int screen_orgy;
DECLARE int screen_xmax;
DECLARE int screen_ymax;

DECLARE int world_x;
DECLARE int world_y;
DECLARE int world_maxx;
DECLARE int world_maxy;

/* visual page Y offset and hidden page Y offset */
DECLARE int vpo,vpb;
DECLARE int hpo,hpb;

/* tile page offset */
DECLARE int tpo;

DECLARE short ncols;
DECLARE short nrows;

/* maximum number of rows & cols in world space */
#define MAXROWS 60
#define MAXCOLS 280

/* tile array for level */
DECLARE unsigned char far backtile[MAXCOLS][MAXROWS];
DECLARE char layout[2][22][15];

/***************  logical palette declarations *********************/
DECLARE HPALETTE hpal;

/***************  virtual buffer handles ***************************/
DECLARE int hvb;

/******************  Windows-related globals ***********************/
DECLARE UINT cxClient, cyClient;

/********************  sprite declarations *************************/

DECLARE short nsprites;
typedef struct sprt
{
   char *bitmap;
   short width;
   short height;
   short xoffset;
   short yoffset;
}  SPRITE;

DECLARE SPRITE *sprite[40];

/* forward declarations */
//DECLARE struct OBJstruct;
typedef struct OBJstruct OBJ, near *OBJp;

/* pointer to object action function */
typedef void near ACTION (OBJp objp);
typedef ACTION *ACTIONp; 

/* data structure for objects */
typedef struct OBJstruct 
{
  OBJp  next; 
  OBJp  prev; 
  short x;
  short y;
  short xspeed;
  short max_xspeed;
  short yspeed;
  short direction;
  short frame;
  short tile_xmin;
  short tile_xmax;
  short tile_ymin;
  short tile_ymax;

  SPRITE *image;
  ACTIONp action; 
  OBJp attached_sprite;
};

#define MAXENEMIES 5
DECLARE OBJp player;
DECLARE OBJp top_node, bottom_node;
DECLARE OBJp enemy[MAXENEMIES];
DECLARE OBJp score;

DECLARE SPRITE *fighter[8];
DECLARE SPRITE *explosion[11];

/*********************  key declarations *************************/

#define KB_CTRL  29
#define KB_ESC    1
#define KB_LEFT  75
#define KB_RIGHT 77
#define KB_UP    72
#define KB_DOWN  80

#define LEFT   0
#define RIGHT  1
#define UP     2
#define DOWN   3

#define OK     1

/********************  file handles *************************/

DECLARE FILE *tstream;
DECLARE FILE *dstream;

/******************* miscellaneous defines ******************/

#define BETWEEN(x,a,b) ((x >= a) && (x <= b))
#define MAX(x,y) ((x) > (y)) ? (x) : (y)
#define MIN(x,y) ((x) < (y)) ? (x) : (y)

#define FALSE 0
#define TRUE  1

/******************* miscellaneous variables ****************/

DECLARE char abort_string[50];

DECLARE short clockspeed;
DECLARE short stall_time;
DECLARE int   hidden;
DECLARE int   visual;
DECLARE short seed;
DECLARE int   intro_mode;

DECLARE int nbullets;
DECLARE int nenemies;
DECLARE int nenemy_bullets;
DECLARE short random_number;

DECLARE int scrolled;

DECLARE int frame_count;
DECLARE int framerate;
DECLARE int frame_factor;
DECLARE int bullet_count;

DECLARE long player_timer;
DECLARE long player_time_target;

DECLARE int nhits;
DECLARE int target_hits;
DECLARE int hit_value;

DECLARE int up,down,left,right,ctrl;
DECLARE int autopilot;

DECLARE long player_score;

/******************** function declarations *****************/
/* qf.c */
long  WINAPI _export WindowProc(HWND,UINT,UINT,LONG);
void  _near activate_level(void);
void  _near adjust_layout_down(void);
void  _near adjust_layout_right(void);
void  _near adjust_layout_up(void);
void  _near apply_sprite(struct OBJstruct _near *objp);
void  _near bullet_go(struct OBJstruct _near *objp);
void  _near do_explosion(struct OBJstruct _near *objp);
void  _near do_player_explosion(struct OBJstruct _near *objp);
void  _near enemy_bullet_go(struct OBJstruct _near *objp);
void  _near enemy_go(struct OBJstruct _near *objp);
void  init_qf(void);
void  _near kill_bullet(struct OBJstruct _near *objp);
void  _near kill_enemy(struct OBJstruct _near *objp);
void  _near kill_enemy_bullet(struct OBJstruct _near *objp);
void  _near kill_explosion(struct OBJstruct _near *objp);
void  _near kill_player_explosion(struct OBJstruct _near *objp);
void  _near launch_sequence(void);
void  _near new_score(struct OBJstruct _near *objp);
void  _near page_copy(void);
void  _near player_go(void);
void  _near put_sprite(struct sprt *frame,short world_x,short world_y);
void  put_tile(short i,short j);
void  _near rebuild_hidden(void);
void  _near put_score(struct OBJstruct _near *objp);
int   scroll_right(short npixels);
int   scroll_right_down(short scroll_y);
int   scroll_right_up(short scroll_x,short scroll_y);
void  _near start_bullet(void);
void  _near start_enemy_bullet(struct OBJstruct _near *objp);
void  _near start_enemy(void);
void  _near start_explosion(struct OBJstruct _near *objp);
void  _near start_player_explosion(struct OBJstruct _near *objp);
void  _near swap(void);
void  _near warp(short x,short y);

/* loadgame.c */
void  clear_layout(void);
void  exit_screen(void);
void  fcopy_array(char _far *s,char *t,short nchar);
void  getseed(void);
void  init_globals(void);
void  init_graphics(void);
int   irandom(short min,short max);
void  load_level(void);
void  load_music(void);
void  load_sprite(void);
int   put_bstring(char *string,short nchar,short ix,short iy);
void  terminate_game(void);
