program Bug;  { It's a Starbug! }

uses FGDriv,
     FGMain,
     FGMisc,
     FGBitmap,
     FGPCX,
     Tools;

const
  Mode    = Mode_X;
  Pages   = 3;
  Ainc    = 5;
  XWidth  = 126;
  YHeight = 86;
  Idx     : array[0..7] of integer = (0,1,2,3,4,3,2,1);
  YAxis   = 180;
  XInc    = 1;

var
  figure : array [0..5] of pointer;
  f      : file;
  n      : string[40];
  yinc   : array[0..359] of integer;
  sIdx   : integer;

procedure SetUpYinc;
var
  a : real;
  i : integer;
begin
  a := 0;
  for i := 0 to 359 do
    begin
      yinc[i] := trunc(15 * sin(a));
      a := a + 0.0174532;
    end;
end;

procedure SourcePage;far;
var i,x,y:integer;
begin
  randomize;
  fg_setcolor(255);      { This palette slot is "white" }
  for i := 0 to 100 do
    begin
      x := random(FGDriv.MaxX+1);   { Random starfield }
      y := random(FGDriv.MaxY+1);
      fg_point(x,y);
    end;
  fg_move(160 - 63,143);                  { Planet }
  fg_putimage(figure[5]^,XWidth,YHeight);
end;

function NextIndex:integer;
begin
  inc(sIdx);
  if sIdx > 7 then
    sIdx := 0;
  NextIndex := Idx[sIdx];
end;

procedure Travel;
var a,i,x : integer;
begin
  a := 0;
  x := -XWidth;
  while x < FGDriv.MaxX + 40 do
    begin
      Tools.SwapActivePage;
      fg_move(x,YAxis + yinc[a]);
      fg_flpimage(figure[NextIndex]^,XWidth,YHeight);
      Tools.SwapVisualPage;
      inc(x,XInc);
      inc(a,AInc);
      a := a mod 360;
    end;
end;

procedure TravelBack;
var a,i,x : integer;
begin
  a := 0;
  x := FGDriv.MaxX + 40;
  while x > -XWidth do
    begin
      Tools.SwapActivePage;
      fg_move(x,YAxis + yinc[a]);
      fg_clpimage(figure[NextIndex]^,XWidth,YHeight);
      Tools.SwapVisualPage;
      dec(x,XInc);
      inc(a,AInc);
      a := a mod 360;
    end;
end;

begin
  SetUpYinc;

  Tools.LoadFigure('BUG.RES',10836,6,figure);

  fg_waitfor(9);

  if fg_testmode(Mode,Pages) = 1 then
    begin
      FGDriv.SelectGraphMode(Mode);
      FGDriv.GraphInit;
      Tools.ReadPalette('BUG.PAL');
      Tools.SetSourcePage(2);
      Tools.CreateSourcePage(SourcePage);
      fg_setpage(0);
      Travel;
      fg_waitfor(36);
      TravelBack;
      fg_setcolor(0);
      fg_fadeout(15);
      fg_setpage(0);
      fg_setvpage(0);
      FGDriv.CloseGraphMode;
    end
  else
    writeln('Can''t select that video mode with ',Pages,' pages');
end.
