/*
        Routines for mouse
*/
#include <dos.h>
#include <conio.h>
#include "fdestria.h"
#include "fdesign.h"
#include "fdesequa.h"
#include "fdesfile.h"
#include "fdesmenu.h"
#include "fdesplot.h"

typedef struct {
	int row,col,buttons;
	} mouse_state;
#define MOUSE_LEFT 1
#define MOUSE_RIGHT 2

int mouse_is;                    /* if nonzero, there is a mouse */
int use_grat;
/************************************************************************
        MOUSE STUFF
************************************************************************/
/*
	this is to be the mouse cursor pixel array
        16 words screen mask
        16 words cursor mask
*/
int m_cursor[32] = {
	0xffff,           /* (2)x0000000000000000, */
        0x8fff,           /* (2)x0111000000000000, */
	0x81ff,           /* (2)x0111111000000000, */
	0x803f,           /* (2)x0111111111000000, */
	0x8007,           /* (2)x0111111111111000, */
	0x8000,           /* (2)x0111111111111111, */
	0x8007,           /* (2)x0111111111111000, */
	0x803f,           /* (2)x0111111111000000, */
	0x827f,           /* (2)x0111110110000000, */
	0x9f3f,           /* (2)x0110000011000000, */
        0xff9f,           /* (2)x0000000001100000, */
        0xffcf,           /* (2)x0000000000110000, */
        0xffe7,           /* (2)x0000000000011000, */
	0xffff,           /* (2)x0000000000000000, */
	0xffff,           /* (2)x0000000000000000, */
	0xffff,           /* (2)x0000000000000000  */

        0x0000,
        0x7000,
        0x7e00,
        0x7fc0,
        0x7ff8,
        0x7fff,
        0x7ff8,
        0x7fc0,
        0x7d80,
        0x60c0,
        0x0060,
        0x0030,
        0x0018,
        0x0000,
        0x0000,
        0x0000
        } ;

int mouse_reset(void)           /* returns -1 if ok, 0 if no mouse driver */
{
int rcode;
struct REGPACK regs;
        regs.r_ax = 0x0000;             /* mouse reset */
        intr(0x33,&regs);
        rcode = regs.r_ax;
        if (rcode != 0) {               /* NOTE: return code */
                regs.r_ax = 0x0009;     /* mouse set cursor bitmap */
                regs.r_bx = 0;          /* column in bitmap */
                regs.r_cx = 0;          /* row in bitmap */
                regs.r_es = FP_SEG((void far *)m_cursor); /* segment of bitmap */
                regs.r_dx = FP_OFF((void far *)m_cursor); /* offset of bitmap */
                intr(0x33,&regs);
                mouse_is = 1;
                return(rcode);
        }
        else {
                mouse_is = 0;
                return (rcode);
        }
}
void mouse_on(void)		/* enables the mouse cursor */
{
struct REGPACK regs;
        if (!mouse_is) return;
	regs.r_ax = 0x0001;
	intr(0x33,&regs);
}
void mouse_off(void)		/* disables the mouse cursor */
{
struct REGPACK regs;
        if (!mouse_is) return;
	regs.r_ax = 0x0002;
	intr(0x33,&regs);
}
int mouse_get(mouse_state *m)		/* get mouse position and button status */
{
struct REGPACK regs;
        if (!mouse_is) return(0);
	regs.r_ax = 0x0003;
	intr(0x33,&regs);
	(*m).row = regs.r_dx;
	(*m).col = regs.r_cx;
	(*m).buttons = regs.r_bx;
	return((*m).buttons);
}
void mouse_put(mouse_state *m) 		/* put mouse at position */
{
struct REGPACK regs;
	if (!mouse_is) return;
        regs.r_ax = 0x0004;
	regs.r_cx = (*m).col;
	regs.r_dx = (*m).row;
	intr(0x33,&regs);
}
/*
        05h     Return Button Press Data
        entry   AL?     05h
                BX      button
                        0 left
                        1 right
                        2 middle (Mouse Systems mouse)
        return  AL?     button states
                        bit 0   left button pressed if 1
                        bit 1   right button pressed if 1
                        bit 2   middle button pressed if 1 (Mouse Systems mouse)
                BX      no. of times specified button pressed since last call
                CX      column at time specified button was last pressed
                DX      row at time specified button was last pressed
*/
int mouse_press(mouse_state *m)
{
struct REGPACK regs;
        if (!mouse_is) return(0);
        regs.r_ax = 0x0005;
        regs.r_bx = 0;
        intr(0x33,&regs);
	(*m).row = regs.r_dx;
	(*m).col = regs.r_cx;
        (*m).buttons = regs.r_ax;
        if (regs.r_bx) return(regs.r_ax);
        regs.r_ax = 0x0005;
        regs.r_bx = 1;
        intr(0x33,&regs);
	(*m).row = regs.r_dx;
	(*m).col = regs.r_cx;
        (*m).buttons = regs.r_ax;
        if (regs.r_bx) return(regs.r_ax);
        return(0);
}
/**************************************************************************
        A job to do while waiting on the mouse click
***************************************************************************/
int mouse_idle(void)
{
        return(0);
}
int (*mouse_idle_job)(void) = mouse_idle;       /* the mouse idle task */
int mouse_click(mouse_state *m)	/* mouse wait until click */
{
int rcode;
	mouse_on();
	/* get next button press */
	do {
                mouse_idle_job();
                rcode = mouse_press(m);
	} while ((!rcode)&&(!kbhit()));          /* loop while no button pressed */
	mouse_off();
        if (kbhit()) {
                getch();
                return(0x02);
        }
	return(rcode);
}
int mouse_click_grat(mouse_state *m)	/* mouse wait until click */
{
int rcode;
int xres,yres;
	xres = maxx/GRAT_X;
	yres = maxy/GRAT_Y;
	rcode = mouse_click(m);
        if (use_grat) {
                /* adjust mouse position to nearest graticule point */
                (*m).row = (((*m).row + (yres/2)) / yres) * yres;
                (*m).col = (((*m).col + (xres/2)) / xres) * xres;
        }
	return(rcode);
}
