Tim,
Here is a testpt.c file to display the "phoenix_m" mandel stye map and its
julia equivalent "phoenix_j".  Best params for phoenix_j are 0.56667 and -0.5
at 256 iterations. Space could be saved in FRACTINT by switching on symmetry
which is NOSYM for phoenix_m and XAXIS for phoenix_j.   B.Smurf

 #include "fractint.h"
 #include "fractype.h"

 extern double magnitude;
 extern struct complex init,tmp,old,new,saved;

 void teststart()
 {
 }

 void testend()
 {
 }

 testpt(initreal,initimag,parm1,parm2,maxit,inside)
 double initreal,initimag,parm1,parm2;
 int maxit,inside;
 {
 double x_square, y_square, x_temp, y_temp, r , i;
 int color;
    color = x_square = y_square = new.x = new.y = 0;
    magnitude = 0.0;
    if (parm1) {  /* Julia style */
       old.x = initreal; old.y = initimag;
       r = parm1; i = parm2;
       }
    else {        /* Mandelbrot style */
       old.x = old.y = 0;
       r = initreal; i = initimag;
       }
    while ((magnitude < 4.0) && (color < maxit)) {
       x_square = old.x * old.x;
       y_square = old.y * old.y;
       x_temp = x_square - y_square + r + i * new.x;
       y_temp = 2 * old.x * old.y + i * new.y;
       new.x = old.x;  new.y = old.y;
       old.x = x_temp; old.y = y_temp;
       magnitude = x_square + y_square;
       color++;
       }
 if (color >= maxit) color = inside;
 return(color);
 }
